/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util;

import com.aspose.imaging.internal.bouncycastle.asn1.cms.GCMParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.DSTU7624Engine;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CTSBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.EAXBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.GCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.GOFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.KCCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.KGCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.OCBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.OFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.SICBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.ISO10126d2Padding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.TBCPadding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.X923Padding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.ZeroBytePadding;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithSBox;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RC2Parameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RC5Parameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.PBKDF1Key;
import com.aspose.imaging.internal.bouncycastle.jcajce.PBKDF1KeyWithParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.PKCS12Key;
import com.aspose.imaging.internal.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.AEADParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.RepeatedSecretKeySpec;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseBlockCipher
extends BaseWrapCipher
implements PBE {
    private static final Class a = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.spec.GCMParameterSpec");
    private Class[] b = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, a, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
    private BlockCipher c;
    private BlockCipherProvider d;
    private c e;
    private ParametersWithIV f;
    private AEADParameters g;
    private int h;
    private int i = -1;
    private int j;
    private int k = 0;
    private boolean l;
    private boolean m = true;
    private PBEParameterSpec n = null;
    private String o = null;
    private String p = null;

    protected BaseBlockCipher(BlockCipher blockCipher) {
        this.c = blockCipher;
        this.e = new b(blockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n2, int n3, int n4, int n5) {
        this.c = blockCipher;
        this.i = n2;
        this.j = n3;
        this.h = n4;
        this.k = n5;
        this.e = new b(blockCipher);
    }

    protected BaseBlockCipher(BlockCipherProvider blockCipherProvider) {
        this.c = blockCipherProvider.get();
        this.d = blockCipherProvider;
        this.e = new b(blockCipherProvider.get());
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher) {
        this.c = aEADBlockCipher.getUnderlyingCipher();
        this.k = this.c.getBlockSize();
        this.e = new a(aEADBlockCipher);
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher, boolean bl2, int n2) {
        this.c = aEADBlockCipher.getUnderlyingCipher();
        this.m = bl2;
        this.k = n2;
        this.e = new a(aEADBlockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n2) {
        this(blockCipher, true, n2);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, boolean bl2, int n2) {
        this.c = blockCipher;
        this.m = bl2;
        this.e = new b(blockCipher);
        this.k = n2 / 8;
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, int n2) {
        this(bufferedBlockCipher, true, n2);
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, boolean bl2, int n2) {
        this.c = bufferedBlockCipher.getUnderlyingCipher();
        this.e = new b(bufferedBlockCipher);
        this.m = bl2;
        this.k = n2 / 8;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.c.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.g != null) {
            return this.g.getNonce();
        }
        return this.f != null ? this.f.getIV() : null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n2) {
        return this.e.a(n2);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.n != null) {
                try {
                    this.engineParams = this.createParametersInstance(this.o);
                    this.engineParams.init(this.n);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.g != null) {
                try {
                    this.engineParams = this.createParametersInstance("GCM");
                    this.engineParams.init(new GCMParameters(this.g.getNonce(), this.g.getMacSize() / 8).getEncoded());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
            if (this.f != null) {
                String string = this.e.c().getAlgorithmName();
                if (string.indexOf(47) >= 0) {
                    string = string.substring(0, string.indexOf(47));
                }
                try {
                    this.engineParams = this.createParametersInstance(string);
                    this.engineParams.init(new IvParameterSpec(this.f.getIV()));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
        }
        return this.engineParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.p = Strings.toUpperCase(string);
        if (this.p.equals("ECB")) {
            this.k = 0;
            this.e = new b(this.c);
            return;
        } else if (this.p.equals("CBC")) {
            this.k = this.c.getBlockSize();
            this.e = new b(new CBCBlockCipher(this.c));
            return;
        } else if (this.p.startsWith("OFB")) {
            this.k = this.c.getBlockSize();
            if (this.p.length() != 3) {
                int n2 = Integer.parseInt(this.p.substring(3));
                this.e = new b(new OFBBlockCipher(this.c, n2));
                return;
            } else {
                this.e = new b(new OFBBlockCipher(this.c, 8 * this.c.getBlockSize()));
            }
            return;
        } else if (this.p.startsWith("CFB")) {
            this.k = this.c.getBlockSize();
            if (this.p.length() != 3) {
                int n3 = Integer.parseInt(this.p.substring(3));
                this.e = new b(new CFBBlockCipher(this.c, n3));
                return;
            } else {
                this.e = new b(new CFBBlockCipher(this.c, 8 * this.c.getBlockSize()));
            }
            return;
        } else if (this.p.startsWith("PGP")) {
            boolean bl2 = this.p.equalsIgnoreCase("PGPCFBwithIV");
            this.k = this.c.getBlockSize();
            this.e = new b(new PGPCFBBlockCipher(this.c, bl2));
            return;
        } else if (this.p.equalsIgnoreCase("OpenPGPCFB")) {
            this.k = 0;
            this.e = new b(new OpenPGPCFBBlockCipher(this.c));
            return;
        } else if (this.p.startsWith("SIC")) {
            this.k = this.c.getBlockSize();
            if (this.k < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.m = false;
            this.e = new b(new BufferedBlockCipher(new SICBlockCipher(this.c)));
            return;
        } else if (this.p.startsWith("CTR")) {
            this.k = this.c.getBlockSize();
            this.m = false;
            this.e = this.c instanceof DSTU7624Engine ? new b(new BufferedBlockCipher(new KCTRBlockCipher(this.c))) : new b(new BufferedBlockCipher(new SICBlockCipher(this.c)));
            return;
        } else if (this.p.startsWith("GOFB")) {
            this.k = this.c.getBlockSize();
            this.e = new b(new BufferedBlockCipher(new GOFBBlockCipher(this.c)));
            return;
        } else if (this.p.startsWith("GCFB")) {
            this.k = this.c.getBlockSize();
            this.e = new b(new BufferedBlockCipher(new GCFBBlockCipher(this.c)));
            return;
        } else if (this.p.startsWith("CTS")) {
            this.k = this.c.getBlockSize();
            this.e = new b(new CTSBlockCipher(new CBCBlockCipher(this.c)));
            return;
        } else if (this.p.startsWith("CCM")) {
            this.k = 12;
            this.e = this.c instanceof DSTU7624Engine ? new a(new KCCMBlockCipher(this.c)) : new a(new CCMBlockCipher(this.c));
            return;
        } else if (this.p.startsWith("OCB")) {
            if (this.d == null) throw new NoSuchAlgorithmException("can't support mode " + string);
            this.k = 15;
            this.e = new a(new OCBBlockCipher(this.c, this.d.get()));
            return;
        } else if (this.p.startsWith("EAX")) {
            this.k = this.c.getBlockSize();
            this.e = new a(new EAXBlockCipher(this.c));
            return;
        } else {
            if (!this.p.startsWith("GCM")) throw new NoSuchAlgorithmException("can't support mode " + string);
            this.k = this.c.getBlockSize();
            this.e = this.c instanceof DSTU7624Engine ? new a(new KGCMBlockCipher(this.c)) : new a(new GCMBlockCipher(this.c));
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            if (this.e.b()) {
                this.e = new b(new BufferedBlockCipher(this.e.c()));
            }
        } else if (string2.equals("WITHCTS")) {
            this.e = new b(new CTSBlockCipher(this.e.c()));
        } else {
            this.l = true;
            if (this.a(this.p)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
                this.e = new b(this.e.c());
            } else if (string2.equals("ZEROBYTEPADDING")) {
                this.e = new b(this.e.c(), new ZeroBytePadding());
            } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
                this.e = new b(this.e.c(), new ISO10126d2Padding());
            } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
                this.e = new b(this.e.c(), new X923Padding());
            } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
                this.e = new b(this.e.c(), new ISO7816d4Padding());
            } else if (string2.equals("TBCPADDING")) {
                this.e = new b(this.e.c(), new TBCPadding());
            } else {
                throw new NoSuchPaddingException("Padding " + string + " unknown.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        this.n = null;
        this.o = null;
        this.engineParams = null;
        this.g = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + (key != null ? key.getAlgorithm() : null) + " not suitable for symmetric enryption.");
        }
        if (algorithmParameterSpec == null && this.c.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (this.i == 2 || key instanceof PKCS12Key) {
            try {
                object3 = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.n = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object3 instanceof PBEKey && this.n == null) {
                object2 = (PBEKey)object3;
                if (object2.getSalt() == null) {
                    throw new InvalidAlgorithmParameterException("PBEKey requires parameters to specify salt");
                }
                this.n = new PBEParameterSpec(object2.getSalt(), object2.getIterationCount());
            }
            if (this.n == null && !(object3 instanceof PBEKey)) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (key instanceof BCPBEKey) {
                object2 = ((BCPBEKey)key).getParam();
                if (object2 instanceof ParametersWithIV) {
                    object = object2;
                } else {
                    if (object2 != null) throw new InvalidKeyException("Algorithm requires a PBE key suitable for PKCS12");
                    object = PBE.Util.makePBEParameters(object3.getEncoded(), 2, this.j, this.h, this.k * 8, this.n, this.e.a());
                }
            } else {
                object = PBE.Util.makePBEParameters(object3.getEncoded(), 2, this.j, this.h, this.k * 8, this.n, this.e.a());
            }
            if (object instanceof ParametersWithIV) {
                this.f = (ParametersWithIV)object;
            }
        } else if (key instanceof PBKDF1Key) {
            object3 = (PBKDF1Key)key;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.n = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object3 instanceof PBKDF1KeyWithParameters && this.n == null) {
                this.n = new PBEParameterSpec(((PBKDF1KeyWithParameters)object3).getSalt(), ((PBKDF1KeyWithParameters)object3).getIterationCount());
            }
            if ((object = PBE.Util.makePBEParameters(((PBKDF1Key)object3).getEncoded(), 0, this.j, this.h, this.k * 8, this.n, this.e.a())) instanceof ParametersWithIV) {
                this.f = (ParametersWithIV)object;
            }
        } else if (key instanceof BCPBEKey) {
            object3 = (BCPBEKey)key;
            this.o = ((BCPBEKey)object3).getOID() != null ? ((BCPBEKey)object3).getOID().getId() : ((BCPBEKey)object3).getAlgorithm();
            if (((BCPBEKey)object3).getParam() != null) {
                object = this.a(algorithmParameterSpec, ((BCPBEKey)object3).getParam());
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                this.n = (PBEParameterSpec)algorithmParameterSpec;
                object = PBE.Util.makePBEParameters((BCPBEKey)object3, algorithmParameterSpec, this.e.c().getAlgorithmName());
            }
            if (object instanceof ParametersWithIV) {
                this.f = (ParametersWithIV)object;
            }
        } else if (key instanceof PBEKey) {
            object3 = (PBEKey)key;
            this.n = (PBEParameterSpec)algorithmParameterSpec;
            if (object3 instanceof PKCS12KeyWithParameters && this.n == null) {
                this.n = new PBEParameterSpec(object3.getSalt(), object3.getIterationCount());
            }
            if ((object = PBE.Util.makePBEParameters(object3.getEncoded(), this.i, this.j, this.h, this.k * 8, this.n, this.e.a())) instanceof ParametersWithIV) {
                this.f = (ParametersWithIV)object;
            }
        } else if (!(key instanceof RepeatedSecretKeySpec)) {
            if (this.i == 0 || this.i == 4 || this.i == 1 || this.i == 5) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            object = new KeyParameter(key.getEncoded());
        } else {
            object = null;
        }
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            if (!this.a(this.p) && !(this.e instanceof a)) {
                throw new InvalidAlgorithmParameterException("AEADParameterSpec can only be used with AEAD modes.");
            }
            object3 = (AEADParameterSpec)algorithmParameterSpec;
            object2 = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
            this.g = new AEADParameters((KeyParameter)object2, ((AEADParameterSpec)object3).getMacSizeInBits(), ((AEADParameterSpec)object3).getNonce(), ((AEADParameterSpec)object3).getAssociatedData());
            object = this.g;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.k != 0) {
                object3 = (IvParameterSpec)algorithmParameterSpec;
                if (((IvParameterSpec)object3).getIV().length != this.k && !(this.e instanceof a) && this.m) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.k + " bytes long.");
                }
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((IvParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((IvParameterSpec)object3).getIV());
                this.f = (ParametersWithIV)object;
            } else if (this.p != null && this.p.equals("ECB")) {
                throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
            }
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            object3 = (GOST28147ParameterSpec)algorithmParameterSpec;
            object = new ParametersWithSBox(new KeyParameter(key.getEncoded()), ((GOST28147ParameterSpec)algorithmParameterSpec).getSbox());
            if (((GOST28147ParameterSpec)object3).getIV() != null && this.k != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((GOST28147ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((GOST28147ParameterSpec)object3).getIV());
                this.f = (ParametersWithIV)object;
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            object3 = (RC2ParameterSpec)algorithmParameterSpec;
            object = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
            if (((RC2ParameterSpec)object3).getIV() != null && this.k != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((RC2ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((RC2ParameterSpec)object3).getIV());
                this.f = (ParametersWithIV)object;
            }
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            object3 = (RC5ParameterSpec)algorithmParameterSpec;
            object = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)algorithmParameterSpec).getRounds());
            if (!this.c.getAlgorithmName().startsWith("RC5")) throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            if (this.c.getAlgorithmName().equals("RC5-32")) {
                if (((RC5ParameterSpec)object3).getWordSize() != 32) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + ((RC5ParameterSpec)object3).getWordSize() + ".");
                }
            } else if (this.c.getAlgorithmName().equals("RC5-64") && ((RC5ParameterSpec)object3).getWordSize() != 64) {
                throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + ((RC5ParameterSpec)object3).getWordSize() + ".");
            }
            if (((RC5ParameterSpec)object3).getIV() != null && this.k != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((RC5ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((RC5ParameterSpec)object3).getIV());
                this.f = (ParametersWithIV)object;
            }
        } else if (a != null && a.isInstance(algorithmParameterSpec)) {
            if (!this.a(this.p) && !(this.e instanceof a)) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec can only be used with AEAD modes.");
            }
            try {
                object3 = a.getDeclaredMethod("getTLen", new Class[0]);
                object2 = a.getDeclaredMethod("getIV", new Class[0]);
                KeyParameter keyParameter = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
                this.g = new AEADParameters(keyParameter, (Integer)((Method)object3).invoke((Object)algorithmParameterSpec, new Object[0]), (byte[])((Method)object2).invoke((Object)algorithmParameterSpec, new Object[0]));
                object = this.g;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
            }
        } else if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.k != 0 && !(object instanceof ParametersWithIV) && !(object instanceof AEADParameters)) {
            object3 = secureRandom;
            if (object3 == null) {
                object3 = new SecureRandom();
            }
            if (n2 == 1 || n2 == 3) {
                object2 = new byte[this.k];
                ((SecureRandom)object3).nextBytes((byte[])object2);
                object = new ParametersWithIV((CipherParameters)object, (byte[])object2);
                this.f = (ParametersWithIV)object;
            } else if (this.e.c().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (secureRandom != null && this.l) {
            object = new ParametersWithRandom((CipherParameters)object, secureRandom);
        }
        try {
            switch (n2) {
                case 1: 
                case 3: {
                    this.e.a(true, (CipherParameters)object);
                    break;
                }
                case 2: 
                case 4: {
                    this.e.a(false, (CipherParameters)object);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + n2 + " passed");
                }
            }
            if (!(this.e instanceof a) || this.g != null) return;
            object3 = ((a)this.e).b;
            this.g = new AEADParameters((KeyParameter)this.f.getParameters(), object3.getMac().length * 8, this.f.getIV());
            return;
        }
        catch (Exception exception) {
            throw new d(exception.getMessage(), exception);
        }
    }

    private CipherParameters a(AlgorithmParameterSpec algorithmParameterSpec, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            CipherParameters cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
                this.f = new ParametersWithIV(cipherParameters2, ivParameterSpec.getIV());
                cipherParameters = this.f;
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
                cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSbox());
                if (gOST28147ParameterSpec.getIV() != null && this.k != 0) {
                    this.f = new ParametersWithIV(cipherParameters2, gOST28147ParameterSpec.getIV());
                    cipherParameters = this.f;
                }
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.f = new ParametersWithIV(cipherParameters, ivParameterSpec.getIV());
            cipherParameters = this.f;
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
            cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSbox());
            if (gOST28147ParameterSpec.getIV() != null && this.k != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, gOST28147ParameterSpec.getIV());
            }
        }
        return cipherParameters;
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.b.length; ++i2) {
                if (this.b[i2] == null) continue;
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.b[i2]);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n2, int n3) {
        this.e.a(byArray, n2, n3);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.limit() - byteBuffer.position();
        this.engineUpdateAAD(byteBuffer.array(), n2, n3);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = this.e.b(n3);
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            int n5 = this.e.a(byArray, n2, n3, byArray2, 0);
            if (n5 == 0) {
                return null;
            }
            if (n5 != byArray2.length) {
                byte[] byArray3 = new byte[n5];
                System.arraycopy(byArray2, 0, byArray3, 0, n5);
                return byArray3;
            }
            return byArray2;
        }
        this.e.a(byArray, n2, n3, null, 0);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n4 + this.e.b(n3) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            return this.e.a(byArray, n2, n3, byArray2, n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalStateException(dataLengthException.toString());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
        if (n3 != 0) {
            n4 = this.e.a(byArray, n2, n3, byArray2, 0);
        }
        try {
            n4 += this.e.a(byArray2, n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        if (n4 == byArray2.length) {
            return byArray2;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int n5 = 0;
        if (n4 + this.engineGetOutputSize(n3) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            if (n3 != 0) {
                n5 = this.e.a(byArray, n2, n3, byArray2, n4);
            }
            return n5 + this.e.a(byArray2, n4 + n5);
        }
        catch (OutputLengthException outputLengthException) {
            throw new IllegalBlockSizeException(outputLengthException.getMessage());
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
    }

    private boolean a(String string) {
        return "CCM".equals(string) || "EAX".equals(string) || "GCM".equals(string) || "OCB".equals(string);
    }

    private static class a
    implements c {
        private static final Constructor a;
        private AEADBlockCipher b;

        private static Constructor a(Class clazz) {
            try {
                return clazz.getConstructor(String.class);
            }
            catch (Exception exception) {
                return null;
            }
        }

        a(AEADBlockCipher aEADBlockCipher) {
            this.b = aEADBlockCipher;
        }

        @Override
        public void a(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.b.init(bl2, cipherParameters);
        }

        @Override
        public String a() {
            return this.b.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public BlockCipher c() {
            return this.b.getUnderlyingCipher();
        }

        @Override
        public int a(int n2) {
            return this.b.getOutputSize(n2);
        }

        @Override
        public int b(int n2) {
            return this.b.getUpdateOutputSize(n2);
        }

        @Override
        public void a(byte[] byArray, int n2, int n3) {
            this.b.processAADBytes(byArray, n2, n3);
        }

        @Override
        public int a(byte by2, byte[] byArray, int n2) throws DataLengthException {
            return this.b.processByte(by2, byArray, n2);
        }

        @Override
        public int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
            return this.b.processBytes(byArray, n2, n3, byArray2, n4);
        }

        @Override
        public int a(byte[] byArray, int n2) throws IllegalStateException, BadPaddingException {
            try {
                return this.b.doFinal(byArray, n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (a != null) {
                    BadPaddingException badPaddingException = null;
                    try {
                        badPaddingException = (BadPaddingException)a.newInstance(invalidCipherTextException.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (badPaddingException != null) {
                        throw badPaddingException;
                    }
                }
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }

        static {
            Class clazz = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.AEADBadTagException");
            a = clazz != null ? com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher$a.a(clazz) : null;
        }
    }

    private static class b
    implements c {
        private BufferedBlockCipher a;

        b(BufferedBlockCipher bufferedBlockCipher) {
            this.a = bufferedBlockCipher;
        }

        b(BlockCipher blockCipher) {
            this.a = new PaddedBufferedBlockCipher(blockCipher);
        }

        b(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
            this.a = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        }

        @Override
        public void a(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.a.init(bl2, cipherParameters);
        }

        @Override
        public boolean b() {
            return !(this.a instanceof CTSBlockCipher);
        }

        @Override
        public String a() {
            return this.a.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public BlockCipher c() {
            return this.a.getUnderlyingCipher();
        }

        @Override
        public int a(int n2) {
            return this.a.getOutputSize(n2);
        }

        @Override
        public int b(int n2) {
            return this.a.getUpdateOutputSize(n2);
        }

        @Override
        public void a(byte[] byArray, int n2, int n3) {
            throw new UnsupportedOperationException("AAD is not supported in the current mode.");
        }

        @Override
        public int a(byte by2, byte[] byArray, int n2) throws DataLengthException {
            return this.a.processByte(by2, byArray, n2);
        }

        @Override
        public int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
            return this.a.processBytes(byArray, n2, n3, byArray2, n4);
        }

        @Override
        public int a(byte[] byArray, int n2) throws IllegalStateException, BadPaddingException {
            try {
                return this.a.doFinal(byArray, n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
    }

    private static interface c {
        public void a(boolean var1, CipherParameters var2) throws IllegalArgumentException;

        public boolean b();

        public String a();

        public BlockCipher c();

        public int a(int var1);

        public int b(int var1);

        public void a(byte[] var1, int var2, int var3);

        public int a(byte var1, byte[] var2, int var3) throws DataLengthException;

        public int a(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataLengthException;

        public int a(byte[] var1, int var2) throws IllegalStateException, BadPaddingException;
    }

    private static class d
    extends InvalidKeyException {
        private final Throwable a;

        d(String string, Throwable throwable) {
            super(string);
            this.a = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }
}

