/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.SM4Engine;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.CMac;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.GMac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.GCMBlockCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.l;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.p;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4 {
    private SM4() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = this.createParametersInstance("SM4");
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SM4Engine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new l());
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SM4Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SM4", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends p {
        private static final String a = SM4.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.SM4", a + "$AlgParams");
            configurableProvider.addAlgorithm("AlgorithmParameterGenerator.SM4", a + "$AlgParamGen");
            configurableProvider.addAlgorithm("Cipher.SM4", a + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.SM4", a + "$KeyGen");
            this.addCMacAlgorithm(configurableProvider, "SM4", a + "$CMAC", a + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "SM4", a + "$GMAC", a + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SM4", a + "$Poly1305", a + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.aspose.imaging.internal.bouncycastle.crypto.macs.Poly1305(new SM4Engine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SM4", 256, new Poly1305KeyGenerator());
        }
    }
}

