/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PKCS12BagAttributeCarrierImpl
implements PKCS12BagAttributeCarrier {
    private Hashtable a;
    private Vector b;

    PKCS12BagAttributeCarrierImpl(Hashtable hashtable, Vector vector) {
        this.a = hashtable;
        this.b = vector;
    }

    public PKCS12BagAttributeCarrierImpl() {
        this(new Hashtable(), new Vector());
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        if (this.a.containsKey(aSN1ObjectIdentifier)) {
            this.a.put(aSN1ObjectIdentifier, aSN1Encodable);
        } else {
            this.a.put(aSN1ObjectIdentifier, aSN1Encodable);
            this.b.addElement(aSN1ObjectIdentifier);
        }
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (ASN1Encodable)this.a.get(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.b.elements();
    }

    int size() {
        return this.b.size();
    }

    Hashtable getAttributes() {
        return this.a;
    }

    Vector getOrdering() {
        return this.b;
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.b.size() == 0) {
            objectOutputStream.writeObject(new Hashtable());
            objectOutputStream.writeObject(new Vector());
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            Enumeration enumeration = this.getBagAttributeKeys();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                aSN1OutputStream.writeObject(aSN1ObjectIdentifier);
                aSN1OutputStream.writeObject((ASN1Encodable)this.a.get(aSN1ObjectIdentifier));
            }
            objectOutputStream.writeObject(byteArrayOutputStream.toByteArray());
        }
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (object instanceof Hashtable) {
            this.a = (Hashtable)object;
            this.b = (Vector)objectInputStream.readObject();
        } else {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1InputStream aSN1InputStream = new ASN1InputStream((byte[])object);
            while ((aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1InputStream.readObject()) != null) {
                this.setBagAttribute(aSN1ObjectIdentifier, aSN1InputStream.readObject());
            }
        }
    }
}

