/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.eac;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ParsingException;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.CVCertificateRequest;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.aspose.imaging.internal.bouncycastle.eac.EACException;
import com.aspose.imaging.internal.bouncycastle.eac.EACIOException;
import com.aspose.imaging.internal.bouncycastle.eac.operator.EACSignatureVerifier;
import java.io.IOException;
import java.io.OutputStream;

public class EACCertificateRequestHolder {
    private CVCertificateRequest a;

    private static CVCertificateRequest a(byte[] byArray) throws IOException {
        try {
            return CVCertificateRequest.getInstance(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new EACIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EACIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            if (aSN1ParsingException.getCause() instanceof IOException) {
                throw (IOException)aSN1ParsingException.getCause();
            }
            throw new EACIOException("malformed data: " + aSN1ParsingException.getMessage(), aSN1ParsingException);
        }
    }

    public EACCertificateRequestHolder(byte[] byArray) throws IOException {
        this(EACCertificateRequestHolder.a(byArray));
    }

    public EACCertificateRequestHolder(CVCertificateRequest cVCertificateRequest) {
        this.a = cVCertificateRequest;
    }

    public CVCertificateRequest toASN1Structure() {
        return this.a;
    }

    public PublicKeyDataObject getPublicKeyDataObject() {
        return this.a.getPublicKey();
    }

    public boolean isInnerSignatureValid(EACSignatureVerifier eACSignatureVerifier) throws EACException {
        try {
            OutputStream outputStream = eACSignatureVerifier.getOutputStream();
            outputStream.write(this.a.getCertificateBody().getEncoded("DER"));
            outputStream.close();
            return eACSignatureVerifier.verify(this.a.getInnerSignature());
        }
        catch (Exception exception) {
            throw new EACException("unable to process signature: " + exception.getMessage(), exception);
        }
    }
}

