/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.dvcs;

import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.CertEtcToken;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.DVCSTime;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.Data;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.ServiceType;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.dvcs.DVCSException;
import com.aspose.imaging.internal.bouncycastle.dvcs.DVCSRequest;
import com.aspose.imaging.internal.bouncycastle.dvcs.DVCSRequestBuilder;
import com.aspose.imaging.internal.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List a = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.a.add(new TargetEtcChain(new CertEtcToken(0, x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.a.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.a.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.a.toArray(new TargetEtcChain[this.a.size()]));
        return this.createDVCRequest(data);
    }
}

