/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.tls;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class SSL3Mac
implements Mac {
    private static final byte a = 54;
    private static final byte b = 92;
    static final byte[] IPAD = SSL3Mac.a((byte)54, 48);
    static final byte[] OPAD = SSL3Mac.a((byte)92, 48);
    private Digest c;
    private int d;
    private byte[] e;

    public SSL3Mac(Digest digest) {
        this.c = digest;
        this.d = digest.getDigestSize() == 20 ? 40 : 48;
    }

    @Override
    public String getAlgorithmName() {
        return this.c.getAlgorithmName() + "/SSL3MAC";
    }

    public Digest getUnderlyingDigest() {
        return this.c;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.e = Arrays.clone(((KeyParameter)cipherParameters).getKey());
        this.reset();
    }

    @Override
    public int getMacSize() {
        return this.c.getDigestSize();
    }

    @Override
    public void update(byte by2) {
        this.c.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.c.update(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[this.c.getDigestSize()];
        this.c.doFinal(byArray2, 0);
        this.c.update(this.e, 0, this.e.length);
        this.c.update(OPAD, 0, this.d);
        this.c.update(byArray2, 0, byArray2.length);
        int n3 = this.c.doFinal(byArray, n2);
        this.reset();
        return n3;
    }

    @Override
    public void reset() {
        this.c.reset();
        this.c.update(this.e, 0, this.e.length);
        this.c.update(IPAD, 0, this.d);
    }

    private static byte[] a(byte by2, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, by2);
        return byArray;
    }
}

