/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg;

import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTNamedCurves;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.EntropySource;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.DualECPoints;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DualECSP800DRBG
implements SP80090DRBG {
    private static final BigInteger a = new BigInteger("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", 16);
    private static final BigInteger b = new BigInteger("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", 16);
    private static final BigInteger c = new BigInteger("c97445f45cdef9f0d3e05e1e585fc297235b82b5be8ff3efca67c59852018192", 16);
    private static final BigInteger d = new BigInteger("b28ef557ba31dfcbdd21ac46e2a91e3c304f44cb87058ada2cb815151e610046", 16);
    private static final BigInteger e = new BigInteger("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", 16);
    private static final BigInteger f = new BigInteger("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f", 16);
    private static final BigInteger g = new BigInteger("8e722de3125bddb05580164bfe20b8b432216a62926c57502ceede31c47816edd1e89769124179d0b695106428815065", 16);
    private static final BigInteger h = new BigInteger("023b1660dd701d0839fd45eec36f9ee7b32e13b315dc02610aa1b636e346df671f790f84c5e09b05674dbb7e45c803dd", 16);
    private static final BigInteger i = new BigInteger("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", 16);
    private static final BigInteger j = new BigInteger("11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650", 16);
    private static final BigInteger k = new BigInteger("1b9fa3e518d683c6b65763694ac8efbaec6fab44f2276171a42726507dd08add4c3b3f4c1ebc5b1222ddba077f722943b24c3edfa0f85fe24d0c8c01591f0be6f63", 16);
    private static final BigInteger l = new BigInteger("1f3bdba585295d9a1110d1df1f9430ef8442c5018976ff3437ef91b81dc0b8132c8d5c39c32d0e004a3092b7d327c0e7a4d26d2c7b69b58f9066652911e457779de", 16);
    private static final DualECPoints[] m = new DualECPoints[3];
    private static final long n = 0x80000000L;
    private static final int o = 4096;
    private static final int p = 4096;
    private static final int q = 4096;
    private Digest r;
    private long s;
    private EntropySource t;
    private int u;
    private int v;
    private int w;
    private ECCurve.Fp x;
    private ECPoint y;
    private ECPoint z;
    private byte[] A;
    private int B;
    private ECMultiplier C = new FixedPointCombMultiplier();

    public DualECSP800DRBG(Digest digest, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this(m, digest, n2, entropySource, byArray, byArray2);
    }

    public DualECSP800DRBG(DualECPoints[] dualECPointsArray, Digest digest, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this.r = digest;
        this.t = entropySource;
        this.u = n2;
        if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(byArray, 512)) {
            throw new IllegalArgumentException("Personalization string too large");
        }
        if (entropySource.entropySize() < n2 || entropySource.entropySize() > 4096) {
            throw new IllegalArgumentException("EntropySource must provide between " + n2 + " and " + 4096 + " bits");
        }
        byte[] byArray3 = this.a();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        for (int i2 = 0; i2 != dualECPointsArray.length; ++i2) {
            if (n2 > dualECPointsArray[i2].getSecurityStrength()) continue;
            if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(digest) < dualECPointsArray[i2].getSecurityStrength()) {
                throw new IllegalArgumentException("Requested security strength is not supported by digest");
            }
            this.v = dualECPointsArray[i2].getSeedLen();
            this.w = dualECPointsArray[i2].getMaxOutlen() / 8;
            this.y = dualECPointsArray[i2].getP();
            this.z = dualECPointsArray[i2].getQ();
            break;
        }
        if (this.y == null) {
            throw new IllegalArgumentException("security strength cannot be greater than 256 bits");
        }
        this.A = com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(this.r, byArray4, this.v);
        this.B = this.A.length;
        this.s = 0L;
    }

    @Override
    public int getBlockSize() {
        return this.w * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        BigInteger bigInteger;
        int n2 = byArray.length * 8;
        int n3 = byArray.length / this.w;
        if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(byArray2, 512)) {
            throw new IllegalArgumentException("Additional input too large");
        }
        if (this.s + (long)n3 > 0x80000000L) {
            return -1;
        }
        if (bl2) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (byArray2 != null) {
            byArray2 = com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(this.r, byArray2, this.v);
            bigInteger = new BigInteger(1, this.a(this.A, byArray2));
        } else {
            bigInteger = new BigInteger(1, this.A);
        }
        Arrays.fill(byArray, (byte)0);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte[] byArray3 = this.a(this.z, bigInteger = this.a(this.y, bigInteger)).toByteArray();
            if (byArray3.length > this.w) {
                System.arraycopy(byArray3, byArray3.length - this.w, byArray, n4, this.w);
            } else {
                System.arraycopy(byArray3, 0, byArray, n4 + (this.w - byArray3.length), byArray3.length);
            }
            n4 += this.w;
            ++this.s;
        }
        if (n4 < byArray.length) {
            bigInteger = this.a(this.y, bigInteger);
            byte[] byArray4 = this.a(this.z, bigInteger).toByteArray();
            int n5 = byArray.length - n4;
            if (byArray4.length > this.w) {
                System.arraycopy(byArray4, byArray4.length - this.w, byArray, n4, n5);
            } else {
                System.arraycopy(byArray4, 0, byArray, n4 + (this.w - byArray4.length), n5);
            }
            ++this.s;
        }
        this.A = BigIntegers.asUnsignedByteArray(this.B, this.a(this.y, bigInteger));
        return n2;
    }

    @Override
    public void reseed(byte[] byArray) {
        if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(byArray, 512)) {
            throw new IllegalArgumentException("Additional input string too large");
        }
        byte[] byArray2 = this.a();
        byte[] byArray3 = Arrays.concatenate(this.a(this.A, this.v), byArray2, byArray);
        this.A = com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(this.r, byArray3, this.v);
        this.s = 0L;
    }

    private byte[] a() {
        byte[] byArray = this.t.getEntropy();
        if (byArray.length < (this.u + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray3.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
        return byArray3;
    }

    private byte[] a(byte[] byArray, int n2) {
        if (n2 % 8 == 0) {
            return byArray;
        }
        int n3 = 8 - n2 % 8;
        int n4 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            int n5 = byArray[i2] & 0xFF;
            byArray[i2] = (byte)(n5 << n3 | n4 >> 8 - n3);
            n4 = n5;
        }
        return byArray;
    }

    private BigInteger a(ECPoint eCPoint, BigInteger bigInteger) {
        return this.C.multiply(eCPoint, bigInteger).normalize().getAffineXCoord().toBigInteger();
    }

    static {
        ECCurve.Fp fp2 = (ECCurve.Fp)NISTNamedCurves.getByName("P-256").getCurve();
        DualECSP800DRBG.m[0] = new DualECPoints(128, fp2.createPoint(a, b), fp2.createPoint(c, d), 1);
        fp2 = (ECCurve.Fp)NISTNamedCurves.getByName("P-384").getCurve();
        DualECSP800DRBG.m[1] = new DualECPoints(192, fp2.createPoint(e, f), fp2.createPoint(g, h), 1);
        fp2 = (ECCurve.Fp)NISTNamedCurves.getByName("P-521").getCurve();
        DualECSP800DRBG.m[2] = new DualECPoints(256, fp2.createPoint(i, j), fp2.createPoint(k, l), 1);
    }
}

