/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.params;

import com.aspose.imaging.internal.bouncycastle.crypto.params.DHKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHParameters;
import java.math.BigInteger;

public class DHPublicKeyParameters
extends DHKeyParameters {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private BigInteger c;

    public DHPublicKeyParameters(BigInteger bigInteger, DHParameters dHParameters) {
        super(false, dHParameters);
        this.c = this.a(bigInteger, dHParameters);
    }

    private BigInteger a(BigInteger bigInteger, DHParameters dHParameters) {
        if (bigInteger == null) {
            throw new NullPointerException("y value cannot be null");
        }
        if (bigInteger.compareTo(b) < 0 || bigInteger.compareTo(dHParameters.getP().subtract(b)) > 0) {
            throw new IllegalArgumentException("invalid DH public key");
        }
        if (dHParameters.getQ() != null) {
            if (a.equals(bigInteger.modPow(dHParameters.getQ(), dHParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    public BigInteger getY() {
        return this.c;
    }

    @Override
    public int hashCode() {
        return this.c.hashCode() ^ super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DHPublicKeyParameters)) {
            return false;
        }
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)object;
        return dHPublicKeyParameters.getY().equals(this.c) && super.equals(object);
    }
}

