/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.generators;

import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.MacDerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KDFCounterParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFCounterBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger a = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private final Mac c;
    private final int d;
    private byte[] e;
    private byte[] f;
    private int g;
    private byte[] h;
    private int i;
    private byte[] j;

    public KDFCounterBytesGenerator(Mac mac) {
        this.c = mac;
        this.d = mac.getMacSize();
        this.j = new byte[this.d];
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof KDFCounterParameters)) {
            throw new IllegalArgumentException("Wrong type of arguments given");
        }
        KDFCounterParameters kDFCounterParameters = (KDFCounterParameters)derivationParameters;
        this.c.init(new KeyParameter(kDFCounterParameters.getKI()));
        this.e = kDFCounterParameters.getFixedInputDataCounterPrefix();
        this.f = kDFCounterParameters.getFixedInputDataCounterSuffix();
        int n2 = kDFCounterParameters.getR();
        this.h = new byte[n2 / 8];
        BigInteger bigInteger = b.pow(n2).multiply(BigInteger.valueOf(this.d));
        this.g = bigInteger.compareTo(a) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
        this.i = 0;
    }

    @Override
    public Mac getMac() {
        return this.c;
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        int n4 = this.i + n3;
        if (n4 < 0 || n4 >= this.g) {
            throw new DataLengthException("Current KDFCTR may only be used for " + this.g + " bytes");
        }
        if (this.i % this.d == 0) {
            this.a();
        }
        int n5 = n3;
        int n6 = this.i % this.d;
        int n7 = this.d - this.i % this.d;
        int n8 = Math.min(n7, n5);
        System.arraycopy(this.j, n6, byArray, n2, n8);
        this.i += n8;
        n5 -= n8;
        n2 += n8;
        while (n5 > 0) {
            this.a();
            n8 = Math.min(this.d, n5);
            System.arraycopy(this.j, 0, byArray, n2, n8);
            this.i += n8;
            n5 -= n8;
            n2 += n8;
        }
        return n3;
    }

    private void a() {
        int n2 = this.i / this.d + 1;
        switch (this.h.length) {
            case 4: {
                this.h[0] = (byte)(n2 >>> 24);
            }
            case 3: {
                this.h[this.h.length - 3] = (byte)(n2 >>> 16);
            }
            case 2: {
                this.h[this.h.length - 2] = (byte)(n2 >>> 8);
            }
            case 1: {
                this.h[this.h.length - 1] = (byte)n2;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported size of counter i");
            }
        }
        this.c.update(this.e, 0, this.e.length);
        this.c.update(this.h, 0, this.h.length);
        this.c.update(this.f, 0, this.f.length);
        this.c.doFinal(this.j, 0);
    }
}

