/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.generators;

import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.imaging.internal.bouncycastle.crypto.params.HKDFParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;

public class HKDFBytesGenerator
implements DerivationFunction {
    private HMac a;
    private int b;
    private byte[] c;
    private byte[] d;
    private int e;

    public HKDFBytesGenerator(Digest digest) {
        this.a = new HMac(digest);
        this.b = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof HKDFParameters)) {
            throw new IllegalArgumentException("HKDF parameters required for HKDFBytesGenerator");
        }
        HKDFParameters hKDFParameters = (HKDFParameters)derivationParameters;
        if (hKDFParameters.skipExtract()) {
            this.a.init(new KeyParameter(hKDFParameters.getIKM()));
        } else {
            this.a.init(this.a(hKDFParameters.getSalt(), hKDFParameters.getIKM()));
        }
        this.c = hKDFParameters.getInfo();
        this.e = 0;
        this.d = new byte[this.b];
    }

    private KeyParameter a(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            this.a.init(new KeyParameter(new byte[this.b]));
        } else {
            this.a.init(new KeyParameter(byArray));
        }
        this.a.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.b];
        this.a.doFinal(byArray3, 0);
        return new KeyParameter(byArray3);
    }

    private void a() throws DataLengthException {
        int n2 = this.e / this.b + 1;
        if (n2 >= 256) {
            throw new DataLengthException("HKDF cannot generate more than 255 blocks of HashLen size");
        }
        if (this.e != 0) {
            this.a.update(this.d, 0, this.b);
        }
        this.a.update(this.c, 0, this.c.length);
        this.a.update((byte)n2);
        this.a.doFinal(this.d, 0);
    }

    public Digest getDigest() {
        return this.a.getUnderlyingDigest();
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (this.e + n3 > 255 * this.b) {
            throw new DataLengthException("HKDF may only be used for 255 * HashLen bytes of output");
        }
        if (this.e % this.b == 0) {
            this.a();
        }
        int n4 = n3;
        int n5 = this.e % this.b;
        int n6 = this.b - this.e % this.b;
        int n7 = Math.min(n6, n4);
        System.arraycopy(this.d, n5, byArray, n2, n7);
        this.e += n7;
        n4 -= n7;
        n2 += n7;
        while (n4 > 0) {
            this.a();
            n7 = Math.min(this.b, n4);
            System.arraycopy(this.d, 0, byArray, n2, n7);
            this.e += n7;
            n4 -= n7;
            n2 += n7;
        }
        return n3;
    }
}

