/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetStringParser;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1SequenceParser;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1SetParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSet;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.EnvelopedDataParser;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.OriginatorInformation;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientInformationStore;
import com.aspose.imaging.internal.bouncycastle.cms.h;
import com.aspose.imaging.internal.bouncycastle.cms.j;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore recipientInfoStore;
    EnvelopedDataParser envelopedData = new EnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier a;
    private AttributeTable b;
    private boolean c = true;
    private OriginatorInformation d;

    public CMSEnvelopedDataParser(byte[] byArray) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSEnvelopedDataParser(InputStream inputStream) throws CMSException, IOException {
        super(inputStream);
        OriginatorInfo originatorInfo = this.envelopedData.getOriginatorInfo();
        if (originatorInfo != null) {
            this.d = new OriginatorInformation(originatorInfo);
        }
        ASN1Set aSN1Set = ASN1Set.getInstance(this.envelopedData.getRecipientInfos().toASN1Primitive());
        EncryptedContentInfoParser encryptedContentInfoParser = this.envelopedData.getEncryptedContentInfo();
        this.a = encryptedContentInfoParser.getContentEncryptionAlgorithm();
        j j2 = new j(((ASN1OctetStringParser)encryptedContentInfoParser.getEncryptedContent(4)).getOctetStream());
        h.c c2 = new h.c(this.a, j2);
        this.recipientInfoStore = h.a(aSN1Set, this.a, c2);
    }

    public String getEncryptionAlgOID() {
        return this.a.getAlgorithm().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.a(this.a.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.a;
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.d;
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this.b == null && this.c) {
            ASN1SetParser aSN1SetParser = this.envelopedData.getUnprotectedAttrs();
            this.c = false;
            if (aSN1SetParser != null) {
                ASN1Encodable aSN1Encodable;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((aSN1Encodable = aSN1SetParser.readObject()) != null) {
                    ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1Encodable;
                    aSN1EncodableVector.add(aSN1SequenceParser.toASN1Primitive());
                }
                this.b = new AttributeTable(new DERSet(aSN1EncodableVector));
            }
        }
        return this.b;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }
}

