/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetStringParser;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1SequenceParser;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1SetParser;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSet;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AuthenticatedDataParser;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.CMSAttributes;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSContentInfoParser;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.OriginatorInformation;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientInformationStore;
import com.aspose.imaging.internal.bouncycastle.cms.g;
import com.aspose.imaging.internal.bouncycastle.cms.h;
import com.aspose.imaging.internal.bouncycastle.cms.j;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSAuthenticatedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore recipientInfoStore;
    AuthenticatedDataParser authData = new AuthenticatedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private AlgorithmIdentifier a;
    private byte[] b;
    private AttributeTable c;
    private ASN1Set d;
    private AttributeTable e;
    private boolean f = true;
    private boolean g;
    private OriginatorInformation h;

    public CMSAuthenticatedDataParser(byte[] byArray) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSAuthenticatedDataParser(byte[] byArray, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        this(new ByteArrayInputStream(byArray), digestCalculatorProvider);
    }

    public CMSAuthenticatedDataParser(InputStream inputStream) throws CMSException, IOException {
        this(inputStream, null);
    }

    public CMSAuthenticatedDataParser(InputStream inputStream, DigestCalculatorProvider digestCalculatorProvider) throws CMSException, IOException {
        super(inputStream);
        OriginatorInfo originatorInfo = this.authData.getOriginatorInfo();
        if (originatorInfo != null) {
            this.h = new OriginatorInformation(originatorInfo);
        }
        ASN1Set aSN1Set = ASN1Set.getInstance(this.authData.getRecipientInfos().toASN1Primitive());
        this.a = this.authData.getMacAlgorithm();
        AlgorithmIdentifier algorithmIdentifier = this.authData.getDigestAlgorithm();
        if (algorithmIdentifier != null) {
            if (digestCalculatorProvider == null) {
                throw new CMSException("a digest calculator provider is required if authenticated attributes are present");
            }
            ContentInfoParser contentInfoParser = this.authData.getEncapsulatedContentInfo();
            j j2 = new j(((ASN1OctetStringParser)contentInfoParser.getContent(4)).getOctetStream());
            try {
                h.b b2 = new h.b(digestCalculatorProvider.get(algorithmIdentifier), j2);
                this.recipientInfoStore = com.aspose.imaging.internal.bouncycastle.cms.h.a(aSN1Set, this.a, b2, new g(this));
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        } else {
            ContentInfoParser contentInfoParser = this.authData.getEncapsulatedContentInfo();
            j j3 = new j(((ASN1OctetStringParser)contentInfoParser.getContent(4)).getOctetStream());
            h.a a2 = new h.a(this.a, j3);
            this.recipientInfoStore = com.aspose.imaging.internal.bouncycastle.cms.h.a(aSN1Set, this.a, a2);
        }
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.h;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.a;
    }

    public String getMacAlgOID() {
        return this.a.getAlgorithm().toString();
    }

    public byte[] getMacAlgParams() {
        try {
            return this.a(this.a.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public byte[] getMac() throws IOException {
        if (this.b == null) {
            this.getAuthAttrs();
            this.b = this.authData.getMac().getOctets();
        }
        return Arrays.clone(this.b);
    }

    private ASN1Set a() throws IOException {
        if (this.c == null && this.f) {
            ASN1SetParser aSN1SetParser = this.authData.getAuthAttrs();
            if (aSN1SetParser != null) {
                this.d = (ASN1Set)aSN1SetParser.toASN1Primitive();
            }
            this.f = false;
        }
        return this.d;
    }

    public AttributeTable getAuthAttrs() throws IOException {
        ASN1Set aSN1Set;
        if (this.c == null && this.f && (aSN1Set = this.a()) != null) {
            this.c = new AttributeTable(aSN1Set);
        }
        return this.c;
    }

    public AttributeTable getUnauthAttrs() throws IOException {
        if (this.e == null && this.g) {
            ASN1SetParser aSN1SetParser = this.authData.getUnauthAttrs();
            this.g = false;
            if (aSN1SetParser != null) {
                ASN1Encodable aSN1Encodable;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((aSN1Encodable = aSN1SetParser.readObject()) != null) {
                    ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1Encodable;
                    aSN1EncodableVector.add(aSN1SequenceParser.toASN1Primitive());
                }
                this.e = new AttributeTable(new DERSet(aSN1EncodableVector));
            }
        }
        return this.e;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public byte[] getContentDigest() {
        if (this.c != null) {
            return ASN1OctetString.getInstance(this.c.get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }

    static /* synthetic */ ASN1Set access$000(CMSAuthenticatedDataParser cMSAuthenticatedDataParser) throws IOException {
        return cMSAuthenticatedDataParser.a();
    }
}

