/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.ocsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Exception;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.OCSPResponse;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.ResponseBytes;
import com.aspose.imaging.internal.bouncycastle.cert.CertIOException;
import com.aspose.imaging.internal.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.aspose.imaging.internal.bouncycastle.cert.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;
    private OCSPResponse a;

    public OCSPResp(OCSPResponse oCSPResponse) {
        this.a = oCSPResponse;
    }

    public OCSPResp(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public OCSPResp(InputStream inputStream) throws IOException {
        this(new ASN1InputStream(inputStream));
    }

    private OCSPResp(ASN1InputStream aSN1InputStream) throws IOException {
        try {
            this.a = OCSPResponse.getInstance(aSN1InputStream.readObject());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed response: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed response: " + classCastException.getMessage(), classCastException);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertIOException("malformed response: " + aSN1Exception.getMessage(), aSN1Exception);
        }
        if (this.a == null) {
            throw new CertIOException("malformed response: no response data found");
        }
    }

    public int getStatus() {
        return this.a.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes responseBytes = this.a.getResponseBytes();
        if (responseBytes == null) {
            return null;
        }
        if (responseBytes.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(responseBytes.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(aSN1Primitive));
            }
            catch (Exception exception) {
                throw new OCSPException("problem decoding object: " + exception, exception);
            }
        }
        return responseBytes.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OCSPResp)) {
            return false;
        }
        OCSPResp oCSPResp = (OCSPResp)object;
        return this.a.equals(oCSPResp.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public OCSPResponse toASN1Structure() {
        return this.a;
    }
}

