/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.CMPCertificate;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIBody;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIHeader;
import java.util.Enumeration;

public class PKIMessage
extends ASN1Object {
    private PKIHeader a;
    private PKIBody b;
    private DERBitString c;
    private ASN1Sequence d;

    private PKIMessage(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = PKIHeader.getInstance(enumeration.nextElement());
        this.b = PKIBody.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.c = DERBitString.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.d = ASN1Sequence.getInstance(aSN1TaggedObject, true);
        }
    }

    public static PKIMessage getInstance(Object object) {
        if (object instanceof PKIMessage) {
            return (PKIMessage)object;
        }
        if (object != null) {
            return new PKIMessage(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString, CMPCertificate[] cMPCertificateArray) {
        this.a = pKIHeader;
        this.b = pKIBody;
        this.c = dERBitString;
        if (cMPCertificateArray != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 < cMPCertificateArray.length; ++i2) {
                aSN1EncodableVector.add(cMPCertificateArray[i2]);
            }
            this.d = new DERSequence(aSN1EncodableVector);
        }
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString) {
        this(pKIHeader, pKIBody, dERBitString, null);
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody) {
        this(pKIHeader, pKIBody, null, null);
    }

    public PKIHeader getHeader() {
        return this.a;
    }

    public PKIBody getBody() {
        return this.b;
    }

    public DERBitString getProtection() {
        return this.c;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.d == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.d.size()];
        for (int i2 = 0; i2 < cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance(this.d.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        this.a(aSN1EncodableVector, 0, this.c);
        this.a(aSN1EncodableVector, 1, this.d);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

