/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.BodyPartID;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.CertificationRequest;

public class TaggedCertificationRequest
extends ASN1Object {
    private final BodyPartID a;
    private final CertificationRequest b;

    public TaggedCertificationRequest(BodyPartID bodyPartID, CertificationRequest certificationRequest) {
        this.a = bodyPartID;
        this.b = certificationRequest;
    }

    private TaggedCertificationRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = CertificationRequest.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static TaggedCertificationRequest getInstance(Object object) {
        if (object instanceof TaggedCertificationRequest) {
            return (TaggedCertificationRequest)object;
        }
        if (object != null) {
            return new TaggedCertificationRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static TaggedCertificationRequest getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return TaggedCertificationRequest.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

