/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.tiff.TiffFrame;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.gW.h;
import com.aspose.imaging.internal.kN.I;
import com.aspose.imaging.internal.kN.g;
import com.aspose.imaging.internal.pR.d;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.Stream;
import java.lang.ref.WeakReference;

public final class TiffImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private static final String h = "frame";
    private static final String i = "Frame belongs to other image";
    private final List<TiffFrame> j = new List();
    private int k = 18761;
    private TiffFrame l;

    public TiffImage(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException(h);
        }
        this.addFrame(tiffFrame);
        this.k = tiffFrame.getFrameOptions().getByteOrder();
        this.setActiveFrame(tiffFrame);
        this.setDataLoader(new a(this));
        this.setUseRawData(false);
    }

    public TiffImage(TiffFrame[] tiffFrameArray) {
        if (tiffFrameArray == null) {
            throw new ArgumentNullException("frames");
        }
        if (tiffFrameArray.length > 0) {
            this.addFrames(tiffFrameArray);
            this.setActiveFrame(tiffFrameArray[0]);
            this.k = this.getActiveFrame().getFrameOptions().getByteOrder();
        }
        this.setDataLoader(new a(this));
        this.setUseRawData(false);
    }

    @Override
    public long getFileFormat() {
        return 32L;
    }

    @Override
    public boolean getPremultiplyComponents() {
        return this.getActiveFrame().getFrameOptions().getPremultiplyComponents();
    }

    @Override
    public void setPremultiplyComponents(boolean bl2) {
        this.getActiveFrame().getFrameOptions().setPremultiplyComponents(bl2);
        this.getActiveFrame().r();
    }

    public int getByteOrder() {
        this.verifyNotDisposed();
        return this.k;
    }

    public void setByteOrder(int n2) {
        this.verifyNotDisposed();
        this.k = n2;
        this.d(true);
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            return super.getHorizontalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getXresolution().getValue();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            this.setResolution(d2, super.getVerticalResolution());
        } else {
            this.setResolution(d2, this.getActiveFrame().getFrameOptions().getYresolution().getValue());
        }
        this.d(true);
    }

    @Override
    public double getVerticalResolution() {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            return super.getVerticalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getYresolution().getValue();
    }

    @Override
    public void setVerticalResolution(double d2) {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            this.setResolution(super.getHorizontalResolution(), d2);
        } else {
            this.setResolution(this.getActiveFrame().getFrameOptions().getXresolution().getValue(), d2);
        }
        this.d(true);
    }

    public TiffFrame getActiveFrame() {
        this.verifyNotDisposed();
        if (this.l == null) {
            if (this.j.isEmpty()) {
                throw new TiffImageException("There is no active frame selected.");
            }
            this.l = this.j.get(0);
        }
        return this.l;
    }

    public void setActiveFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame != null && tiffFrame.getContainer() != this) {
            throw new TiffImageException("The active frame cannot be set as it belongs to another image.");
        }
        this.l = tiffFrame;
    }

    public TiffFrame[] getFrames() {
        this.verifyNotDisposed();
        TiffFrame[] tiffFrameArray = new TiffFrame[this.j.size()];
        this.j.copyToTArray((TiffFrame[])tiffFrameArray, 0);
        return tiffFrameArray;
    }

    public ExifData getExifData() {
        return this.l.getExifData();
    }

    public void setExifData(ExifData exifData) {
        this.l.setExifData(exifData);
    }

    @Override
    public int getPageCount() {
        return this.getFrames().length;
    }

    @Override
    public Image[] getPages() {
        return this.getFrames();
    }

    @Override
    @Deprecated
    public Image getDefaultPage() {
        return this.getActiveFrame();
    }

    @Override
    public boolean hasAlpha() {
        return super.hasAlpha();
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        if (this.l != null) {
            return this.l.getFrameOptions();
        }
        if (this.j.size() > 0) {
            TiffFrame tiffFrame = this.j.get_Item(0);
            return tiffFrame.getFrameOptions();
        }
        throw new TiffImageException("There is no original options that can be extracted from image");
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.addFrame(new TiffFrame(rasterImage));
    }

    public void alignResolutions() {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.alignResolutions();
        }
    }

    @Override
    public void setResolution(double d2, double d3) {
        TiffOptions tiffOptions = this.getActiveFrame().getFrameOptions();
        tiffOptions.setXresolution(new TiffRational(I.h(d2)));
        tiffOptions.setYresolution(new TiffRational(I.h(d3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeAngle(boolean bl2, Color color) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.A_();
                for (TiffFrame tiffFrame : this.getFrames()) {
                    tiffFrame.normalizeAngle(bl2, color.Clone());
                }
            }
            finally {
                this.e();
            }
        }
    }

    public void addFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame.getContainer() != null && tiffFrame.getContainer() != this) {
            throw new TiffImageException(i);
        }
        tiffFrame.a(this);
        this.j.addItem(tiffFrame);
    }

    public void add(TiffImage tiffImage) {
        int n2 = tiffImage.j.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = tiffImage.j.get_Item(i2);
            if (tiffFrame == null) continue;
            TiffFrame tiffFrame2 = TiffFrame.copyFrame(tiffFrame);
            this.addFrame(tiffFrame2);
        }
    }

    public void addFrames(TiffFrame[] tiffFrameArray) {
        this.verifyNotDisposed();
        if (tiffFrameArray == null) {
            throw new TiffImageException("Frames parameter is null");
        }
        for (TiffFrame tiffFrame : tiffFrameArray) {
            if (tiffFrame == null) {
                throw new TiffImageException("Frame is null or not TiffFrame type");
            }
            if (tiffFrame.getContainer() == this || tiffFrame.getContainer() == null) continue;
            throw new TiffImageException(i);
        }
        for (TiffFrame tiffFrame : tiffFrameArray) {
            tiffFrame.a(this);
        }
        this.j.addRange(com.aspose.imaging.internal.kN.g.a(tiffFrameArray));
    }

    public void insertFrame(int n2, TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new TiffImageException("Frame Is NULL");
        }
        if (tiffFrame.getContainer() != this && tiffFrame.getContainer() != null) {
            throw new TiffImageException(i);
        }
        if (this.j.size() <= n2 || n2 < 0) {
            throw new TiffImageException("Invalid index or Frame is null");
        }
        this.j.insertItem(n2, tiffFrame);
        tiffFrame.a(this);
    }

    public TiffFrame replaceFrame(int n2, TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new TiffImageException("Frame Is NULL");
        }
        if (tiffFrame.getContainer() != this && tiffFrame.getContainer() != null) {
            throw new TiffImageException(i);
        }
        if (this.j.size() <= n2 || n2 < 0) {
            throw new TiffImageException("Invalid index");
        }
        tiffFrame.a(this);
        TiffFrame tiffFrame2 = this.j.get_Item(n2);
        this.j.removeAt(n2);
        this.j.insertItem(n2, tiffFrame);
        if (this.getActiveFrame() == tiffFrame2) {
            this.setActiveFrame(this.j.get_Item(0));
        }
        tiffFrame2.a((Image)null);
        return tiffFrame2;
    }

    public TiffFrame removeFrame(int n2) {
        TiffFrame tiffFrame;
        this.verifyNotDisposed();
        if (n2 >= 0 && n2 < this.j.size()) {
            tiffFrame = this.j.get_Item(n2);
            if (this.getActiveFrame() == tiffFrame) {
                throw new TiffImageException("Unable to remove current frame");
            }
            if (this.j.size() <= 1) {
                throw new TiffImageException("Unable to remove last frame");
            }
            this.j.removeAt(n2);
        } else {
            throw new TiffImageException("Invalid index");
        }
        tiffFrame.a((Image)null);
        return tiffFrame;
    }

    public void removeFrame(TiffFrame tiffFrame) {
        this.verifyNotDisposed();
        if (tiffFrame == null) {
            throw new ArgumentNullException(h);
        }
        if (tiffFrame.getContainer() != this) {
            throw new ArgumentOutOfRangeException(h, "The frame does not belong to the current TIFF image.");
        }
        if (this.getActiveFrame() == tiffFrame) {
            throw new TiffImageException("Unable to remove current frame");
        }
        if (this.j.size() <= 1) {
            throw new TiffImageException("Unable to remove last frame");
        }
        this.j.removeItem(tiffFrame);
        tiffFrame.a((Image)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeProportional(int n2, int n3, int n4) {
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                int n5 = com.aspose.imaging.internal.pR.d.e(d2 * (double)tiffFrame.getWidth() + 0.5);
                int n6 = com.aspose.imaging.internal.pR.d.e(d3 * (double)tiffFrame.getHeight() + 0.5);
                tiffFrame.resize(n5, n6, n4);
            }
        }
        finally {
            if (com.aspose.imaging.internal.pR.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        super.resizeWidthProportionally(n2, n3);
    }

    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        super.resizeHeightProportionally(n2, n3);
    }

    @Override
    public void rotateFlip(int n2) {
        super.rotateFlip(n2);
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    @Override
    public void crop(Rectangle rectangle) {
        super.crop(rectangle.Clone());
    }

    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void binarizeFixed(byte by2) {
        super.binarizeFixed(by2);
    }

    @Override
    public void binarizeOtsu() {
        super.binarizeOtsu();
    }

    @Override
    public void binarizeBradley(double d2, int n2) {
        super.binarizeBradley(d2, n2);
    }

    @Override
    public void grayscale() {
        super.grayscale();
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        super.adjustGamma(f2, f3, f4);
    }

    @Override
    public void adjustBrightness(int n2) {
        super.adjustBrightness(n2);
    }

    @Override
    public void adjustContrast(float f2) {
        super.adjustContrast(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle.Clone(), filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            this.k = this.getActiveFrame().getFrameOptions().getByteOrder();
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, this.k);
            this.a(tiffStreamWriter);
        }
        finally {
            streamContainer.close();
        }
    }

    @Override
    protected void releaseManagedResources() {
        this.verifyNotDisposed();
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.pR.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        this.j.clear();
        this.l = null;
        super.releaseManagedResources();
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(Object object) {
        super.a(object);
        IGenericEnumerator iGenericEnumerator = this.j.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TiffFrame tiffFrame = (TiffFrame)iGenericEnumerator.next();
                tiffFrame.a(object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.pR.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private void a(TiffStreamWriter tiffStreamWriter) {
        this.verifyNotDisposed();
        tiffStreamWriter.setPosition(0L);
        com.aspose.imaging.internal.gW.h.a(tiffStreamWriter);
        int n2 = this.j.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = this.j.get_Item(i2);
            this.a(i2, tiffFrame);
            TiffOptions tiffOptions = new TiffOptions(tiffFrame.getFrameOptions());
            tiffOptions.setDisableIccExport(true);
            TiffFrame.a(tiffFrame, tiffStreamWriter, i2 == this.j.size() - 1, tiffOptions, tiffFrame.getExifData(), tiffFrame.getXmpData(), tiffFrame.getBounds());
            this.b(i2, tiffFrame);
        }
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<TiffImage> a;

        public a(TiffImage tiffImage) {
            this.a = new WeakReference<TiffImage>(tiffImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                return tiffImage.l.isRawDataAvailable();
            }
            return false;
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                return tiffImage.l.getRawDataSettings();
            }
            return null;
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                tiffImage.verifyNotDisposed();
                tiffImage.getActiveFrame().loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
            }
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            TiffImage tiffImage = (TiffImage)this.a.get();
            if (tiffImage != null) {
                tiffImage.verifyNotDisposed();
                tiffImage.l.loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
            }
        }
    }
}

