/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.Color;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.IAdvancedBufferProcessor;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.fileformats.jpeg.JpegImage;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffImage;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.pathresources.PathResource;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUndefinedType;
import com.aspose.imaging.imageoptions.TiffOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.ay.ao;
import com.aspose.imaging.internal.ay.bY;
import com.aspose.imaging.internal.ay.bg;
import com.aspose.imaging.internal.ay.bl;
import com.aspose.imaging.internal.ay.bx;
import com.aspose.imaging.internal.ay.ca;
import com.aspose.imaging.internal.ay.j;
import com.aspose.imaging.internal.gW.f;
import com.aspose.imaging.internal.gW.g;
import com.aspose.imaging.internal.gW.h;
import com.aspose.imaging.internal.gX.w;
import com.aspose.imaging.internal.iA.x;
import com.aspose.imaging.internal.iM.i;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.lC.l;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class TiffFrame
extends RasterCachedImage {
    private TiffOptions h;
    private int i;
    private int j;
    private ExifData k;
    private final com.aspose.imaging.internal.hr.b l;
    private boolean m;

    public TiffFrame(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    TiffFrame(Stream stream) {
        this(stream, new TiffOptions(0));
    }

    public static TiffFrame g(Stream stream) {
        return new TiffFrame(stream);
    }

    public TiffFrame(InputStream inputStream, TiffOptions tiffOptions) {
        this(Stream.fromJava(inputStream), tiffOptions);
    }

    TiffFrame(Stream stream, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bx(stream), tiffOptions);
    }

    public TiffFrame(String string) {
        this(string, new TiffOptions(0));
    }

    public TiffFrame(String string, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bx(string), tiffOptions);
    }

    public TiffFrame(RasterImage rasterImage) {
        this(rasterImage, new TiffOptions(0));
    }

    public TiffFrame(RasterImage rasterImage, TiffOptions tiffOptions) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new bx(rasterImage), tiffOptions);
    }

    public TiffFrame(TiffOptions tiffOptions, int n2, int n3) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.h = tiffOptions;
        this.j = n2;
        this.i = n3;
    }

    private TiffFrame(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this(tiffOptions);
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.h = tiffOptions;
        this.j = n2;
        this.i = n3;
        if (iRasterImageArgb32PixelLoader != null) {
            this.setDataLoader(iRasterImageArgb32PixelLoader);
        }
    }

    private TiffFrame(TiffOptions tiffOptions) {
        this.setUseRawData(false);
        this.a(new com.aspose.imaging.internal.ho.a(this));
        this.l = new com.aspose.imaging.internal.hr.b(tiffOptions);
    }

    @Override
    public Color getBackgroundColor() {
        return this.getFrameOptions().b();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.getFrameOptions().a(color);
    }

    @Override
    public boolean hasAlpha() {
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() != 0;
    }

    @Override
    public boolean hasTransparentColor() {
        TiffOptions tiffOptions = this.getFrameOptions();
        return tiffOptions.isExtraSamplesPresent() && tiffOptions.getAlphaStorage() == 1;
    }

    @Override
    public void setTransparentColor(boolean bl2) {
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        return this.h;
    }

    @Override
    public int getHeight() {
        return this.i;
    }

    @Override
    public int getWidth() {
        return this.j;
    }

    public ExifData getExifData() {
        return this.k;
    }

    public void setExifData(ExifData exifData) {
        this.k = exifData;
    }

    @Override
    public double getHorizontalResolution() {
        TiffRational tiffRational = null;
        if (this.h != null) {
            tiffRational = this.h.getXresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        if (this.h != null) {
            this.h.setXresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setHorizontalResolution(d2);
        }
    }

    @Override
    public double getVerticalResolution() {
        TiffRational tiffRational = null;
        if (this.h != null) {
            tiffRational = this.h.getYresolution();
        }
        if (tiffRational != null) {
            return tiffRational.getValueD();
        }
        return super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double d2) {
        if (this.h != null) {
            this.h.setYresolution(TiffRational.approximateFraction(d2));
        } else {
            super.setVerticalResolution(d2);
        }
    }

    public java.util.List<PathResource> getPathResources() {
        return List.toJava(this.q());
    }

    public List<PathResource> q() {
        return this.l.a();
    }

    public void setPathResources(java.util.List<PathResource> list) {
        this.a(List.fromJava(list));
    }

    public void a(List<PathResource> list) {
        this.l.a(list);
    }

    @Override
    public i h() {
        return this.getContainer() != null ? this.getContainer().h() : super.h();
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        return this.getFrameOptions();
    }

    public void alignResolutions() {
        TiffDataType tiffDataType = this.getFrameOptions().getTagByType(282);
        TiffDataType tiffDataType2 = this.getFrameOptions().getTagByType(283);
        if (tiffDataType != null && tiffDataType2 != null) {
            TiffRational[] tiffRationalArray = com.aspose.imaging.internal.pR.d.c(tiffDataType.getValue(), TiffRational[].class);
            TiffRational[] tiffRationalArray2 = com.aspose.imaging.internal.pR.d.c(tiffDataType2.getValue(), TiffRational[].class);
            TiffRational tiffRational = tiffRationalArray[0];
            TiffRational tiffRational2 = tiffRationalArray2[0];
            if ((tiffRational.getNominator() & 0xFFFFFFFFL) != (tiffRational2.getNominator() & 0xFFFFFFFFL) || (tiffRational.getDenominator() & 0xFFFFFFFFL) != (tiffRational2.getDenominator() & 0xFFFFFFFFL)) {
                if (tiffRational.getValue() > tiffRational2.getValue()) {
                    double d2 = tiffRational.getValueD() / tiffRational2.getValueD();
                    int n2 = com.aspose.imaging.internal.pR.d.e((double)this.i * d2);
                    this.resize(this.j, n2, 6);
                    tiffRationalArray2[0] = new TiffRational(tiffRational.getNominator(), tiffRational.getDenominator());
                } else {
                    double d3 = tiffRational2.getValueD() / tiffRational.getValueD();
                    int n3 = com.aspose.imaging.internal.pR.d.e((double)this.j * d3);
                    this.resize(n3, this.i, 6);
                    tiffRationalArray[0] = new TiffRational(tiffRational2.getNominator(), tiffRational2.getDenominator());
                }
                this.d(true);
            }
        }
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = new TiffOptions(tiffFrame.h);
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.j, tiffFrame.i);
        f f2 = (f)((Object)com.aspose.imaging.internal.pR.d.a(tiffFrame.getDataLoader(), f.class));
        tiffFrame2.a(tiffFrame.h(), false);
        if (f2 != null) {
            f f3 = f2.c();
            f3.a(tiffFrame2);
            tiffFrame2.setDataLoader(f3);
            tiffFrame2.m = true;
        } else if (tiffFrame.getDataLoader() != null) {
            tiffFrame2.setDataLoader(tiffFrame.getDataLoader());
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new bl(tiffFrame2));
        }
        if (tiffFrame.xmpData != null) {
            tiffFrame2.xmpData = tiffFrame.xmpData.c();
        }
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions tiffOptions) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.j, tiffFrame.i);
        tiffFrame2.a(tiffFrame.h(), false);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds(), new bl(tiffFrame2));
        return tiffFrame2;
    }

    public void r() {
        f f2 = (f)((Object)com.aspose.imaging.internal.pR.d.a(this.getDataLoader(), f.class));
        if (f2 != null) {
            f2.a(new TiffOptions(this.getFrameOptions()));
        }
    }

    public static TiffFrame a(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new TiffFrame(tiffOptions, n2, n3, iRasterImageArgb32PixelLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, TiffStreamWriter tiffStreamWriter, boolean bl2, TiffOptions tiffOptions, ExifData exifData, XmpPacketWrapper xmpPacketWrapper, Rectangle rectangle) {
        TiffOptions tiffOptions2 = tiffOptions;
        Object object = tiffOptions2;
        synchronized (object) {
            tiffOptions = new TiffOptions(tiffOptions2);
        }
        try {
            Object object2;
            Object object3;
            tiffOptions.validate();
            if (rectangle.isEmpty()) {
                rectangle = rasterImage.getBounds();
            }
            tiffOptions.setImageWidth((long)rectangle.getWidth() & 0xFFFFFFFFL);
            tiffOptions.setImageLength((long)rectangle.getHeight() & 0xFFFFFFFFL);
            tiffOptions.setRowsPerStrip((tiffOptions.getRowsPerStrip() & 0xFFFFFFFFL) == 0xFFFFFFFFL ? (long)rectangle.getHeight() & 0xFFFFFFFFL : tiffOptions.getRowsPerStrip());
            if (tiffOptions.getCompression() == 7) {
                tiffOptions.setRowsPerStrip((long)rectangle.getHeight() & 0xFFFFFFFFL);
                if (tiffOptions.getPhotometric() == 6) {
                    if (!tiffOptions.isTagPresent(530)) {
                        tiffOptions.setYCbCrSubsampling(new int[]{2, 2});
                    }
                } else if (!tiffOptions.isTagPresent(530)) {
                    tiffOptions.setYCbCrSubsampling(new int[]{1, 1});
                }
                if (!tiffOptions.isTagPresent(284)) {
                    tiffOptions.setPlanarConfiguration(1);
                }
            }
            if (tiffOptions.getCompression() == 6) {
                tiffOptions.setRowsPerStrip((long)rectangle.getHeight() & 0xFFFFFFFFL);
                object = new TiffLongType(513);
                ((TiffLongType)object).setValues(new long[]{0L});
                tiffOptions.addTag((TiffDataType)object);
                object3 = new TiffLongType(514);
                ((TiffLongType)object3).setValues(new long[]{0L});
                tiffOptions.addTag((TiffDataType)object3);
            }
            if (tiffOptions.getPhotometric() == 6 && !tiffOptions.isTagPresent(530)) {
                tiffOptions.setYCbCrSubsampling(new int[]{2, 2});
            }
            tiffOptions.setStripByteCounts(new long[]{0L});
            tiffOptions.setStripOffsets(new long[]{0L});
            if (!tiffOptions.isTagPresent(278)) {
                tiffOptions.setRowsPerStrip(0xFFFFFFFFL);
            }
            object = com.aspose.imaging.internal.gY.b.a(tiffOptions);
            object3 = com.aspose.imaging.internal.gY.a.a(tiffOptions, rasterImage, rectangle);
            com.aspose.imaging.internal.gZ.a a2 = new com.aspose.imaging.internal.gZ.a((w)object3, (com.aspose.imaging.internal.ha.a)object, true);
            a2.a(tiffOptions);
            tiffOptions.setTags(((w)object3).a(false).toArray((TiffDataType[])new TiffDataType[0]));
            TiffDataType[] tiffDataTypeArray = null;
            TiffDataType[] tiffDataTypeArray2 = null;
            if (exifData != null) {
                tiffDataTypeArray = exifData.getExifTags();
                tiffDataTypeArray2 = exifData.getGPSTags();
            }
            TiffDataType[] tiffDataTypeArray3 = null;
            if (tiffOptions.getXmpData() != null) {
                xmpPacketWrapper = tiffOptions.getXmpData();
            }
            if (xmpPacketWrapper != null) {
                object2 = new TiffUndefinedType(700);
                String string = xmpPacketWrapper.b();
                byte[] byArray = com.aspose.imaging.internal.lC.l.x().c(string);
                ((TiffUndefinedType)object2).setData(byArray);
                tiffDataTypeArray3 = new TiffDataType[]{object2};
            }
            object2 = new h(tiffOptions.getTags(), tiffDataTypeArray, tiffDataTypeArray2, tiffDataTypeArray3, tiffOptions.isDisableIccExport());
            long l2 = tiffStreamWriter.getPosition();
            long l3 = ((h)object2).b();
            a a3 = TiffFrame.a(tiffOptions, l2 + l3 & 0xFFFFFFFFL, tiffStreamWriter, rectangle.getWidth(), rectangle.getHeight(), rasterImage.h());
            try {
                Object object4;
                Object object5;
                Rectangle rectangle2 = Rectangle.intersect(rectangle, rasterImage.getBounds());
                bg bg2 = new bg(rasterImage, rectangle, a3, rasterImage.getPalette(), true);
                try {
                    if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                        if (rasterImage.isRawDataAvailable() && rasterImage.getUseRawData() && tiffOptions.getPhotometric() == 5 && rasterImage.getRawDataFormat() != null && (PixelDataFormat.op_Equality(rasterImage.getRawDataFormat(), PixelDataFormat.getCmyka()) || PixelDataFormat.op_Equality(rasterImage.getRawDataFormat(), PixelDataFormat.getCmyk()))) {
                            object5 = new RawDataSettings();
                            ((RawDataSettings)object5).setPixelDataFormat(PixelDataFormat.getCmyk());
                            ((RawDataSettings)object5).setLineSize(((RawDataSettings)object5).getPixelDataFormat().getChannelsCount() * rasterImage.getWidth());
                            c c2 = new c(a3, (RawDataSettings)object5);
                            rasterImage.loadRawData(rasterImage.getBounds(), (RawDataSettings)object5, c2);
                        } else {
                            object5 = bg2;
                            if (rasterImage.hasTransparentColor()) {
                                object5 = new ca(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), (IPartialArgb32PixelLoader)object5);
                            }
                            if (rasterImage.hasAlpha() && tiffOptions.getAlphaStorage() == 0) {
                                object5 = new j(tiffOptions.b().toArgb(), (IPartialArgb32PixelLoader)object5);
                            }
                            rasterImage.loadPartialArgb32Pixels(rectangle2, (IPartialArgb32PixelLoader)object5);
                        }
                    }
                    bg2.a();
                }
                finally {
                    bg2.close();
                }
                tiffOptions.setStripByteCounts(a3.b());
                tiffOptions.setStripOffsets(a3.a());
                tiffOptions.setRowsPerStrip(a3.c().c());
                object5 = new List();
                ((List)object5).addItem(tiffOptions.getTagByType(278));
                ((List)object5).addItem(tiffOptions.getTagByType(279));
                ((List)object5).addItem(tiffOptions.getTagByType(273));
                if (tiffOptions.getCompression() == 6) {
                    TiffLongType tiffLongType;
                    long l4 = l2 + l3 & 0xFFFFFFFFL;
                    object4 = (TiffLongType)((Object)com.aspose.imaging.internal.pR.d.a(tiffOptions.getTagByType(513), TiffLongType.class));
                    if (object4 != null && ((TiffLongType)object4).getValues() != null) {
                        ((TiffLongType)object4).getValues()[0] = l4;
                    }
                    if ((tiffLongType = (TiffLongType)((Object)com.aspose.imaging.internal.pR.d.a(tiffOptions.getTagByType(514), TiffLongType.class))) != null && tiffLongType.getValues() != null) {
                        tiffLongType.getValues()[0] = ((tiffOptions.getStripOffsets()[0] & 0xFFFFFFFFL) - (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL) + (tiffOptions.getStripByteCounts()[0] & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                    }
                    ((List)object5).addItem(object4);
                    ((List)object5).addItem(tiffLongType);
                }
                ((h)object2).a(((List)object5).toArray(new TiffDataType[0]));
                long l5 = a3.c().d();
                object4 = tiffStreamWriter.getSyncRoot();
                synchronized (object4) {
                    tiffStreamWriter.setPosition(l2);
                    ((h)object2).a(tiffStreamWriter, l5 & 0xFFFFFFFFL, bl2);
                }
            }
            finally {
                a3.dispose();
            }
        }
        finally {
            tiffOptions.dispose();
        }
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    @Override
    public IColorPalette o() {
        IColorPalette iColorPalette = super.o();
        if (iColorPalette == null && this.getFrameOptions() != null) {
            return this.getFrameOptions().getPalette();
        }
        return null;
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2 = super.a(iColorPalette);
        if (!bl2) {
            TiffOptions tiffOptions = this.getFrameOptions();
            boolean bl3 = bl2 = tiffOptions.getPalette() != null;
            if (bl2) {
                tiffOptions.setPalette(iColorPalette);
            }
        }
        return bl2;
    }

    @Override
    protected void releaseManagedResources() {
        f f2;
        this.h = null;
        if (this.m && (f2 = (f)((Object)com.aspose.imaging.internal.pR.d.a(this.getDataLoader(), f.class))) != null) {
            f2.d();
        }
        super.releaseManagedResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        int n2 = 18761;
        if (com.aspose.imaging.internal.pR.d.b((Object)this.getContainer(), TiffImage.class)) {
            n2 = ((TiffImage)((Object)com.aspose.imaging.internal.pR.d.a(this.getContainer(), TiffImage.class))).getByteOrder();
        }
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            TiffStreamWriter tiffStreamWriter = TiffStreamFactory.getTiffWriter(streamContainer, n2);
            TiffFrame.a(this, tiffStreamWriter, true, this.h, this.k, this.xmpData, this.getBounds());
        }
        finally {
            streamContainer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int n2, int n3, int n4) {
        try {
            Object object = this.c;
            synchronized (object) {
                try {
                    ao ao2 = this.a();
                    if (ao2 != null) {
                        ao2.a(n2, n3, n4);
                    } else {
                        this.a(n2, n3, n4);
                    }
                    this.d(true);
                }
                finally {
                    this.d(true);
                }
            }
        }
        finally {
            this.c(true);
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        ao ao2 = this.a();
        if (ao2 != null) {
            ao2.a(f2, bl2, color);
        } else {
            this.a(f2, bl2, color, false);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        if (this.a() != null) {
            this.a().a(rectangle.Clone());
        } else {
            this.a(rectangle.Clone());
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.j = n2;
        this.i = n3;
        this.d(true);
    }

    private void a(bx bx2, TiffOptions tiffOptions) {
        this.setDataLoader(bx2);
        this.h = tiffOptions;
        this.j = bx2.a().getWidth();
        this.i = bx2.a().getHeight();
        this.setPalette(bx2.a().getPalette());
        TiffImage tiffImage = (TiffImage)((Object)com.aspose.imaging.internal.pR.d.a(bx2.a(), TiffImage.class));
        if (tiffImage != null) {
            this.k = tiffImage.getExifData();
            this.xmpData = tiffImage.getXmpData();
        }
    }

    private static a a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3, i i2) {
        a a2 = tiffOptions.getCompression() == 6 ? new d(tiffOptions, l2, tiffStreamWriter, n2, n3, i2) : new a(tiffOptions, l2, tiffStreamWriter, n2, n3, i2);
        return a2;
    }

    private static class c
    implements IPartialRawDataLoader {
        private final a a;
        private final RawDataSettings b;

        public c(a a2, RawDataSettings rawDataSettings) {
            this.a = a2;
            this.b = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.process(rectangle, byArray, point, point2, null);
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            PixelDataFormat pixelDataFormat = this.b.getPixelDataFormat();
            if (!PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyk()) && !PixelDataFormat.op_Equality(pixelDataFormat, PixelDataFormat.getCmyka())) {
                throw new NotSupportedException(aV.a("PixelDataFormat {0} not supported the raw loader", new Object[]{pixelDataFormat}));
            }
            this.a.a(rectangle, byArray, this.b, point, point2);
        }
    }

    private static class d
    extends a {
        private boolean a = false;
        private int b = -1;
        private static final int c = -1;

        public d(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3, i i2) {
            super(tiffOptions, l2, tiffStreamWriter, n2, n3, i2);
        }

        @Override
        public long[] a() {
            long[] lArray = new long[this.c().a().length];
            System.arraycopy(this.c().a(), 0, lArray, 0, lArray.length);
            lArray[0] = (lArray[0] & 0xFFFFFFFFL) + ((long)this.e() & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            return lArray;
        }

        @Override
        public long[] b() {
            long[] lArray = new long[this.c().b().length];
            System.arraycopy(this.c().b(), 0, lArray, 0, lArray.length);
            lArray[0] = (lArray[0] & 0xFFFFFFFFL) - ((long)this.e() & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            return lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int e() {
            block9: {
                if (!this.a) {
                    try {
                        e e2 = (e)((Object)com.aspose.imaging.internal.pR.d.a(this.c(), e.class));
                        if (e2 == null) break block9;
                        x x2 = new x();
                        e2.e().setPosition(0L);
                        StreamContainer streamContainer = null;
                        try {
                            streamContainer = new StreamContainer(e2.e());
                            JpegImage jpegImage = (JpegImage)x2.load(streamContainer, null);
                            try {
                                com.aspose.imaging.internal.kI.a<com.aspose.imaging.internal.kH.e> a2 = x2.b();
                                com.aspose.imaging.internal.kH.e e3 = x.a((byte)-38, a2);
                                if (e3 != null && e3.b() != 0) {
                                    this.b = e3.k(0);
                                    this.a = true;
                                }
                            }
                            finally {
                                jpegImage.dispose();
                            }
                        }
                        catch (Throwable throwable) {
                            bY.a(streamContainer);
                            throw throwable;
                        }
                        bY.a(streamContainer);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new FrameworkException("Failed to load JPEG image with old-style compression", runtimeException);
                    }
                }
            }
            return this.b;
        }
    }

    private static class a
    extends DisposableObject
    implements IPartialArgb32PixelLoader {
        private final b a;
        private com.aspose.imaging.internal.gW.e b;
        private RawDataSettings c;

        public a(TiffOptions tiffOptions, long l2, TiffStreamWriter tiffStreamWriter, int n2, int n3, i i2) {
            this.b = com.aspose.imaging.internal.gW.g.a(tiffOptions, n2, n3, i2);
            long l3 = tiffOptions.getRowsPerStrip();
            this.a = com.aspose.imaging.fileformats.tiff.TiffFrame$b.a(tiffOptions, tiffStreamWriter, l2, (long)this.b.i() & 0xFFFFFFFFL, l3, this.b.j().getFillOrder() == 2);
        }

        public long[] a() {
            return this.a.a();
        }

        public long[] b() {
            return this.a.b();
        }

        public b c() {
            return this.a;
        }

        public RawDataSettings d() {
            return this.c;
        }

        public void a(RawDataSettings rawDataSettings) {
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            try {
                this.b.a(nArray, rectangle, this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        public void a(Rectangle rectangle, byte[] byArray, RawDataSettings rawDataSettings, Point point, Point point2) {
            try {
                this.b.a(byArray, rectangle, this.a, rawDataSettings);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FrameworkException("Fatal error", outOfMemoryError);
            }
        }

        @Override
        protected void releaseManagedResources() {
            if (this.b != null) {
                this.b.dispose();
                this.b = null;
            }
            super.releaseManagedResources();
        }
    }

    private static class e
    extends b
    implements IAdvancedBufferProcessor {
        private final MemoryStream a = new MemoryStream();

        public e(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            super(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2);
        }

        public Stream e() {
            return this.a;
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            super.processBuffer(byArray, n2);
            this.a.write(byArray, 0, n2);
        }
    }

    private static class b
    implements IAdvancedBufferProcessor {
        private final TiffStreamWriter a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public b(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            this.f = bl2;
            this.a = tiffStreamWriter;
            this.g = l2;
            if ((l4 & 0xFFFFFFFFL) == 0L) {
                l4 = l3;
            }
            this.b = l4;
            long l5 = (l3 & 0xFFFFFFFFL) / (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            if (((l3 & 0xFFFFFFFFL) % (l4 & 0xFFFFFFFFL) & 0xFFFFFFFFL) != 0L) {
                ++l5;
            }
            l5 = tiffOptions.getPlanarConfiguration() == 1 ? l5 : (l5 & 0xFFFFFFFFL) * (long)(tiffOptions.getSamplesPerPixel() & 0xFFFF) & 0xFFFFFFFFL;
            this.c = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.d = new long[(int)(l5 & 0xFFFFFFFFL)];
            this.c[0] = l2;
            this.e = l3;
        }

        public long[] a() {
            return this.c;
        }

        public long[] b() {
            return this.d;
        }

        public long c() {
            return this.b;
        }

        public long d() {
            return this.g;
        }

        public static b a(TiffOptions tiffOptions, TiffStreamWriter tiffStreamWriter, long l2, long l3, long l4, boolean bl2) {
            b b2 = tiffOptions.getCompression() == 6 ? new e(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2) : new b(tiffOptions, tiffStreamWriter, l2, l3, l4, bl2);
            return b2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processBuffer(byte[] byArray, int n2) {
            if (this.f) {
                com.aspose.imaging.internal.gW.b.a(byArray, 0, n2);
            }
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setPosition(this.g & 0xFFFFFFFFL);
                this.a.write(byArray, 0, n2);
            }
            this.g = (this.g & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.j = (this.j & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        }

        @Override
        public void finishRow() {
            ++this.h;
            if (((this.h & 0xFFFFFFFFL) % (this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L || ((this.h & 0xFFFFFFFFL) % (this.e & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L) {
                this.d[(int)this.i++] = this.j;
                if ((this.i & 0xFFFFFFFFL) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }

        @Override
        public void finishRows(int n2) {
            this.h = (this.h & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            if (((this.h & 0xFFFFFFFFL) % (this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L || ((this.h & 0xFFFFFFFFL) % (this.e & 0xFFFFFFFFL) & 0xFFFFFFFFL) == 0L) {
                this.d[(int)this.i++] = this.j;
                if ((this.i & 0xFFFFFFFFL) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

