/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff;

import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.StreamReadException;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.fileformats.tiff.enums.TiffDataTypes;
import com.aspose.imaging.fileformats.tiff.enums.TiffTags;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamReader;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.instancefactory.TiffTagFactory;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.aQ.d;
import com.aspose.imaging.internal.ay.aX;
import com.aspose.imaging.internal.hv.a;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.kN.bf;
import com.aspose.imaging.internal.kN.bg;
import com.aspose.imaging.internal.kN.g;
import com.aspose.imaging.internal.lC.z;
import com.aspose.imaging.system.Enum;

public abstract class TiffDataType
implements Comparable<TiffDataType> {
    private int a;

    protected TiffDataType(int n2) {
        this.a = n2 & 0xFFFF;
    }

    public TiffDataType() {
    }

    public abstract long getCount();

    public int getId() {
        return this.a;
    }

    public int getTagId() {
        return this.a;
    }

    public abstract int getTagType();

    public long getAlignedDataSize() {
        return aX.a(this.getDataSize());
    }

    public abstract long getDataSize();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public boolean isValid() {
        return (this.getCount() & 0xFFFFFFFFL) > 0L;
    }

    public boolean a() {
        return (this.a & 0xFFFF) > 32768;
    }

    public static TiffDataType readTag(TiffStreamReader tiffStreamReader, long l2) {
        if (tiffStreamReader == null) {
            throw new ArgumentNullException("dataStream");
        }
        int n2 = 0;
        try {
            int[] nArray = tiffStreamReader.readUShortArray(l2, 2L);
            int n3 = nArray[0];
            n2 = nArray[1];
            long l3 = tiffStreamReader.readULong(l2 += 4L);
            l2 += 4L;
            TiffDataType tiffDataType = TiffTagFactory.createInstance(n2, n3);
            if (tiffDataType == null) {
                long l4 = tiffStreamReader.readULong(l2);
                tiffDataType = new TiffUnknownType(tiffStreamReader, n2, n3, l3, l4);
            } else {
                tiffDataType.readData(tiffStreamReader, l2, l3 & 0xFFFFFFFFL);
                if (tiffDataType instanceof a) {
                    TiffDataType.a((a)tiffDataType, tiffStreamReader, l2);
                }
            }
            return tiffDataType;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new StreamReadException(indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new FrameworkException(aV.a("InstantiationException for tag type : ", bf.b(n2), ". ", throwable.getMessage()), throwable);
        }
    }

    @Override
    public int compareTo(TiffDataType tiffDataType) {
        if (tiffDataType == null) {
            throw new TiffImageException("Expected TiffDataType type.");
        }
        return (this.a & 0xFFFF) - (tiffDataType.a & 0xFFFF);
    }

    public int hashCode() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TiffDataType)) {
            return false;
        }
        TiffDataType tiffDataType = (TiffDataType)object;
        return this.a == tiffDataType.a;
    }

    public TiffDataType deepClone() {
        TiffDataType tiffDataType = this.createInstance();
        this.copyInstanceData(tiffDataType);
        return tiffDataType;
    }

    public void writeTag(TiffStreamWriter tiffStreamWriter, long l2) {
        if (tiffStreamWriter == null) {
            throw new ArgumentNullException("dataStream");
        }
        try {
            tiffStreamWriter.writeUShort(this.a);
            tiffStreamWriter.writeUShort(this.getTagType());
            long l3 = this.getCount();
            tiffStreamWriter.writeULong(l3);
            this.writeTagValueOrOffset(tiffStreamWriter, l2);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException(aV.a("Unable to Write values for ", Enum.getName(TiffDataTypes.class, this.getTagType()), " Message : ", runtimeException.getMessage()));
        }
    }

    public abstract long writeAdditionalData(TiffStreamWriter var1);

    public String toString() {
        String string = aV.a;
        Object object = this.getValue();
        if (object != null) {
            if (object instanceof g) {
                z z2 = new z();
                z2.a('{');
                g g2 = (g)object;
                int n2 = g2.j();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (i2 < n2 - 1) {
                        z2.a("{0}, ", g2.e(i2));
                        continue;
                    }
                    z2.a(g2.e(i2));
                    z2.a('}');
                }
                string = z2.toString();
            } else if (object.getClass().isArray()) {
                string = com.aspose.imaging.internal.aV.a.a(object);
            } else if (this.getValue() != null) {
                string = object.toString();
            }
        }
        return aV.a("Tag: ", TiffTags.toString(TiffTags.class, this.a), " Type: ", TiffDataTypes.toString(TiffDataTypes.class, this.getTagType()), " Count: ", bg.b(this.getCount()), " Value: ", string);
    }

    protected abstract void readData(TiffStreamReader var1, long var2, long var4);

    protected abstract void writeTagValueOrOffset(TiffStreamWriter var1, long var2);

    protected void copyInstanceData(TiffDataType tiffDataType) {
        tiffDataType.a = this.a;
    }

    protected abstract TiffDataType createInstance();

    private static void a(a a2, TiffStreamReader tiffStreamReader, long l2) {
        long l3 = tiffStreamReader.readULong(l2);
        a2.a(d.a(tiffStreamReader, l3 & 0xFFFFFFFFL));
    }
}

