/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.jpeg;

import com.aspose.imaging.Color;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.ResolutionUnit;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.JpegException;
import com.aspose.imaging.exif.JpegExifData;
import com.aspose.imaging.fileformats.jpeg.JFIFData;
import com.aspose.imaging.fileformats.jpeg.a;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffBigEndianStreamWriter;
import com.aspose.imaging.imageoptions.JpegOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.ay.aB;
import com.aspose.imaging.internal.ay.bX;
import com.aspose.imaging.internal.ay.bY;
import com.aspose.imaging.internal.ay.bg;
import com.aspose.imaging.internal.ay.bi;
import com.aspose.imaging.internal.ay.bx;
import com.aspose.imaging.internal.ay.ca;
import com.aspose.imaging.internal.ay.j;
import com.aspose.imaging.internal.fb.E;
import com.aspose.imaging.internal.fb.I;
import com.aspose.imaging.internal.fb.T;
import com.aspose.imaging.internal.fb.V;
import com.aspose.imaging.internal.fb.b;
import com.aspose.imaging.internal.fb.e;
import com.aspose.imaging.internal.fb.i;
import com.aspose.imaging.internal.fb.l;
import com.aspose.imaging.internal.fb.n;
import com.aspose.imaging.internal.fb.o;
import com.aspose.imaging.internal.fb.r;
import com.aspose.imaging.internal.fb.t;
import com.aspose.imaging.internal.ff.g;
import com.aspose.imaging.internal.fi.c;
import com.aspose.imaging.internal.kN.Q;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.kN.au;
import com.aspose.imaging.internal.pR.d;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.EnumExtensions;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public final class JpegImage
extends RasterCachedImage {
    private int h;
    private JpegOptions i;
    private int j;
    private boolean k;
    private StreamSource l;
    private StreamSource m;
    private final List<Image> n = new List();
    private byte[] o;

    public JpegImage(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new com.aspose.imaging.internal.fb.Q(string));
    }

    public JpegImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    JpegImage(Stream stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new com.aspose.imaging.internal.fb.Q(stream));
    }

    public JpegImage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("rasterImage");
        }
        this.a(new com.aspose.imaging.internal.fb.Q(rasterImage), rasterImage.getWidth(), rasterImage.getHeight());
    }

    public JpegImage(int n2, int n3) {
        this(new JpegOptions(), n2, n3);
    }

    public JpegImage(JpegOptions jpegOptions, int n2, int n3) {
        this.i = jpegOptions;
        this.j = n2;
        this.h = n3;
    }

    private JpegImage(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this.a(iRasterImageArgb32PixelLoader, n2, n3);
        switch (n4) {
            case 0: {
                this.i.setColorType(0);
                break;
            }
            case 1: {
                this.i.setColorType(4);
                break;
            }
            case 3: {
                this.i.setColorType(1);
                break;
            }
            case 4: {
                this.i.setColorType(2);
                break;
            }
            case 5: {
                this.i.setColorType(3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("pixelFormat");
            }
        }
    }

    @Override
    public long getFileFormat() {
        return 8L;
    }

    public JpegOptions getJpegOptions() {
        return this.i;
    }

    @Override
    public int getBitsPerPixel() {
        return 8 * this.getRawDataFormat().getChannelsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getComment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(String string) {
        Object object = this.c;
        synchronized (object) {
            this.i.setComment(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpegExifData getExifData() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getExifData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExifData(JpegExifData jpegExifData) {
        Object object = this.c;
        synchronized (object) {
            if (this.i != null && this.i.getExifData() != null && this.i.getExifData().getThumbnail() != null) {
                this.n.addItem(this.i.getExifData().getThumbnail());
            }
            if (this.i != null) {
                this.i.setExifData(jpegExifData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmpPacketWrapper getXmpData() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getXmpData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        Object object = this.c;
        synchronized (object) {
            this.i.setXmpData(xmpPacketWrapper);
        }
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getHorizontalResolution() {
        Object object = this.c;
        synchronized (object) {
            if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
                return this.getExifData().getXResolution().getValueD();
            }
            return this.getJfif() != null ? (double)this.getJfif().getXDensity() : 72.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHorizontalResolution(double d2) {
        Object object = this.c;
        synchronized (object) {
            JpegExifData jpegExifData = this.getExifData();
            if (jpegExifData == null) {
                jpegExifData = new JpegExifData();
                this.setExifData(jpegExifData);
            }
            jpegExifData.setResolutionUnit(2);
            jpegExifData.setXResolution(new TiffRational(com.aspose.imaging.internal.pR.d.f(d2)));
            JFIFData jFIFData = this.getJfif();
            if (jFIFData == null) {
                jFIFData = new JFIFData();
                this.setJfif(jFIFData);
            }
            jFIFData.setDensityUnits((byte)1);
            jFIFData.setXDensity(com.aspose.imaging.internal.pR.d.c(d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFIFData getJfif() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getJfif();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJfif(JFIFData jFIFData) {
        Object object = this.c;
        synchronized (object) {
            if (this.i != null && this.i.getJfif() != null && this.i.getJfif().getThumbnail() != null) {
                this.n.addItem(this.i.getJfif().getThumbnail());
            }
            if (this.i != null) {
                this.i.setJfif(jFIFData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PixelDataFormat getRawDataFormat() {
        Object object = this.c;
        synchronized (object) {
            return JpegImage.b(this.i.getColorType(), this.i.getBitsPerChannel() & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVerticalResolution() {
        Object object = this.c;
        synchronized (object) {
            if (this.getExifData() != null && this.getExifData().getXResolution() != null && this.getExifData().getYResolution() != null) {
                return this.getExifData().getYResolution().getValueD();
            }
            return this.getJfif() != null ? (double)this.getJfif().getYDensity() : 72.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVerticalResolution(double d2) {
        Object object = this.c;
        synchronized (object) {
            if (this.getExifData() == null) {
                this.setExifData(new JpegExifData());
            }
            this.getExifData().setResolutionUnit(2);
            this.getExifData().setYResolution(new TiffRational(com.aspose.imaging.internal.pR.d.f(d2)));
            if (this.getJfif() == null) {
                this.setJfif(new JFIFData());
            }
            this.getJfif().setDensityUnits((byte)1);
            this.getJfif().setYDensity(com.aspose.imaging.internal.pR.d.c(d2));
        }
    }

    @Override
    public int getWidth() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getRgbColorProfile() {
        Object object = this.c;
        synchronized (object) {
            return this.l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRgbColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.l = streamSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getCmykColorProfile() {
        Object object = this.c;
        synchronized (object) {
            return this.m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCmykColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.m = streamSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getDestinationRgbColorProfile() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getRgbColorProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationRgbColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.i.setRgbColorProfile(streamSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSource getDestinationCmykColorProfile() {
        Object object = this.c;
        synchronized (object) {
            return this.i.getCmykColorProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationCmykColorProfile(StreamSource streamSource) {
        Object object = this.c;
        synchronized (object) {
            this.i.setCmykColorProfile(streamSource);
        }
    }

    public boolean getIgnoreEmbeddedColorProfile() {
        return this.k;
    }

    public void setIgnoreEmbeddedColorProfile(boolean bl2) {
        this.k = bl2;
    }

    public final byte[] q() {
        return this.o;
    }

    public final void a(byte[] byArray) {
        this.o = byArray;
    }

    @Override
    public Q e(boolean bl2) {
        if (!bl2 && this.getExifData() != null && !aV.b(this.getExifData().getDateTime())) {
            String[] stringArray = aV.a(this.getExifData().getDateTime(), ' ');
            if (stringArray.length != 2) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray2 = aV.a(stringArray[0], ':');
            if (stringArray2.length != 3) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            String[] stringArray3 = aV.a(stringArray[1], ':');
            if (stringArray3.length != 3) {
                throw new FrameworkException(aV.a("Can't parse Exif date {0}", new Object[]{this.getExifData().getDateTime()}));
            }
            return new Q(au.a(stringArray2[0]), au.a(stringArray2[1]), au.a(stringArray2[2]), au.a(stringArray3[0]), au.a(stringArray3[1]), au.a(stringArray3[2]));
        }
        return super.e(bl2);
    }

    @Override
    public void setResolution(double d2, double d3) {
        this.setHorizontalResolution(d2);
        this.setVerticalResolution(d3);
    }

    public void autoRotate() {
        JpegExifData jpegExifData = this.getExifData();
        if (jpegExifData != null) {
            int n2 = jpegExifData.getOrientation();
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    this.rotateFlip(4);
                    break;
                }
                case 3: {
                    this.rotateFlip(12);
                    break;
                }
                case 4: {
                    this.rotateFlip(8);
                    break;
                }
                case 5: {
                    this.rotateFlip(5);
                    break;
                }
                case 6: {
                    this.rotateFlip(1);
                    break;
                }
                case 7: {
                    this.rotateFlip(9);
                    break;
                }
                case 8: {
                    this.rotateFlip(13);
                    break;
                }
                default: {
                    throw new ArgumentOutOfRangeException("Exif.Orientation", "Unknown value: " + n2);
                }
            }
            jpegExifData.setOrientation(1);
        }
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        if (n2 == 2 || n2 == 1) {
            return true;
        }
        return super.doUseRecursion(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        JFIFData jFIFData;
        JpegExifData jpegExifData = this.getExifData();
        if (jpegExifData != null && jpegExifData.getThumbnail() != null) {
            this.n.addItem(jpegExifData.getThumbnail());
            jpegExifData.setThumbnail(null);
        }
        if ((jFIFData = this.getJfif()) != null && jFIFData.getThumbnail() != null) {
            this.n.addItem(jFIFData.getThumbnail());
            jFIFData.setThumbnail(null);
        }
        IGenericEnumerator iGenericEnumerator = this.n.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Image image = (Image)iGenericEnumerator.next();
                IDisposable iDisposable = (IDisposable)((Object)com.aspose.imaging.internal.pR.d.a(image, IDisposable.class));
                if (iDisposable == null) continue;
                iDisposable.dispose();
            }
        }
        finally {
            if (com.aspose.imaging.internal.pR.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        super.releaseManagedResources();
    }

    @Override
    protected void updateMetadata() {
        if (this.getUpdateXmpData()) {
            try {
                JpegExifData jpegExifData = this.getExifData();
                if (jpegExifData == null) {
                    jpegExifData = new JpegExifData();
                }
                JpegExifData jpegExifData2 = jpegExifData;
                Q q2 = Q.m();
                String string = aV.a("{0:D4}:{1:D2}:{2:D2} {3:D2}:{4:D2}:{5:D2}", q2.t(), q2.l(), q2.e(), q2.h(), q2.k(), q2.p());
                jpegExifData2.setDateTime(string);
                this.setExifData(jpegExifData2);
            }
            catch (RuntimeException runtimeException) {
                com.aspose.imaging.internal.kU.a.d(aV.a(new String[]{"Exception on WaveletMap.Duplicate: ", runtimeException.toString()}));
            }
        }
        super.updateMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(JpegExifData jpegExifData) {
        byte[] byArray;
        byte[] byArray2 = jpegExifData.serializeExifData();
        if (byArray2.length > 65528) {
            throw new JpegException("Exif segment is excessively big to be stored in jpeg file. Consider JpegExifData.serializeExifData() method for result data size estimation.");
        }
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray3 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(byArray2.length + 8 & 0xFFFF);
            byte[] byArray4 = new byte[]{69, 120, 105, 102, 0, 0};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            streamContainer.dispose();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] a(XmpPacketWrapper xmpPacketWrapper) {
        byte[] byArray;
        int n2;
        int n3;
        if (xmpPacketWrapper == null) {
            throw new ArgumentNullException("xmpData");
        }
        String string = xmpPacketWrapper.b();
        byte[] byArray2 = com.aspose.imaging.internal.lC.l.x().c(string);
        int n4 = byArray2.length + 2 + (n3 = "http://ns.adobe.com/xap/1.0/".length() + 1);
        if (n4 > (n2 = 65533 - n3)) {
            throw new JpegException(aV.a("XMP could not be grater than {0} bytes", new Object[]{n2}));
        }
        int n5 = n4 & 0xFFFF;
        String string2 = aV.a(new Object[]{"http://ns.adobe.com/xap/1.0/", Character.valueOf('\u0000')});
        byte[] byArray3 = com.aspose.imaging.internal.lC.l.x().c(string2);
        StreamContainer streamContainer = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer);
            byte[] byArray4 = new byte[]{-1, -31};
            tiffBigEndianStreamWriter.write(byArray4);
            tiffBigEndianStreamWriter.writeUShort(n5 & 0xFFFF);
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer.toBytes();
        }
        finally {
            streamContainer.dispose();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, Stream stream, JFIFData jFIFData, JpegExifData jpegExifData, XmpPacketWrapper xmpPacketWrapper, byte[] byArray, JpegOptions jpegOptions, Rectangle rectangle) {
        V v2 = new V(stream);
        try {
            block29: {
                int n2;
                JpegImage.b(v2);
                ResolutionSetting resolutionSetting = jpegOptions.getResolutionSettings();
                if (resolutionSetting != null) {
                    if (jpegExifData == null) {
                        jpegExifData = new JpegExifData();
                    }
                    jpegExifData.setXResolution(new TiffRational(com.aspose.imaging.internal.pR.d.f(jpegOptions.getResolutionSettings().getHorizontalResolution()), 1L));
                    jpegExifData.setYResolution(new TiffRational(com.aspose.imaging.internal.pR.d.f(jpegOptions.getResolutionSettings().getVerticalResolution()), 1L));
                    switch (jpegOptions.getResolutionUnit()) {
                        case 0: {
                            jpegExifData.setResolutionUnit(1);
                            break;
                        }
                        case 1: {
                            jpegExifData.setResolutionUnit(2);
                            break;
                        }
                        case 2: {
                            jpegExifData.setResolutionUnit(3);
                            break;
                        }
                        default: {
                            throw new NotSupportedException(aV.a(new String[]{"Unsupported resolution unit ", EnumExtensions.toString(ResolutionUnit.class, jpegOptions.getResolutionUnit())}));
                        }
                    }
                }
                if (jFIFData != null) {
                    JFIFData.write(jFIFData, v2);
                }
                JpegImage.a((StreamContainer)v2, jpegExifData);
                JpegImage.a((StreamContainer)v2, xmpPacketWrapper);
                if (!aV.b(jpegOptions.getComment())) {
                    JpegImage.a((StreamContainer)v2, jpegOptions.getComment());
                }
                if (byArray != null) {
                    com.aspose.imaging.internal.fb.a a2 = new com.aspose.imaging.internal.fb.a();
                    a2.a(byArray);
                    a2.a(stream);
                }
                if ((n2 = jpegOptions.getColorType()) == 3 || n2 == 2) {
                    Stream stream2 = jpegOptions.getCmykColorProfile() != null ? jpegOptions.getCmykColorProfile().getStream() : aB.a().getStream();
                    bX bX2 = bY.a().a(stream2);
                    try {
                        Object object = bX2.getSyncRoot();
                        synchronized (object) {
                            Object object2;
                            stream2 = jpegOptions.getCmykColorProfile() != null ? jpegOptions.getCmykColorProfile().getStream() : ((object2 = (JpegImage)((Object)com.aspose.imaging.internal.pR.d.a(rasterImage, JpegImage.class))) != null && ((JpegImage)object2).getCmykColorProfile() != null ? ((JpegImage)object2).getCmykColorProfile().getStream() : aB.a().getStream());
                            com.aspose.imaging.internal.fb.i.a(stream2, stream);
                            object2 = new b();
                            ((b)object2).c(100);
                            ((b)object2).a(0);
                            ((b)object2).b(0);
                            if (n2 == 3) {
                                ((b)object2).a((byte)2);
                            } else {
                                ((b)object2).a((byte)0);
                            }
                            com.aspose.imaging.internal.fb.b.a(stream, (b)object2);
                            jpegOptions.setCmykColorProfile(new StreamSource(stream2));
                            if (jpegOptions.getRgbColorProfile() == null) {
                                jpegOptions.setRgbColorProfile(aB.b());
                            }
                            break block29;
                        }
                    }
                    finally {
                        bY.a().a(bX2);
                    }
                }
                if (n2 == 4) {
                    b b2 = new b();
                    b2.c(100);
                    b2.a(0);
                    b2.b(0);
                    b2.a((byte)0);
                    com.aspose.imaging.internal.fb.b.a(stream, b2);
                }
            }
            switch (jpegOptions.getCompressionType()) {
                case 0: 
                case 1: {
                    JpegImage.a(rasterImage, jpegOptions, v2, rectangle);
                    break;
                }
                case 2: {
                    JpegImage.b(rasterImage, jpegOptions, v2, rectangle);
                    break;
                }
                case 3: {
                    JpegImage.c(rasterImage, jpegOptions, v2, rectangle);
                    break;
                }
                default: {
                    throw new ArgumentException();
                }
            }
            JpegImage.a(v2);
        }
        finally {
            v2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        RawDataSettings rawDataSettings = new RawDataSettings();
        PixelDataFormat pixelDataFormat = JpegImage.b(jpegOptions.getColorType(), jpegOptions.getBitsPerChannel() & 0xFF);
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight());
        List<e[]> list = null;
        c c2 = null;
        int n2 = 2;
        boolean bl2 = true;
        while (bl2) {
            com.aspose.imaging.internal.ff.c c3;
            com.aspose.imaging.internal.ff.c c4 = c3 = new com.aspose.imaging.internal.ff.c(rectangle2, jpegOptions, v2, pixelDataFormat, n2, list, rasterImage.h());
            try {
                a a2 = new a(v2, jpegOptions, rectangle2, pixelDataFormat, c4, n2, c2);
                rawDataSettings.setPixelDataFormat(pixelDataFormat);
                Rectangle rectangle3 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
                if (rectangle3.getWidth() > 0 && rectangle3.getHeight() > 0) {
                    if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                        rawDataSettings.setColorPalette(null);
                        rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                        rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                        rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                        rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                        bi bi2 = new bi(rasterImage, rawDataSettings, rectangle, a2);
                        try {
                            rasterImage.loadRawData(rectangle3, rectangle3, rawDataSettings, bi2);
                        }
                        finally {
                            bi2.dispose();
                        }
                    }
                    o o2 = com.aspose.imaging.internal.fb.o.a(a2, jpegOptions);
                    bg bg2 = new bg(rasterImage, rectangle, o2, rasterImage.getPalette());
                    try {
                        IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bg2;
                        if (rasterImage.hasTransparentColor()) {
                            iPartialArgb32PixelLoader = new ca(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                        }
                        if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                            iPartialArgb32PixelLoader = new j(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                        }
                        rasterImage.loadPartialArgb32Pixels(rectangle3, iPartialArgb32PixelLoader);
                    }
                    finally {
                        bg2.dispose();
                    }
                }
                a2.a(true);
                n2 = a2.b();
                if (n2 == 2) {
                    c2 = a2.a();
                    boolean bl3 = com.aspose.imaging.internal.ff.c.a(jpegOptions);
                    n2 = bl3 ? 0 : 1;
                    continue;
                }
                if (n2 == 0) {
                    list = c4.a();
                    n2 = 1;
                    continue;
                }
                if (n2 != 1) continue;
                bl2 = false;
            }
            finally {
                c4.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        block12: {
            RawDataSettings rawDataSettings = new RawDataSettings();
            PixelDataFormat pixelDataFormat = JpegImage.a(jpegOptions.getColorType(), jpegOptions.getBitsPerChannel());
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            g g2 = new g(new Rectangle(Point.getEmpty(), rectangle2.getSize()), jpegOptions, v2, rasterImage.h());
            try {
                t t2 = new t(v2, pixelDataFormat, g2);
                rawDataSettings.setPixelDataFormat(pixelDataFormat);
                if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) break block12;
                if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                    rawDataSettings.setColorPalette(null);
                    rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                    rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                    rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                    rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                    bi bi2 = new bi(rasterImage, rawDataSettings, rectangle, t2);
                    try {
                        rasterImage.loadRawData(rectangle2, rectangle2, rawDataSettings, bi2);
                        break block12;
                    }
                    finally {
                        bi2.dispose();
                    }
                }
                o o2 = com.aspose.imaging.internal.fb.o.a(t2, jpegOptions);
                bg bg2 = new bg(rasterImage, rectangle, o2, rasterImage.getPalette());
                try {
                    IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bg2;
                    if (rasterImage.hasTransparentColor() && rasterImage.hasBackgroundColor()) {
                        iPartialArgb32PixelLoader = new ca(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                    }
                    if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                        iPartialArgb32PixelLoader = new j(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                    }
                    rasterImage.loadPartialArgb32Pixels(rectangle2, iPartialArgb32PixelLoader);
                }
                finally {
                    bg2.dispose();
                }
            }
            finally {
                g2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c(RasterImage rasterImage, JpegOptions jpegOptions, V v2, Rectangle rectangle) {
        block13: {
            PixelDataFormat pixelDataFormat = JpegImage.b(jpegOptions.getColorType(), jpegOptions.getBitsPerChannel());
            Rectangle rectangle2 = Rectangle.intersect(rasterImage.getBounds(), rectangle);
            E e2 = new E();
            e2.a(rectangle2.getWidth());
            e2.b(rectangle2.getHeight());
            e2.f(jpegOptions.getJpegLsAllowedLossyError());
            e2.g(jpegOptions.getJpegLsInterleaveMode());
            e2.a(jpegOptions.getJpegLsPreset());
            e2.c(jpegOptions.getBitsPerChannel() & 0xFF);
            e2.e(pixelDataFormat.getChannelsCount());
            byte[] byArray = jpegOptions.getHorizontalSampling();
            byte[] byArray2 = jpegOptions.getVerticalSampling();
            byte[] byArray3 = new byte[e2.e()];
            byte[] byArray4 = new byte[e2.e()];
            for (int i2 = 0; i2 < e2.e(); ++i2) {
                byArray3[i2] = byArray == null ? (byte)1 : byArray[i2];
                byArray4[i2] = byArray2 == null ? (byte)1 : byArray2[i2];
            }
            e2.a(byArray3);
            e2.b(byArray4);
            e2.p();
            I i3 = new I(v2, e2, new Rectangle(Point.getEmpty(), rectangle2.getSize()), rasterImage.h());
            try {
                RawDataSettings rawDataSettings = new RawDataSettings();
                rawDataSettings.setPixelDataFormat(pixelDataFormat);
                if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) break block13;
                if (rasterImage.isRawDataAvailable() && rawDataSettings.getPixelDataFormat().getBitsPerPixel() == rasterImage.getRawDataFormat().getBitsPerPixel() && jpegOptions.getColorType() != 3) {
                    rawDataSettings.setColorPalette(null);
                    rawDataSettings.setCustomColorConverter(rasterImage.getRawCustomColorConverter());
                    rawDataSettings.setFallbackIndex(rasterImage.getRawFallbackIndex());
                    rawDataSettings.setIndexedColorConverter(rasterImage.getRawIndexedColorConverter());
                    rawDataSettings.setLineSize(rectangle.getWidth() * rawDataSettings.getPixelDataFormat().getChannelsCount());
                    bi bi2 = new bi(rasterImage, rawDataSettings, rectangle, i3);
                    try {
                        rasterImage.loadRawData(rectangle2, rectangle2, rawDataSettings, bi2);
                        break block13;
                    }
                    finally {
                        bi2.dispose();
                    }
                }
                o o2 = com.aspose.imaging.internal.fb.o.a(i3, jpegOptions);
                bg bg2 = new bg(rasterImage, rectangle, o2, rasterImage.getPalette());
                try {
                    IPartialArgb32PixelLoader iPartialArgb32PixelLoader = bg2;
                    if (rasterImage.hasTransparentColor() && rasterImage.hasBackgroundColor()) {
                        iPartialArgb32PixelLoader = new ca(rasterImage.getTransparentColor().toArgb(), rasterImage.getBackgroundColor().toArgb(), iPartialArgb32PixelLoader);
                    }
                    if (rasterImage.hasAlpha() && jpegOptions.getPreblendAlphaIfPresent()) {
                        iPartialArgb32PixelLoader = new j(Color.getWhite().toArgb(), iPartialArgb32PixelLoader);
                    }
                    rasterImage.loadPartialArgb32Pixels(rectangle2, iPartialArgb32PixelLoader);
                }
                finally {
                    bg2.dispose();
                }
            }
            finally {
                i3.dispose();
            }
        }
    }

    private static PixelDataFormat b(int n2, int n3) {
        PixelDataFormat pixelDataFormat;
        if (n3 != 8 && n3 != 12) {
            throw new NotSupportedException("Jpeg DCT supports only 8 or 12 bits per channel.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(n3);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(n3);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(n3);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(n3);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(n3);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    private static PixelDataFormat a(int n2, byte by2) {
        PixelDataFormat pixelDataFormat;
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
            throw new NotSupportedException("Lossless JPEG supports only 2 - 16 bits per channel");
        }
        if ((by2 & 0xFF) > 8) {
            throw new NotSupportedException("More than 8 bits per channel is not supported yet.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    private static PixelDataFormat b(int n2, byte by2) {
        PixelDataFormat pixelDataFormat;
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 16) {
            throw new NotSupportedException("JPEG-LS supports only 2-16 bits per channel");
        }
        if ((by2 & 0xFF) > 8) {
            throw new NotSupportedException("Only 2-8 bits per channel is supported in JPEG-LS at the moment.");
        }
        switch (n2) {
            case 0: {
                pixelDataFormat = PixelDataFormat.getGrayscale(by2 & 0xFF);
                break;
            }
            case 1: {
                pixelDataFormat = PixelDataFormat.getYCbCr(by2 & 0xFF);
                break;
            }
            case 4: {
                pixelDataFormat = PixelDataFormat.getRgb(by2 & 0xFF);
                break;
            }
            case 2: {
                pixelDataFormat = PixelDataFormat.getCmyk(by2 & 0xFF);
                break;
            }
            case 3: {
                pixelDataFormat = PixelDataFormat.getYcck(by2 & 0xFF);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType");
            }
        }
        return pixelDataFormat;
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        JpegImage.a(this, stream, this.getJfif(), this.getExifData(), this.getXmpData(), this.o, this.i, this.getBounds());
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.j = n2;
        this.h = n3;
    }

    private static void a(StreamContainer streamContainer, JpegExifData jpegExifData) {
        if (jpegExifData == null) {
            return;
        }
        byte[] byArray = JpegImage.a(jpegExifData);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void a(StreamContainer streamContainer, XmpPacketWrapper xmpPacketWrapper) {
        if (xmpPacketWrapper == null) {
            return;
        }
        byte[] byArray = JpegImage.a(xmpPacketWrapper);
        streamContainer.write(byArray, 0, byArray.length);
    }

    private static void b(StreamContainer streamContainer) {
        streamContainer.writeByte((byte)-1);
        streamContainer.writeByte((byte)-40);
    }

    private static void a(V v2) {
        v2.writeByte((byte)-1);
        v2.writeByte((byte)-39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(StreamContainer streamContainer, String string) {
        byte[] byArray;
        if (aV.b(string)) {
            return;
        }
        byte[] byArray2 = com.aspose.imaging.internal.lC.l.x().c(string);
        StreamContainer streamContainer2 = new StreamContainer(new MemoryStream(), true);
        try {
            TiffBigEndianStreamWriter tiffBigEndianStreamWriter = new TiffBigEndianStreamWriter(streamContainer2);
            byte[] byArray3 = new byte[]{-1, -2};
            tiffBigEndianStreamWriter.write(byArray3);
            tiffBigEndianStreamWriter.writeUShort(byArray2.length + 2 & 0xFFFF);
            tiffBigEndianStreamWriter.write(byArray2);
            byArray = streamContainer2.toBytes();
        }
        finally {
            streamContainer2.dispose();
        }
        streamContainer.write(byArray, 0, byArray.length);
    }

    private void a(bx bx2) {
        this.a(bx2, bx2.a().getWidth(), bx2.a().getHeight());
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3) {
        Object object;
        Object object2;
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.j = n2;
        this.h = n3;
        this.i = new JpegOptions();
        n n4 = (n)((Object)com.aspose.imaging.internal.pR.d.a(iRasterImageArgb32PixelLoader, n.class));
        if (n4 != null) {
            if (n4.d() == 3) {
                object2 = n4.e().g();
                this.i.setJpegLsAllowedLossyError(((T)object2).c & 0xFF);
                this.i.setJpegLsInterleaveMode(((T)object2).b);
                this.i.setJpegLsPreset(n4.e().h());
            }
            object2 = n4.e().e();
            object = ((r)object2).b();
            byte[] byArray = new byte[((l[])object).length];
            byte[] byArray2 = new byte[((l[])object).length];
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                byArray[i2] = ((l)object[i2]).c();
                byArray2[i2] = ((l)object[i2]).l();
            }
            this.i.setHorizontalSampling(byArray);
            this.i.setVerticalSampling(byArray2);
            this.i.setCompressionType(n4.d());
        }
        if ((object2 = (bx)((Object)com.aspose.imaging.internal.pR.d.a(iRasterImageArgb32PixelLoader, bx.class))) != null && ((bx)object2).a() != null && (object = (JpegImage)((Object)com.aspose.imaging.internal.pR.d.a(((bx)object2).a(), JpegImage.class))) != null) {
            this.i.setExifData(((JpegImage)object).getExifData());
            this.i.setComment(((JpegImage)object).getComment());
            this.i.setJfif(((JpegImage)object).getJfif());
            this.i.setXmpData(((JpegImage)object).getXmpData());
        }
    }

    public static JpegImage a(int n2, int n3, int n4, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new JpegImage(n2, n3, n4, iRasterImageArgb32PixelLoader);
    }
}

