/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.core.vectorpaths;

import com.aspose.imaging.Point;
import com.aspose.imaging.PointF;
import com.aspose.imaging.fileformats.core.vectorpaths.VectorPathRecord;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.ay.w;
import com.aspose.imaging.internal.cc.a;

public class BezierKnotRecord
extends VectorPathRecord {
    private static final int b = 2;
    private static final int c = 4;
    private boolean d;
    private boolean e;
    private Point[] f;

    public BezierKnotRecord() {
    }

    public BezierKnotRecord(byte[] byArray) {
        this.a = byArray;
        short s2 = w.g(byArray, 0);
        switch (s2) {
            case 1: {
                this.d = true;
                this.e = true;
                break;
            }
            case 2: {
                this.d = true;
                this.e = false;
                break;
            }
            case 4: {
                this.d = false;
                this.e = true;
                break;
            }
            case 5: {
                this.d = false;
                this.e = false;
                break;
            }
            default: {
                throw new ArgumentException("Can not create Bezier Knot Record from specified byte array. Byte array doesn't contain Bezier Knot Record markers");
            }
        }
        this.f = new Point[3];
        int n2 = 2;
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            int n3 = w.c(byArray, n2);
            int n4 = w.c(byArray, n2 += 4);
            this.f[i2] = new Point(n3, n4);
            n2 += 4;
        }
    }

    public final PointF[] getPathPoints() {
        return com.aspose.imaging.internal.cc.a.a(this.getPoints());
    }

    public final void setPathPoints(PointF[] pointFArray) {
        this.f = com.aspose.imaging.internal.cc.a.a(pointFArray);
    }

    public final Point[] getPoints() {
        return this.f;
    }

    public final void setPoints(Point[] pointArray) {
        if (pointArray.length != 3) {
            throw new ArgumentException("Length of point array must be 3. Bezier Knot Record uses 3 points.");
        }
        this.f = pointArray;
    }

    public final boolean isClosed() {
        return this.d;
    }

    public final void setClosed(boolean bl2) {
        this.d = bl2;
    }

    public final boolean isLinked() {
        return this.e;
    }

    public final void setLinked(boolean bl2) {
        this.e = bl2;
    }

    public final boolean isOpen() {
        return !this.d;
    }

    public final void setOpen(boolean bl2) {
        this.d = !bl2;
    }

    @Override
    public short getType() {
        if (this.d) {
            if (this.e) {
                return 1;
            }
            return 2;
        }
        if (this.e) {
            return 4;
        }
        return 5;
    }

    @Override
    public byte[] a() {
        byte[] byArray = new byte[VectorPathRecord.b()];
        byArray[1] = (byte)this.getType();
        for (int i2 = 0; i2 < 3; ++i2) {
            w.a(this.f[i2].getX(), byArray, 2 + 8 * i2);
            w.a(this.f[i2].getY(), byArray, 2 + (4 + 8 * i2));
        }
        return byArray;
    }
}

