/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.PointF;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.SizeF;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.kN.aV;
import com.aspose.imaging.internal.kN.bC;
import com.aspose.imaging.internal.pR.i;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class RectangleF
extends i<RectangleF> {
    private static final RectangleF a = new RectangleF();
    private float b;
    private float c;
    private float d;
    private float e;

    public RectangleF() {
        this.d = 0.0f;
        this.e = 0.0f;
        this.c = 0.0f;
        this.b = 0.0f;
    }

    public RectangleF(float f2, float f3, float f4, float f5) {
        this.d = f2;
        this.e = f3;
        this.c = f4;
        this.b = f5;
    }

    public RectangleF(PointF pointF, SizeF sizeF) {
        this.d = pointF.getX();
        this.e = pointF.getY();
        this.c = sizeF.getWidth();
        this.b = sizeF.getHeight();
    }

    public static RectangleF getEmpty() {
        return a.Clone();
    }

    public PointF getLocation() {
        return new PointF(this.d, this.e);
    }

    public void setLocation(PointF pointF) {
        this.d = pointF.getX();
        this.e = pointF.getY();
    }

    public SizeF getSize() {
        return new SizeF(this.c, this.b);
    }

    public void setSize(SizeF sizeF) {
        this.c = sizeF.getWidth();
        this.b = sizeF.getHeight();
    }

    public float getX() {
        return this.d;
    }

    public void setX(float f2) {
        this.d = f2;
    }

    public float getY() {
        return this.e;
    }

    public void setY(float f2) {
        this.e = f2;
    }

    public float getWidth() {
        return this.c;
    }

    public void setWidth(float f2) {
        this.c = f2;
    }

    public float getHeight() {
        return this.b;
    }

    public void setHeight(float f2) {
        this.b = f2;
    }

    public float getLeft() {
        return this.d;
    }

    public void setLeft(float f2) {
        float f3 = f2 - this.d;
        this.d = f2;
        this.c -= f3;
    }

    public float getTop() {
        return this.e;
    }

    public void setTop(float f2) {
        float f3 = f2 - this.e;
        this.e = f2;
        this.b -= f3;
    }

    public float getRight() {
        return this.d + this.c;
    }

    public void setRight(float f2) {
        float f3 = f2 - this.getRight();
        this.c += f3;
    }

    public float getBottom() {
        return this.e + this.b;
    }

    public void setBottom(float f2) {
        float f3 = f2 - this.getBottom();
        this.b += f3;
    }

    public boolean isEmpty() {
        if (this.c > 0.0f) {
            return this.b <= 0.0f;
        }
        return true;
    }

    public static RectangleF fromPoints(PointF pointF, PointF pointF2) {
        float f2 = bC.b(pointF.getX(), pointF2.getX());
        float f3 = bC.a(pointF.getX(), pointF2.getX());
        float f4 = bC.b(pointF.getY(), pointF2.getY());
        float f5 = bC.a(pointF.getY(), pointF2.getY());
        return RectangleF.fromLeftTopRightBottom(f2, f4, f3, f5);
    }

    public static RectangleF inflate(RectangleF rectangleF, float f2, float f3) {
        RectangleF rectangleF2 = rectangleF.Clone();
        rectangleF2.inflate(f2, f3);
        return rectangleF2;
    }

    public static RectangleF intersect(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = bC.a(rectangleF.d, rectangleF2.d);
        float f3 = bC.b(rectangleF.d + rectangleF.c, rectangleF2.d + rectangleF2.c);
        float f4 = bC.a(rectangleF.e, rectangleF2.e);
        float f5 = bC.b(rectangleF.e + rectangleF.b, rectangleF2.e + rectangleF2.b);
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return a.Clone();
    }

    public static RectangleF union(RectangleF rectangleF, RectangleF rectangleF2) {
        float f2 = bC.b(rectangleF.d, rectangleF2.d);
        float f3 = bC.a(rectangleF.d + rectangleF.c, rectangleF2.d + rectangleF2.c);
        float f4 = bC.b(rectangleF.e, rectangleF2.e);
        float f5 = bC.a(rectangleF.e + rectangleF.b, rectangleF2.e + rectangleF2.b);
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean op_Equality(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.d == rectangleF2.d && rectangleF.e == rectangleF2.e && rectangleF.c == rectangleF2.c && rectangleF.b == rectangleF2.b;
    }

    public static boolean op_Inequality(RectangleF rectangleF, RectangleF rectangleF2) {
        return !RectangleF.op_Equality(rectangleF, rectangleF2);
    }

    public static RectangleF op_Multiply(RectangleF rectangleF, float f2) {
        return new RectangleF(rectangleF.d * f2, rectangleF.e * f2, rectangleF.c * f2, rectangleF.b * f2);
    }

    public static RectangleF op_Division(RectangleF rectangleF, float f2) {
        if (f2 == 0.0f) {
            throw new ArgumentOutOfRangeException("divider", "Division by zero is not allowed.");
        }
        return new RectangleF(rectangleF.d / f2, rectangleF.e / f2, rectangleF.c / f2, rectangleF.b / f2);
    }

    public static RectangleF to_RectangleF(Rectangle rectangle) {
        return new RectangleF(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static RectangleF fromLeftTopRightBottom(float f2, float f3, float f4, float f5) {
        return new RectangleF(f2, f3, f4 - f2, f5 - f3);
    }

    public void normalize() {
        if (this.c < 0.0f) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0.0f) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean contains(float f2, float f3) {
        return this.d <= f2 && f2 < this.d + this.c && this.e <= f3 && f3 < this.e + this.b;
    }

    public boolean contains(PointF pointF) {
        return this.contains(pointF.getX(), pointF.getY());
    }

    public boolean contains(RectangleF rectangleF) {
        return this.d <= rectangleF.d && rectangleF.d + rectangleF.c <= this.d + this.c && this.e <= rectangleF.e && rectangleF.e + rectangleF.b <= this.e + this.b;
    }

    public void inflate(float f2, float f3) {
        this.d -= f2;
        this.e -= f3;
        this.c += 2.0f * f2;
        this.b += 2.0f * f3;
    }

    public void inflate(SizeF sizeF) {
        this.inflate(sizeF.getWidth(), sizeF.getHeight());
    }

    public void intersect(RectangleF rectangleF) {
        RectangleF rectangleF2 = RectangleF.intersect(rectangleF, this);
        this.d = rectangleF2.d;
        this.e = rectangleF2.e;
        this.c = rectangleF2.c;
        this.b = rectangleF2.b;
    }

    public boolean intersectsWith(RectangleF rectangleF) {
        return rectangleF.d < this.d + this.c && this.d < rectangleF.d + rectangleF.c && rectangleF.e < this.e + this.b && this.e < rectangleF.e + rectangleF.b;
    }

    public void offset(PointF pointF) {
        this.offset(pointF.getX(), pointF.getY());
    }

    public void offset(float f2, float f3) {
        this.d += f2;
        this.e += f3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RectangleF)) {
            return false;
        }
        RectangleF rectangleF = (RectangleF)object;
        return rectangleF.d == this.d && rectangleF.e == this.e && rectangleF.c == this.c && rectangleF.b == this.b;
    }

    public int hashCode() {
        return (int)((long)this.d ^ ((long)this.e << 13 | (long)this.e >> 19) ^ ((long)this.c << 26 | (long)this.c >> 6) ^ ((long)this.b << 7 | (long)this.b >> 25));
    }

    public String toString() {
        return aV.a(com.aspose.imaging.internal.lb.i.h(), "{{X={0}, Y={1}, Width={2}, Height={3}}}", Float.valueOf(this.d), Float.valueOf(this.e), Float.valueOf(this.c), Float.valueOf(this.b));
    }

    @Override
    public void CloneTo(RectangleF rectangleF) {
        rectangleF.b = this.b;
        rectangleF.c = this.c;
        rectangleF.d = this.d;
        rectangleF.e = this.e;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public static boolean isEquals(RectangleF rectangleF, RectangleF rectangleF2) {
        return rectangleF.equals(rectangleF2);
    }
}

