/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.system.io;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.ObjectDisposedException;
import com.aspose.imaging.internal.lR.l;
import com.aspose.imaging.internal.lr.D;
import com.aspose.imaging.system.SerializableAttribute;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;

@SerializableAttribute
public class StreamWriter
extends D {
    private l a;
    private Stream b;
    private static final int c = 1024;
    private static final int d = 4096;
    private static final int e = 256;
    private byte[] f;
    private char[] g;
    private int h;
    private int i;
    private boolean j;
    private boolean k;
    private boolean l;
    public static StreamWriter Null = new StreamWriter(Stream.Null, com.aspose.imaging.internal.lR.l.y(), 1);
    private static final boolean m = false;

    public StreamWriter(Stream stream) {
        this(stream, com.aspose.imaging.internal.lR.l.y(), 1024);
    }

    public StreamWriter(Stream stream, l encoding) {
        this(stream, encoding, 1024);
    }

    void initialize(l encoding, int bufferSize) {
        this.a = encoding;
        this.h = 0;
        this.i = 0;
        int n2 = Math.max(bufferSize, 256);
        this.g = new char[n2];
        this.f = new byte[encoding.c(n2)];
        if (this.b.canSeek() && this.b.getPosition() > 0L) {
            this.l = true;
        }
    }

    public StreamWriter(Stream stream, l encoding, int bufferSize) {
        if (null == stream) {
            throw new ArgumentNullException("stream");
        }
        if (null == encoding) {
            throw new ArgumentNullException("encoding");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize");
        }
        if (!stream.canWrite()) {
            throw new ArgumentException("Can not write to stream");
        }
        this.b = stream;
        this.initialize(encoding, bufferSize);
    }

    public StreamWriter(String path) {
        this(path, false, com.aspose.imaging.internal.lR.l.y(), 4096);
    }

    public StreamWriter(String path, boolean append) {
        this(path, append, com.aspose.imaging.internal.lR.l.y(), 4096);
    }

    public StreamWriter(String path, boolean append, l encoding) {
        this(path, append, encoding, 4096);
    }

    public StreamWriter(String path, boolean append, l encoding, int bufferSize) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (null == encoding) {
            throw new ArgumentNullException("encoding");
        }
        if (bufferSize <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize");
        }
        int n2 = append ? 6 : 2;
        this.b = new FileStream(path, n2, 2, 1);
        if (append) {
            this.b.setPosition(this.b.getLength());
        } else {
            this.b.setLength(0L);
        }
        this.initialize(encoding, bufferSize);
    }

    public boolean getAutoFlush() {
        return this.j;
    }

    public void setAutoFlush(boolean value) {
        this.j = value;
        if (this.j) {
            this.flush();
        }
    }

    public Stream getBaseStream() {
        return this.b;
    }

    @Override
    public l getEncoding() {
        return this.a;
    }

    @Override
    protected void dispose(boolean disposing) {
        RuntimeException runtimeException;
        block6: {
            runtimeException = null;
            if (!this.k && disposing && this.b != null) {
                try {
                    this.flush();
                }
                catch (RuntimeException runtimeException2) {
                    runtimeException = runtimeException2;
                }
                this.k = true;
                try {
                    this.b.close();
                }
                catch (RuntimeException runtimeException3) {
                    if (runtimeException != null) break block6;
                    runtimeException = runtimeException3;
                }
            }
        }
        this.b = null;
        this.f = null;
        this.a = null;
        this.g = null;
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    @Override
    public void flush() {
        this.c();
        this.b();
        if (this.h > 0) {
            this.a();
            this.b.flush();
        }
    }

    private void a() {
        if (!this.l && this.h > 0) {
            byte[] byArray = this.a.i();
            if (byArray.length > 0) {
                this.b.write(byArray, 0, byArray.length);
            }
            this.l = true;
        }
        this.b.write(this.f, 0, this.h);
        this.h = 0;
    }

    private void b() {
        if (this.h > 0) {
            this.a();
        }
        if (this.i > 0) {
            int n2 = this.a.a(this.g, 0, this.i, this.f, this.h);
            this.h += n2;
            this.i = 0;
        }
    }

    @Override
    public void write(char[] buffer, int index, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (index > buffer.length - count) {
            throw new ArgumentException("index + count > buffer.Length");
        }
        this.c();
        this.a(buffer, index, count);
        if (this.j) {
            this.flush();
        }
    }

    private void a(char[] cArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.g.length - this.i;
            if (n4 == 0) {
                this.b();
                n4 = this.g.length;
            }
            if (n4 > n3) {
                n4 = n3;
            }
            System.arraycopy(cArray, n2, this.g, this.i, n4);
            n3 -= n4;
            n2 += n4;
            this.i += n4;
        }
    }

    private void a(String string) {
        int n2 = string.length();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.g.length - this.i;
            if (n4 == 0) {
                this.b();
                n4 = this.g.length;
            }
            if (n4 > n2) {
                n4 = n2;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                this.g[i2 + this.i] = string.charAt(i2 + n3);
            }
            n2 -= n4;
            n3 += n4;
            this.i += n4;
        }
    }

    @Override
    public void write(char value) {
        this.c();
        if (this.i >= this.g.length) {
            this.b();
        }
        this.g[this.i++] = value;
        if (this.j) {
            this.flush();
        }
    }

    @Override
    public void write(char[] buffer) {
        this.c();
        if (buffer != null) {
            this.a(buffer, 0, buffer.length);
        }
        if (this.j) {
            this.flush();
        }
    }

    @Override
    public void write(String value) {
        this.c();
        if (value != null) {
            this.a(value);
        }
        if (this.j) {
            this.flush();
        }
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    private void c() {
        if (this.k) {
            throw new ObjectDisposedException("StreamWriter");
        }
    }
}

