/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.masking;

import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.asynctask.IAsyncTask;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.iO.a;
import com.aspose.imaging.internal.iU.b;
import com.aspose.imaging.internal.jk.c;
import com.aspose.imaging.internal.jk.d;
import com.aspose.imaging.internal.lr.k;
import com.aspose.imaging.masking.IMaskingSession;
import com.aspose.imaging.masking.options.AutoMaskingGraphCutOptions;
import com.aspose.imaging.masking.options.MaskingOptions;
import com.aspose.imaging.masking.result.MaskingResult;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public class ImageMasking {
    private final RasterImage a;

    public ImageMasking(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("sourceImage", "source image is null.");
        }
        this.a = rasterImage;
    }

    public static void applyMask(RasterImage rasterImage, RasterImage rasterImage2, MaskingOptions maskingOptions) {
        if (rasterImage == null) {
            throw new ArgumentNullException("targetImage", "Target image is null.");
        }
        if (rasterImage2 == null) {
            throw new ArgumentNullException("mask", "Image mask is null.");
        }
        if (maskingOptions == null) {
            throw new ArgumentNullException("maskingOptions", "Masking options is null.");
        }
        Rectangle rectangle = rasterImage.getBounds().Clone();
        if (!maskingOptions.getMaskingArea().isEmpty()) {
            rectangle.intersect(maskingOptions.getMaskingArea());
        }
        if (Size.op_Inequality(rasterImage2.getSize(), rectangle.getSize())) {
            throw new ArgumentOutOfRangeException("mask", "Image mask is not the right size.");
        }
        if (Rectangle.op_Inequality(rectangle, rasterImage.getBounds())) {
            rasterImage.crop(rectangle);
        }
        b.a(rasterImage, rasterImage2, maskingOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MaskingResult decompose(MaskingOptions maskingOptions) {
        d.a((c)this.a, 4);
        d.a((c)this.a, EventType.PreProcessing);
        this.a(maskingOptions);
        a a2 = com.aspose.imaging.internal.iQ.c.a(this.a, maskingOptions);
        try {
            d.a((c)this.a, EventType.PreProcessing);
            a2.f();
            d.a((c)this.a, EventType.Processing);
            a2.a(true);
            d.a((c)this.a, EventType.Finalization);
            MaskingResult maskingResult = a2.c();
            return maskingResult;
        }
        finally {
            a2.close();
        }
    }

    public final IAsyncTask decomposeAsync(MaskingOptions maskingOptions) {
        return new com.aspose.imaging.internal.iO.c(this.a, maskingOptions);
    }

    public final IMaskingSession createSession(MaskingOptions maskingOptions) {
        return new com.aspose.imaging.internal.iO.d(this.a, maskingOptions);
    }

    public final IMaskingSession loadSession(InputStream inputStream) {
        return this.loadSession(Stream.fromJava(inputStream));
    }

    public final IMaskingSession loadSession(Stream stream) {
        return new com.aspose.imaging.internal.iO.d(this.a, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IMaskingSession loadSession(String string) {
        FileStream fileStream = k.f(string);
        try {
            IMaskingSession iMaskingSession = this.loadSession(fileStream);
            return iMaskingSession;
        }
        finally {
            fileStream.dispose();
        }
    }

    private void a(MaskingOptions maskingOptions) {
        AutoMaskingGraphCutOptions autoMaskingGraphCutOptions = (AutoMaskingGraphCutOptions)((Object)com.aspose.imaging.internal.qg.d.a(maskingOptions, AutoMaskingGraphCutOptions.class));
        if (autoMaskingGraphCutOptions != null) {
            autoMaskingGraphCutOptions.b(this.a);
        }
    }
}

