/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSSigner;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.f;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.k;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;
import java.text.ParseException;

public class XMSS {
    private final XMSSParameters a;
    private f b;
    private SecureRandom c;
    private XMSSPrivateKeyParameters d;
    private XMSSPublicKeyParameters e;

    public XMSS(XMSSParameters xMSSParameters, SecureRandom secureRandom) {
        if (xMSSParameters == null) {
            throw new NullPointerException("params == null");
        }
        this.a = xMSSParameters;
        this.b = xMSSParameters.getWOTSPlus();
        this.c = secureRandom;
    }

    public void generateKeys() {
        XMSSKeyPairGenerator xMSSKeyPairGenerator = new XMSSKeyPairGenerator();
        xMSSKeyPairGenerator.init(new XMSSKeyGenerationParameters(this.getParams(), this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = xMSSKeyPairGenerator.generateKeyPair();
        this.d = (XMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.e = (XMSSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        this.b.a(new byte[this.a.getDigestSize()], this.d.getPublicSeed());
    }

    void importState(XMSSPrivateKeyParameters xMSSPrivateKeyParameters, XMSSPublicKeyParameters xMSSPublicKeyParameters) {
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getRoot(), xMSSPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.d = xMSSPrivateKeyParameters;
        this.e = xMSSPublicKeyParameters;
        this.b.a(new byte[this.a.getDigestSize()], this.d.getPublicSeed());
    }

    public void importState(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.a).withPrivateKey(byArray, this.getParams()).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.a).withPublicKey(byArray2).build();
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getRoot(), xMSSPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.d = xMSSPrivateKeyParameters;
        this.e = xMSSPublicKeyParameters;
        this.b.a(new byte[this.a.getDigestSize()], this.d.getPublicSeed());
    }

    public byte[] sign(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        XMSSSigner xMSSSigner = new XMSSSigner();
        xMSSSigner.init(true, this.d);
        byte[] byArray2 = xMSSSigner.generateSignature(byArray);
        this.d = (XMSSPrivateKeyParameters)xMSSSigner.getUpdatedPrivateKey();
        this.importState(this.d, this.e);
        return byArray2;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) throws ParseException {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (byArray3 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSSigner xMSSSigner = new XMSSSigner();
        xMSSSigner.init(false, new XMSSPublicKeyParameters.Builder(this.getParams()).withPublicKey(byArray3).build());
        return xMSSSigner.verifySignature(byArray, byArray2);
    }

    public byte[] exportPrivateKey() {
        return this.d.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.e.toByteArray();
    }

    protected k wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.a.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.b.a(this.b.b(this.d.getSecretKeySeed(), oTSHashAddress), this.getPublicSeed());
        return this.b.a(byArray, oTSHashAddress);
    }

    public XMSSParameters getParams() {
        return this.a;
    }

    protected f getWOTSPlus() {
        return this.b;
    }

    public byte[] getRoot() {
        return this.d.getRoot();
    }

    protected void setRoot(byte[] byArray) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(this.getPublicSeed()).withRoot(byArray).withBDSState(this.d.getBDSState()).build();
        this.e = new XMSSPublicKeyParameters.Builder(this.a).withRoot(byArray).withPublicSeed(this.getPublicSeed()).build();
    }

    public int getIndex() {
        return this.d.getIndex();
    }

    protected void setIndex(int n2) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(this.d.getPublicSeed()).withRoot(this.d.getRoot()).withBDSState(this.d.getBDSState()).build();
    }

    public byte[] getPublicSeed() {
        return this.d.getPublicSeed();
    }

    protected void setPublicSeed(byte[] byArray) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(byArray).withRoot(this.getRoot()).withBDSState(this.d.getBDSState()).build();
        this.e = new XMSSPublicKeyParameters.Builder(this.a).withRoot(this.getRoot()).withPublicSeed(byArray).build();
        this.b.a(new byte[this.a.getDigestSize()], byArray);
    }

    public XMSSPrivateKeyParameters getPrivateKey() {
        return this.d;
    }
}

