/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA1Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.MessageEncryptor;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.a;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.b;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.c;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private static final String a = "SHA1PRNG";
    private Digest b;
    private SecureRandom c;
    private int d;
    private int e;
    private int f;
    McElieceCCA2KeyParameters key;
    private boolean g;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.g = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.c = parametersWithRandom.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                this.a((McElieceCCA2PublicKeyParameters)this.key);
            } else {
                this.c = new SecureRandom();
                this.key = (McElieceCCA2PublicKeyParameters)cipherParameters;
                this.a((McElieceCCA2PublicKeyParameters)this.key);
            }
        } else {
            this.key = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            this.a((McElieceCCA2PrivateKeyParameters)this.key);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) throws IllegalArgumentException {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void a(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.c = this.c != null ? this.c : new SecureRandom();
        this.b = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PublicKeyParameters.getDigest());
        this.d = mcElieceCCA2PublicKeyParameters.getN();
        this.e = mcElieceCCA2PublicKeyParameters.getK();
        this.f = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void a(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.b = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.d = mcElieceCCA2PrivateKeyParameters.getN();
        this.f = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] byArray) {
        if (!this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = new GF2Vector(this.e, this.c);
        byte[] byArray2 = gF2Vector.getEncoded();
        byte[] byArray3 = ByteUtils.concatenate(byArray2, byArray);
        this.b.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray4, 0);
        GF2Vector gF2Vector2 = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray4);
        byte[] byArray5 = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PublicKeyParameters)this.key, gF2Vector, gF2Vector2).getEncoded();
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray2);
        byte[] byArray6 = new byte[byArray.length];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray6[n2] = (byte)(byArray6[n2] ^ byArray[i2]);
        }
        return ByteUtils.concatenate(byArray5, byArray6);
    }

    @Override
    public byte[] messageDecrypt(byte[] byArray) throws InvalidCipherTextException {
        if (this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.d + 7 >> 3;
        int n3 = byArray.length - n2;
        byte[][] byArray2 = ByteUtils.split(byArray, n2);
        byte[] byArray3 = byArray2[0];
        byte[] byArray4 = byArray2[1];
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.d, byArray3);
        GF2Vector[] gF2VectorArray = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PrivateKeyParameters)this.key, gF2Vector);
        byte[] byArray5 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector2 = gF2VectorArray[1];
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray5);
        byte[] byArray6 = new byte[n3];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray4[i2]);
        }
        byte[] byArray7 = ByteUtils.concatenate(byArray5, byArray6);
        byte[] byArray8 = new byte[this.b.getDigestSize()];
        this.b.update(byArray7, 0, byArray7.length);
        this.b.doFinal(byArray8, 0);
        gF2Vector = com.aspose.imaging.internal.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray8);
        if (!gF2Vector.equals(gF2Vector2)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray6;
    }
}

