/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.crypto;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.Signer;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest a;
    private final MessageSigner b;
    private boolean c;

    public DigestingMessageSigner(MessageSigner messageSigner, Digest digest) {
        this.b = messageSigner;
        this.a = digest;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.c = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.b.init(bl2, cipherParameters);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        return this.b.generateSignature(byArray);
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.c) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray2, 0);
        return this.b.verifySignature(byArray2, byArray);
    }
}

