/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McElieceCCA2PublicKey
extends ASN1Object {
    private final int a;
    private final int b;
    private final GF2Matrix c;
    private final AlgorithmIdentifier d;

    public McElieceCCA2PublicKey(int n2, int n3, GF2Matrix gF2Matrix, AlgorithmIdentifier algorithmIdentifier) {
        this.a = n2;
        this.b = n3;
        this.c = new GF2Matrix(gF2Matrix.getEncoded());
        this.d = algorithmIdentifier;
    }

    private McElieceCCA2PublicKey(ASN1Sequence aSN1Sequence) {
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = new GF2Matrix(((ASN1OctetString)aSN1Sequence.getObjectAt(2)).getOctets());
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(3));
    }

    public int getN() {
        return this.a;
    }

    public int getT() {
        return this.b;
    }

    public GF2Matrix getG() {
        return this.c;
    }

    public AlgorithmIdentifier getDigest() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c.getEncoded()));
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }

    public static McElieceCCA2PublicKey getInstance(Object object) {
        if (object instanceof McElieceCCA2PublicKey) {
            return (McElieceCCA2PublicKey)object;
        }
        if (object != null) {
            return new McElieceCCA2PublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

