/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg;

import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.EntropySource;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class HMacSP800DRBG
implements SP80090DRBG {
    private static final long a = 0x800000000000L;
    private static final int b = 262144;
    private byte[] c;
    private byte[] d;
    private long e;
    private EntropySource f;
    private Mac g;
    private int h;

    public HMacSP800DRBG(Mac mac, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n2 > com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(mac)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n2) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this.h = n2;
        this.f = entropySource;
        this.g = mac;
        byte[] byArray3 = this.a();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        this.c = new byte[mac.getMacSize()];
        this.d = new byte[this.c.length];
        Arrays.fill(this.d, (byte)1);
        this.a(byArray4);
        this.e = 1L;
    }

    private void a(byte[] byArray) {
        this.a(byArray, (byte)0);
        if (byArray != null) {
            this.a(byArray, (byte)1);
        }
    }

    private void a(byte[] byArray, byte by2) {
        this.g.init(new KeyParameter(this.c));
        this.g.update(this.d, 0, this.d.length);
        this.g.update(by2);
        if (byArray != null) {
            this.g.update(byArray, 0, byArray.length);
        }
        this.g.doFinal(this.c, 0);
        this.g.init(new KeyParameter(this.c));
        this.g.update(this.d, 0, this.d.length);
        this.g.doFinal(this.d, 0);
    }

    @Override
    public int getBlockSize() {
        return this.d.length * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        int n2 = byArray.length * 8;
        if (n2 > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (this.e > 0x800000000000L) {
            return -1;
        }
        if (bl2) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (byArray2 != null) {
            this.a(byArray2);
        }
        byte[] byArray3 = new byte[byArray.length];
        int n3 = byArray.length / this.d.length;
        this.g.init(new KeyParameter(this.c));
        for (int i2 = 0; i2 < n3; ++i2) {
            this.g.update(this.d, 0, this.d.length);
            this.g.doFinal(this.d, 0);
            System.arraycopy(this.d, 0, byArray3, i2 * this.d.length, this.d.length);
        }
        if (n3 * this.d.length < byArray3.length) {
            this.g.update(this.d, 0, this.d.length);
            this.g.doFinal(this.d, 0);
            System.arraycopy(this.d, 0, byArray3, n3 * this.d.length, byArray3.length - n3 * this.d.length);
        }
        this.a(byArray2);
        ++this.e;
        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
        return n2;
    }

    @Override
    public void reseed(byte[] byArray) {
        byte[] byArray2 = this.a();
        byte[] byArray3 = Arrays.concatenate(byArray2, byArray);
        this.a(byArray3);
        this.e = 1L;
    }

    private byte[] a() {
        byte[] byArray = this.f.getEntropy();
        if (byArray.length < (this.h + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }
}

