/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.digests;

import com.aspose.imaging.internal.bouncycastle.crypto.digests.EncodableDigest;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.GeneralDigest;
import com.aspose.imaging.internal.bouncycastle.util.Memoable;
import com.aspose.imaging.internal.bouncycastle.util.Pack;

public class SHA1Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int a = 20;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int[] g = new int[80];
    private int h;
    private static final int i = 1518500249;
    private static final int j = 1859775393;
    private static final int k = -1894007588;
    private static final int l = -899497514;

    public SHA1Digest() {
        this.reset();
    }

    public SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.a(sHA1Digest);
    }

    public SHA1Digest(byte[] byArray) {
        super(byArray);
        this.b = Pack.bigEndianToInt(byArray, 16);
        this.c = Pack.bigEndianToInt(byArray, 20);
        this.d = Pack.bigEndianToInt(byArray, 24);
        this.e = Pack.bigEndianToInt(byArray, 28);
        this.f = Pack.bigEndianToInt(byArray, 32);
        this.h = Pack.bigEndianToInt(byArray, 36);
        for (int i2 = 0; i2 != this.h; ++i2) {
            this.g[i2] = Pack.bigEndianToInt(byArray, 40 + i2 * 4);
        }
    }

    private void a(SHA1Digest sHA1Digest) {
        this.b = sHA1Digest.b;
        this.c = sHA1Digest.c;
        this.d = sHA1Digest.d;
        this.e = sHA1Digest.e;
        this.f = sHA1Digest.f;
        System.arraycopy(sHA1Digest.g, 0, this.g, 0, sHA1Digest.g.length);
        this.h = sHA1Digest.h;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-1";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    protected void processWord(byte[] byArray, int n2) {
        int n3 = byArray[n2] << 24;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        this.g[this.h] = n3 |= byArray[++n2] & 0xFF;
        if (++this.h == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long l2) {
        if (this.h > 14) {
            this.processBlock();
        }
        this.g[14] = (int)(l2 >>> 32);
        this.g[15] = (int)l2;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        Pack.intToBigEndian(this.b, byArray, n2);
        Pack.intToBigEndian(this.c, byArray, n2 + 4);
        Pack.intToBigEndian(this.d, byArray, n2 + 8);
        Pack.intToBigEndian(this.e, byArray, n2 + 12);
        Pack.intToBigEndian(this.f, byArray, n2 + 16);
        this.reset();
        return 20;
    }

    @Override
    public void reset() {
        super.reset();
        this.b = 1732584193;
        this.c = -271733879;
        this.d = -1732584194;
        this.e = 271733878;
        this.f = -1009589776;
        this.h = 0;
        for (int i2 = 0; i2 != this.g.length; ++i2) {
            this.g[i2] = 0;
        }
    }

    private int a(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    private int b(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    private int c(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    @Override
    protected void processBlock() {
        int n2;
        int n3;
        int n4;
        for (n4 = 16; n4 < 80; ++n4) {
            n3 = this.g[n4 - 3] ^ this.g[n4 - 8] ^ this.g[n4 - 14] ^ this.g[n4 - 16];
            this.g[n4] = n3 << 1 | n3 >>> 31;
        }
        n4 = this.b;
        n3 = this.c;
        int n5 = this.d;
        int n6 = this.e;
        int n7 = this.f;
        int n8 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.a(n3, n5, n6) + this.g[n8++] + 1518500249;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.a(n4, n3, n5) + this.g[n8++] + 1518500249;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.a(n7, n4, n3) + this.g[n8++] + 1518500249;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.a(n6, n7, n4) + this.g[n8++] + 1518500249;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.a(n5, n6, n7) + this.g[n8++] + 1518500249;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.b(n3, n5, n6) + this.g[n8++] + 1859775393;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.b(n4, n3, n5) + this.g[n8++] + 1859775393;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.b(n7, n4, n3) + this.g[n8++] + 1859775393;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.b(n6, n7, n4) + this.g[n8++] + 1859775393;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.b(n5, n6, n7) + this.g[n8++] + 1859775393;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.c(n3, n5, n6) + this.g[n8++] + -1894007588;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.c(n4, n3, n5) + this.g[n8++] + -1894007588;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.c(n7, n4, n3) + this.g[n8++] + -1894007588;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.c(n6, n7, n4) + this.g[n8++] + -1894007588;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.c(n5, n6, n7) + this.g[n8++] + -1894007588;
            n5 = n5 << 30 | n5 >>> 2;
        }
        for (n2 = 0; n2 <= 3; ++n2) {
            n7 += (n4 << 5 | n4 >>> 27) + this.b(n3, n5, n6) + this.g[n8++] + -899497514;
            n3 = n3 << 30 | n3 >>> 2;
            n6 += (n7 << 5 | n7 >>> 27) + this.b(n4, n3, n5) + this.g[n8++] + -899497514;
            n4 = n4 << 30 | n4 >>> 2;
            n5 += (n6 << 5 | n6 >>> 27) + this.b(n7, n4, n3) + this.g[n8++] + -899497514;
            n7 = n7 << 30 | n7 >>> 2;
            n3 += (n5 << 5 | n5 >>> 27) + this.b(n6, n7, n4) + this.g[n8++] + -899497514;
            n6 = n6 << 30 | n6 >>> 2;
            n4 += (n3 << 5 | n3 >>> 27) + this.b(n5, n6, n7) + this.g[n8++] + -899497514;
            n5 = n5 << 30 | n5 >>> 2;
        }
        this.b += n4;
        this.c += n3;
        this.d += n5;
        this.e += n6;
        this.f += n7;
        this.h = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            this.g[n2] = 0;
        }
    }

    @Override
    public Memoable copy() {
        return new SHA1Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA1Digest sHA1Digest = (SHA1Digest)memoable;
        super.copyIn(sHA1Digest);
        this.a(sHA1Digest);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[40 + this.h * 4];
        super.populateState(byArray);
        Pack.intToBigEndian(this.b, byArray, 16);
        Pack.intToBigEndian(this.c, byArray, 20);
        Pack.intToBigEndian(this.d, byArray, 24);
        Pack.intToBigEndian(this.e, byArray, 28);
        Pack.intToBigEndian(this.f, byArray, 32);
        Pack.intToBigEndian(this.h, byArray, 36);
        for (int i2 = 0; i2 != this.h; ++i2) {
            Pack.intToBigEndian(this.g[i2], byArray, 40 + i2 * 4);
        }
        return byArray;
    }
}

