/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.PasswordRecipientInfoGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.b;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.w;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.x;
import com.aspose.imaging.internal.bouncycastle.operator.GenericKey;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JcePasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    private EnvelopedDataHelper a = new EnvelopedDataHelper(new b());

    public JcePasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        super(aSN1ObjectIdentifier, cArray);
    }

    public JcePasswordRecipientInfoGenerator setProvider(Provider provider) {
        this.a = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JcePasswordRecipientInfoGenerator setProvider(String string) {
        this.a = new EnvelopedDataHelper(new w(string));
        return this;
    }

    @Override
    protected byte[] calculateDerivedKey(int n2, AlgorithmIdentifier algorithmIdentifier, int n3) throws CMSException {
        return this.a.calculateDerivedKey(n2, this.password, algorithmIdentifier, n3);
    }

    @Override
    public byte[] generateEncryptedBytes(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, GenericKey genericKey) throws CMSException {
        Key key = this.a.getJceKey(genericKey);
        Cipher cipher = this.a.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets());
            cipher.init(3, (Key)new SecretKeySpec(byArray, cipher.getAlgorithm()), ivParameterSpec);
            return cipher.wrap(key);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("cannot process content encryption key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

