/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.RecipientEncryptedKey;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.Gost2814789EncryptedKey;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.a;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.b;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.v;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.w;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.x;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.y;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.GOST28147WrapParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.MQVParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.imaging.internal.bouncycastle.operator.DefaultSecretKeySizeProvider;
import com.aspose.imaging.internal.bouncycastle.operator.GenericKey;
import com.aspose.imaging.internal.bouncycastle.operator.SecretKeySizeProvider;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private SecretKeySizeProvider a = new DefaultSecretKeySizeProvider();
    private List b = new ArrayList();
    private List c = new ArrayList();
    private PublicKey d;
    private PrivateKey e;
    private EnvelopedDataHelper f = new EnvelopedDataHelper(new b());
    private SecureRandom g;
    private KeyPair h;
    private byte[] i;
    private static v j = new y();

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, PrivateKey privateKey, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        super(aSN1ObjectIdentifier, SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()), aSN1ObjectIdentifier2);
        this.d = publicKey;
        this.e = privateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setUserKeyingMaterial(byte[] byArray) {
        this.i = Arrays.clone(byArray);
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.f = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String string) {
        this.f = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.g = secureRandom;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.b.add(new KeyAgreeRecipientIdentifier(com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(x509Certificate)));
        this.c.add(x509Certificate.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] byArray, PublicKey publicKey) throws CertificateEncodingException {
        this.b.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(byArray)));
        this.c.add(publicKey);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, GenericKey genericKey) throws CMSException {
        if (this.b.isEmpty()) {
            throw new CMSException("No recipients associated with generator - use addRecipient()");
        }
        this.a(algorithmIdentifier.getAlgorithm());
        PrivateKey privateKey = this.e;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            PublicKey publicKey = (PublicKey)this.c.get(i2);
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = (KeyAgreeRecipientIdentifier)this.b.get(i2);
            try {
                DEROctetString dEROctetString;
                byte[] byArray;
                void var10_10;
                Object object;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = algorithmIdentifier2.getAlgorithm();
                if (com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(aSN1ObjectIdentifier)) {
                    MQVParameterSpec mQVParameterSpec = new MQVParameterSpec(this.h, publicKey, this.i);
                } else if (com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.b(aSN1ObjectIdentifier)) {
                    object = j.a(algorithmIdentifier2, this.a.getKeySize(aSN1ObjectIdentifier2), this.i);
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec((byte[])object);
                } else if (com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.d(aSN1ObjectIdentifier)) {
                    if (this.i != null) {
                        UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.i);
                    } else {
                        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_SSDH)) {
                            throw new CMSException("User keying material must be set for static keys.");
                        }
                        Object var10_14 = null;
                    }
                } else {
                    if (!com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.c(aSN1ObjectIdentifier)) throw new CMSException("Unknown key agreement algorithm: " + aSN1ObjectIdentifier);
                    if (this.i == null) throw new CMSException("User keying material must be set for static keys.");
                    UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(this.i);
                }
                object = this.f.createKeyAgreement(aSN1ObjectIdentifier);
                ((KeyAgreement)object).init(privateKey, (AlgorithmParameterSpec)var10_10, this.g);
                ((KeyAgreement)object).doPhase(publicKey, true);
                SecretKey secretKey = ((KeyAgreement)object).generateSecret(aSN1ObjectIdentifier2.getId());
                Cipher cipher = this.f.createCipher(aSN1ObjectIdentifier2);
                if (aSN1ObjectIdentifier2.equals(CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap) || aSN1ObjectIdentifier2.equals(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap)) {
                    cipher.init(3, (Key)secretKey, new GOST28147WrapParameterSpec(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet, this.i));
                    byArray = cipher.wrap(this.f.getJceKey(genericKey));
                    Gost2814789EncryptedKey gost2814789EncryptedKey = new Gost2814789EncryptedKey(Arrays.copyOfRange(byArray, 0, byArray.length - 4), Arrays.copyOfRange(byArray, byArray.length - 4, byArray.length));
                    dEROctetString = new DEROctetString(gost2814789EncryptedKey.getEncoded("DER"));
                } else {
                    cipher.init(3, (Key)secretKey, this.g);
                    byArray = cipher.wrap(this.f.getJceKey(genericKey));
                    dEROctetString = new DEROctetString(byArray);
                }
                aSN1EncodableVector.add(new RecipientEncryptedKey(keyAgreeRecipientIdentifier, dEROctetString));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("cannot perform agreement step: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            catch (IOException iOException) {
                throw new CMSException("unable to encode wrapped key: " + iOException.getMessage(), iOException);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    @Override
    protected byte[] getUserKeyingMaterial(AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        this.a(algorithmIdentifier.getAlgorithm());
        if (this.h != null) {
            OriginatorPublicKey originatorPublicKey = this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.h.getPublic().getEncoded()));
            try {
                if (this.i != null) {
                    return new MQVuserKeyingMaterial(originatorPublicKey, new DEROctetString(this.i)).getEncoded();
                }
                return new MQVuserKeyingMaterial(originatorPublicKey, null).getEncoded();
            }
            catch (IOException iOException) {
                throw new CMSException("unable to encode user keying material: " + iOException.getMessage(), iOException);
            }
        }
        return this.i;
    }

    private void a(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        if (this.g == null) {
            this.g = new SecureRandom();
        }
        if (com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(aSN1ObjectIdentifier) && this.h == null) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(this.d.getEncoded());
                AlgorithmParameters algorithmParameters = this.f.createAlgorithmParameters(aSN1ObjectIdentifier);
                algorithmParameters.init(subjectPublicKeyInfo.getAlgorithm().getParameters().toASN1Primitive().getEncoded());
                KeyPairGenerator keyPairGenerator = this.f.createKeyPairGenerator(aSN1ObjectIdentifier);
                keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class), this.g);
                this.h = keyPairGenerator.generateKeyPair();
            }
            catch (Exception exception) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + exception, exception);
            }
        }
    }
}

