/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.BERGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.BERSequenceGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.BERSet;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSet;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AuthenticatedData;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSAuthenticatedGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.o;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.imaging.internal.bouncycastle.operator.MacCalculator;
import com.aspose.imaging.internal.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int a;
    private boolean b;
    private MacCalculator c;

    public void setBufferSize(int n2) {
        this.a = n2;
    }

    public void setBEREncodeRecipients(boolean bl2) {
        this.b = bl2;
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator);
    }

    public OutputStream open(OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, outputStream, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator) throws CMSException {
        return this.open(aSN1ObjectIdentifier, outputStream, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.c = macCalculator;
        try {
            Object object2;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (Object object2 : this.recipientInfoGenerators) {
                aSN1EncodableVector.add(object2.generate(macCalculator.getKey()));
            }
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.authenticatedData);
            object2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            ((BERSequenceGenerator)object2).addObject(new ASN1Integer(AuthenticatedData.calculateVersion(this.originatorInfo)));
            if (this.originatorInfo != null) {
                ((BERSequenceGenerator)object2).addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            if (this.b) {
                ((BERGenerator)object2).getRawOutputStream().write(new BERSet(aSN1EncodableVector).getEncoded());
            } else {
                ((BERGenerator)object2).getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
            }
            AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
            ((BERGenerator)object2).getRawOutputStream().write(algorithmIdentifier.getEncoded());
            if (digestCalculator != null) {
                ((BERSequenceGenerator)object2).addObject(new DERTaggedObject(false, 1, digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(((BERGenerator)object2).getRawOutputStream());
            bERSequenceGenerator2.addObject(aSN1ObjectIdentifier);
            OutputStream outputStream2 = o.a(bERSequenceGenerator2.getRawOutputStream(), 0, false, this.a);
            TeeOutputStream teeOutputStream = digestCalculator != null ? new TeeOutputStream(outputStream2, digestCalculator.getOutputStream()) : new TeeOutputStream(outputStream2, macCalculator.getOutputStream());
            return new a(macCalculator, digestCalculator, aSN1ObjectIdentifier, teeOutputStream, bERSequenceGenerator, (BERSequenceGenerator)object2, bERSequenceGenerator2);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    private class a
    extends OutputStream {
        private OutputStream b;
        private BERSequenceGenerator c;
        private BERSequenceGenerator d;
        private BERSequenceGenerator e;
        private MacCalculator f;
        private DigestCalculator g;
        private ASN1ObjectIdentifier h;

        public a(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this.f = macCalculator;
            this.g = digestCalculator;
            this.h = aSN1ObjectIdentifier;
            this.b = outputStream;
            this.c = bERSequenceGenerator;
            this.d = bERSequenceGenerator2;
            this.e = bERSequenceGenerator3;
        }

        @Override
        public void write(int n2) throws IOException {
            this.b.write(n2);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.b.write(byArray, n2, n3);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.b.write(byArray);
        }

        @Override
        public void close() throws IOException {
            Map map;
            this.b.close();
            this.e.close();
            if (this.g != null) {
                map = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters(this.h, this.g.getAlgorithmIdentifier(), this.f.getAlgorithmIdentifier(), this.g.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet dERSet = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(map).toASN1EncodableVector());
                OutputStream outputStream = this.f.getOutputStream();
                outputStream.write(dERSet.getEncoded("DER"));
                outputStream.close();
                this.d.addObject(new DERTaggedObject(false, 2, dERSet));
            } else {
                map = Collections.unmodifiableMap(new HashMap());
            }
            this.d.addObject(new DEROctetString(this.f.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.d.addObject(new DERTaggedObject(false, 3, new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(map).toASN1EncodableVector())));
            }
            this.d.close();
            this.c.close();
        }
    }
}

