/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.path.validations;

import com.aspose.imaging.internal.bouncycastle.asn1.x509.BasicConstraints;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.path.CertPathValidation;
import com.aspose.imaging.internal.bouncycastle.cert.path.CertPathValidationContext;
import com.aspose.imaging.internal.bouncycastle.cert.path.CertPathValidationException;
import com.aspose.imaging.internal.bouncycastle.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean a;
    private BasicConstraints b;
    private int c;
    private BigInteger d;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        if (this.d != null && this.c < 0) {
            throw new CertPathValidationException("BasicConstraints path length exceeded");
        }
        certPathValidationContext.addHandledExtension(Extension.basicConstraints);
        BasicConstraints basicConstraints = BasicConstraints.fromExtensions(x509CertificateHolder.getExtensions());
        if (basicConstraints != null) {
            if (this.b != null) {
                int n2;
                BigInteger bigInteger;
                if (basicConstraints.isCA() && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n2 = bigInteger.intValue()) < this.c) {
                    this.c = n2;
                    this.b = basicConstraints;
                }
            } else {
                this.b = basicConstraints;
                if (basicConstraints.isCA()) {
                    this.d = basicConstraints.getPathLenConstraint();
                    if (this.d != null) {
                        this.c = this.d.intValue();
                    }
                }
            }
        } else if (this.b != null) {
            --this.c;
        }
        if (this.a && this.b == null) {
            throw new CertPathValidationException("BasicConstraints not present in path");
        }
    }

    @Override
    public Memoable copy() {
        BasicConstraintsValidation basicConstraintsValidation = new BasicConstraintsValidation(this.a);
        basicConstraintsValidation.b = this.b;
        basicConstraintsValidation.c = this.c;
        return basicConstraintsValidation;
    }

    @Override
    public void reset(Memoable memoable) {
        BasicConstraintsValidation basicConstraintsValidation = (BasicConstraintsValidation)memoable;
        this.a = basicConstraintsValidation.a;
        this.b = basicConstraintsValidation.b;
        this.c = basicConstraintsValidation.c;
    }
}

