/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x9;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class X9ECPoint
extends ASN1Object {
    private final ASN1OctetString a;
    private ECCurve b;
    private ECPoint c;

    public X9ECPoint(ECPoint eCPoint) {
        this(eCPoint, false);
    }

    public X9ECPoint(ECPoint eCPoint, boolean bl2) {
        this.c = eCPoint.normalize();
        this.a = new DEROctetString(eCPoint.getEncoded(bl2));
    }

    public X9ECPoint(ECCurve eCCurve, byte[] byArray) {
        this.b = eCCurve;
        this.a = new DEROctetString(Arrays.clone(byArray));
    }

    public X9ECPoint(ECCurve eCCurve, ASN1OctetString aSN1OctetString) {
        this(eCCurve, aSN1OctetString.getOctets());
    }

    public byte[] getPointEncoding() {
        return Arrays.clone(this.a.getOctets());
    }

    public synchronized ECPoint getPoint() {
        if (this.c == null) {
            this.c = this.b.decodePoint(this.a.getOctets()).normalize();
        }
        return this.c;
    }

    public boolean isPointCompressed() {
        byte[] byArray = this.a.getOctets();
        return byArray != null && byArray.length > 0 && (byArray[0] == 2 || byArray[0] == 3);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

