/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] a;

    public static GeneralNames getInstance(Object object) {
        if (object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object != null) {
            return new GeneralNames(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static GeneralNames fromExtensions(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return GeneralNames.getInstance(extensions.getExtensionParsedValue(aSN1ObjectIdentifier));
    }

    public GeneralNames(GeneralName generalName) {
        this.a = new GeneralName[]{generalName};
    }

    public GeneralNames(GeneralName[] generalNameArray) {
        this.a = generalNameArray;
    }

    private GeneralNames(ASN1Sequence aSN1Sequence) {
        this.a = new GeneralName[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            this.a[i2] = GeneralName.getInstance(aSN1Sequence.getObjectAt(i2));
        }
    }

    public GeneralName[] getNames() {
        GeneralName[] generalNameArray = new GeneralName[this.a.length];
        System.arraycopy(this.a, 0, generalNameArray, 0, this.a.length);
        return generalNameArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string);
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            stringBuffer.append("    ");
            stringBuffer.append(this.a[i2]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

