/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.esf;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.ResponderID;

public class OcspIdentifier
extends ASN1Object {
    private ResponderID a;
    private ASN1GeneralizedTime b;

    public static OcspIdentifier getInstance(Object object) {
        if (object instanceof OcspIdentifier) {
            return (OcspIdentifier)object;
        }
        if (object != null) {
            return new OcspIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private OcspIdentifier(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = ResponderID.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = (ASN1GeneralizedTime)aSN1Sequence.getObjectAt(1);
    }

    public OcspIdentifier(ResponderID responderID, ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.a = responderID;
        this.b = aSN1GeneralizedTime;
    }

    public ResponderID getOcspResponderID() {
        return this.a;
    }

    public ASN1GeneralizedTime getProducedAt() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

