/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.eac;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ParsingException;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERApplicationSpecific;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.CertificateBody;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.CertificateHolderReference;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.Flags;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.PackedDate;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;

public class CVCertificate
extends ASN1Object {
    private CertificateBody a;
    private byte[] b;
    private int c;
    private static int d = 1;
    private static int e = 2;

    private void a(ASN1ApplicationSpecific aSN1ApplicationSpecific) throws IOException {
        ASN1InputStream aSN1InputStream;
        this.c = 0;
        if (aSN1ApplicationSpecific.getApplicationTag() == 33) {
            ASN1Primitive aSN1Primitive;
            aSN1InputStream = new ASN1InputStream(aSN1ApplicationSpecific.getContents());
            block4: while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
                if (aSN1Primitive instanceof DERApplicationSpecific) {
                    DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1Primitive;
                    switch (dERApplicationSpecific.getApplicationTag()) {
                        case 78: {
                            this.a = CertificateBody.getInstance(dERApplicationSpecific);
                            this.c |= d;
                            continue block4;
                        }
                        case 55: {
                            this.b = dERApplicationSpecific.getContents();
                            this.c |= e;
                            continue block4;
                        }
                    }
                    throw new IOException("Invalid tag, not an Iso7816CertificateStructure :" + dERApplicationSpecific.getApplicationTag());
                }
                throw new IOException("Invalid Object, not an Iso7816CertificateStructure");
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE :" + aSN1ApplicationSpecific.getApplicationTag());
        }
        aSN1InputStream.close();
        if (this.c != (e | d)) {
            throw new IOException("invalid CARDHOLDER_CERTIFICATE :" + aSN1ApplicationSpecific.getApplicationTag());
        }
    }

    public CVCertificate(ASN1InputStream aSN1InputStream) throws IOException {
        this.a(aSN1InputStream);
    }

    private void a(ASN1InputStream aSN1InputStream) throws IOException {
        ASN1Primitive aSN1Primitive;
        while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
            if (aSN1Primitive instanceof DERApplicationSpecific) {
                this.a((DERApplicationSpecific)aSN1Primitive);
                continue;
            }
            throw new IOException("Invalid Input Stream for creating an Iso7816CertificateStructure");
        }
    }

    private CVCertificate(ASN1ApplicationSpecific aSN1ApplicationSpecific) throws IOException {
        this.a(aSN1ApplicationSpecific);
    }

    public CVCertificate(CertificateBody certificateBody, byte[] byArray) throws IOException {
        this.a = certificateBody;
        this.b = Arrays.clone(byArray);
        this.c |= d;
        this.c |= e;
    }

    public static CVCertificate getInstance(Object object) {
        if (object instanceof CVCertificate) {
            return (CVCertificate)object;
        }
        if (object != null) {
            try {
                return new CVCertificate(DERApplicationSpecific.getInstance(object));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("unable to parse data: " + iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public byte[] getSignature() {
        return Arrays.clone(this.b);
    }

    public CertificateBody getBody() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        try {
            aSN1EncodableVector.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.b)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, aSN1EncodableVector);
    }

    public ASN1ObjectIdentifier getHolderAuthorization() throws IOException {
        CertificateHolderAuthorization certificateHolderAuthorization = this.a.getCertificateHolderAuthorization();
        return certificateHolderAuthorization.getOid();
    }

    public PackedDate getEffectiveDate() throws IOException {
        return this.a.getCertificateEffectiveDate();
    }

    public int getCertificateType() {
        return this.a.getCertificateType();
    }

    public PackedDate getExpirationDate() throws IOException {
        return this.a.getCertificateExpirationDate();
    }

    public int getRole() throws IOException {
        CertificateHolderAuthorization certificateHolderAuthorization = this.a.getCertificateHolderAuthorization();
        return certificateHolderAuthorization.getAccessRights();
    }

    public CertificationAuthorityReference getAuthorityReference() throws IOException {
        return this.a.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getHolderReference() throws IOException {
        return this.a.getCertificateHolderReference();
    }

    public int getHolderAuthorizationRole() throws IOException {
        int n2 = this.a.getCertificateHolderAuthorization().getAccessRights();
        return n2 & 0xC0;
    }

    public Flags getHolderAuthorizationRights() throws IOException {
        return new Flags(this.a.getCertificateHolderAuthorization().getAccessRights() & 0x1F);
    }
}

