/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.dvcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.ess.ESSCertID;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.CertID;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.CertStatus;
import com.aspose.imaging.internal.bouncycastle.asn1.ocsp.OCSPResponse;
import com.aspose.imaging.internal.bouncycastle.asn1.smime.SMIMECapabilities;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;

public class CertEtcToken
extends ASN1Object
implements ASN1Choice {
    public static final int TAG_CERTIFICATE = 0;
    public static final int TAG_ESSCERTID = 1;
    public static final int TAG_PKISTATUS = 2;
    public static final int TAG_ASSERTION = 3;
    public static final int TAG_CRL = 4;
    public static final int TAG_OCSPCERTSTATUS = 5;
    public static final int TAG_OCSPCERTID = 6;
    public static final int TAG_OCSPRESPONSE = 7;
    public static final int TAG_CAPABILITIES = 8;
    private static final boolean[] a = new boolean[]{false, true, false, true, false, true, false, false, true};
    private int b;
    private ASN1Encodable c;
    private Extension d;

    public CertEtcToken(int n2, ASN1Encodable aSN1Encodable) {
        this.b = n2;
        this.c = aSN1Encodable;
    }

    public CertEtcToken(Extension extension) {
        this.b = -1;
        this.d = extension;
    }

    private CertEtcToken(ASN1TaggedObject aSN1TaggedObject) {
        this.b = aSN1TaggedObject.getTagNo();
        switch (this.b) {
            case 0: {
                this.c = Certificate.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 1: {
                this.c = ESSCertID.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 2: {
                this.c = PKIStatusInfo.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 3: {
                this.c = ContentInfo.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 4: {
                this.c = CertificateList.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 5: {
                this.c = CertStatus.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 6: {
                this.c = CertID.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 7: {
                this.c = OCSPResponse.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 8: {
                this.c = SMIMECapabilities.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tag: " + this.b);
            }
        }
    }

    public static CertEtcToken getInstance(Object object) {
        if (object instanceof CertEtcToken) {
            return (CertEtcToken)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new CertEtcToken((ASN1TaggedObject)object);
        }
        if (object != null) {
            return new CertEtcToken(Extension.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.d == null) {
            return new DERTaggedObject(a[this.b], this.b, this.c);
        }
        return this.d.toASN1Primitive();
    }

    public int getTagNo() {
        return this.b;
    }

    public ASN1Encodable getValue() {
        return this.c;
    }

    public Extension getExtension() {
        return this.d;
    }

    public String toString() {
        return "CertEtcToken {\n" + this.c + "}\n";
    }

    public static CertEtcToken[] arrayFromSequence(ASN1Sequence aSN1Sequence) {
        CertEtcToken[] certEtcTokenArray = new CertEtcToken[aSN1Sequence.size()];
        for (int i2 = 0; i2 != certEtcTokenArray.length; ++i2) {
            certEtcTokenArray[i2] = CertEtcToken.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return certEtcTokenArray;
    }
}

