/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CMSAlgorithmProtection
extends ASN1Object {
    public static final int SIGNATURE = 1;
    public static final int MAC = 2;
    private final AlgorithmIdentifier a;
    private final AlgorithmIdentifier b;
    private final AlgorithmIdentifier c;

    public CMSAlgorithmProtection(AlgorithmIdentifier algorithmIdentifier, int n2, AlgorithmIdentifier algorithmIdentifier2) {
        if (algorithmIdentifier == null || algorithmIdentifier2 == null) {
            throw new NullPointerException("AlgorithmIdentifiers cannot be null");
        }
        this.a = algorithmIdentifier;
        if (n2 == 1) {
            this.b = algorithmIdentifier2;
            this.c = null;
        } else if (n2 == 2) {
            this.b = null;
            this.c = algorithmIdentifier2;
        } else {
            throw new IllegalArgumentException("Unknown type: " + n2);
        }
    }

    private CMSAlgorithmProtection(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Sequence wrong size: One of signatureAlgorithm or macAlgorithm must be present");
        }
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1TaggedObject.getTagNo() == 1) {
            this.b = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
            this.c = null;
        } else if (aSN1TaggedObject.getTagNo() == 2) {
            this.b = null;
            this.c = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
        } else {
            throw new IllegalArgumentException("Unknown tag found: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static CMSAlgorithmProtection getInstance(Object object) {
        if (object instanceof CMSAlgorithmProtection) {
            return (CMSAlgorithmProtection)object;
        }
        if (object != null) {
            return new CMSAlgorithmProtection(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.a;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.c;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

