/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.BodyPartID;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.CMCStatus;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.OtherStatusInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.b;

public class CMCStatusInfoV2
extends ASN1Object {
    private final CMCStatus a;
    private final ASN1Sequence b;
    private final DERUTF8String c;
    private final OtherStatusInfo d;

    CMCStatusInfoV2(CMCStatus cMCStatus, ASN1Sequence aSN1Sequence, DERUTF8String dERUTF8String, OtherStatusInfo otherStatusInfo) {
        this.a = cMCStatus;
        this.b = aSN1Sequence;
        this.c = dERUTF8String;
        this.d = otherStatusInfo;
    }

    private CMCStatusInfoV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 2 || aSN1Sequence.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = CMCStatus.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            if (aSN1Sequence.size() == 4) {
                this.c = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                this.d = OtherStatusInfo.getInstance(aSN1Sequence.getObjectAt(3));
            } else if (aSN1Sequence.getObjectAt(2) instanceof DERUTF8String) {
                this.c = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                this.d = null;
            } else {
                this.c = null;
                this.d = OtherStatusInfo.getInstance(aSN1Sequence.getObjectAt(2));
            }
        } else {
            this.c = null;
            this.d = null;
        }
    }

    public CMCStatus getcMCStatus() {
        return this.a;
    }

    public BodyPartID[] getBodyList() {
        return com.aspose.imaging.internal.bouncycastle.asn1.cmc.b.a(this.b);
    }

    public DERUTF8String getStatusString() {
        return this.c;
    }

    public OtherStatusInfo getOtherStatusInfo() {
        return this.d;
    }

    public boolean hasOtherInfo() {
        return this.d != null;
    }

    public static CMCStatusInfoV2 getInstance(Object object) {
        if (object instanceof CMCStatusInfoV2) {
            return (CMCStatusInfoV2)object;
        }
        if (object != null) {
            return new CMCStatusInfoV2(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

