/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERGeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.l;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    protected byte[] time;

    public static ASN1GeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)object;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)ASN1GeneralizedTime.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof ASN1GeneralizedTime) {
            return ASN1GeneralizedTime.getInstance(aSN1Primitive);
        }
        return new ASN1GeneralizedTime(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    public ASN1GeneralizedTime(String string) {
        this.time = Strings.toByteArray(string);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1GeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    ASN1GeneralizedTime(byte[] byArray) {
        this.time = byArray;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.time);
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.substring(0, string.length() - 1) + "GMT+00:00";
        }
        int n2 = string.length() - 5;
        char c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2, n2 + 3) + ":" + string.substring(n2 + 3);
        }
        n2 = string.length() - 3;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2) + ":00";
        }
        return string + this.a();
    }

    private String a() {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset();
        if (n2 < 0) {
            string = "-";
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        int n4 = (n2 - n3 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                n3 += string.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string + this.a(n3) + ":" + this.a(n4);
    }

    private String a(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string;
        String string2 = string = Strings.fromByteArray(this.time);
        if (string.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss'Z'") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm'Z'") : new SimpleDateFormat("yyyyMMddHH'Z'")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string.indexOf(45) > 0 || string.indexOf(43) > 0) {
            string2 = this.getTime();
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmssz") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmmz") : new SimpleDateFormat("yyyyMMddHHz")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm") : new SimpleDateFormat("yyyyMMddHH")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char c2;
            int n2;
            String string3 = string2.substring(14);
            for (n2 = 1; n2 < string3.length() && '0' <= (c2 = string3.charAt(n2)) && c2 <= '9'; ++n2) {
            }
            if (n2 - 1 > 3) {
                string3 = string3.substring(0, 4) + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            } else if (n2 - 1 == 1) {
                string3 = string3.substring(0, n2) + "00" + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            } else if (n2 - 1 == 2) {
                string3 = string3.substring(0, n2) + "0" + string3.substring(n2);
                string2 = string2.substring(0, 14) + string3;
            }
        }
        return simpleDateFormat.parse(string2);
    }

    protected boolean hasFractionalSeconds() {
        for (int i2 = 0; i2 != this.time.length; ++i2) {
            if (this.time[i2] != 46 || i2 != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSeconds() {
        return this.b(12) && this.b(13);
    }

    protected boolean hasMinutes() {
        return this.b(10) && this.b(11);
    }

    private boolean b(int n2) {
        return this.time.length > n2 && this.time[n2] >= 48 && this.time[n2] <= 57;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        int n2 = this.time.length;
        return 1 + l.a(n2) + n2;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(24, this.time);
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.time);
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1GeneralizedTime)aSN1Primitive).time);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

