/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.png;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.coreexceptions.imageformats.PngImageException;
import com.aspose.imaging.imageoptions.PngOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aF.bP;
import com.aspose.imaging.internal.gk.h;
import com.aspose.imaging.internal.lc.Q;
import com.aspose.imaging.internal.lc.aV;
import com.aspose.imaging.internal.lj.a;
import com.aspose.imaging.internal.qg.d;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;

public class PngImage
extends RasterCachedImage
implements com.aspose.imaging.internal.K.a {
    private com.aspose.imaging.internal.ga.a h;

    public PngImage(int n2, int n3) {
        this(n2, n3, 2);
    }

    public PngImage(String string) {
        this(string, 2);
    }

    public PngImage(RasterImage rasterImage) {
        this(rasterImage, 2);
    }

    public PngImage(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        bP bP2 = new bP(string);
        if (com.aspose.imaging.internal.qg.d.b((Object)bP2.a(), PngImage.class)) {
            if (((PngImage)bP2.a()).h.d() == 3) {
                this.a(bP2, bP2.a().getWidth(), bP2.a().getHeight(), 3);
            } else {
                this.a(bP2, bP2.a().getWidth(), bP2.a().getHeight(), n2);
            }
        } else {
            this.a(bP2, bP2.a().getWidth(), bP2.a().getHeight(), n2);
        }
    }

    public PngImage(RasterImage rasterImage, int n2) {
        bP bP2 = new bP(rasterImage);
        this.a(bP2, rasterImage.getWidth(), rasterImage.getHeight(), n2);
    }

    public PngImage(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    private PngImage(Stream stream) {
        bP bP2 = new bP(stream);
        this.a(bP2, bP2.a().getWidth(), bP2.a().getHeight(), 2);
    }

    public PngImage(int n2, int n3, int n4) {
        this.b(n2, n3, n4);
    }

    public PngImage(PngOptions pngOptions, int n2, int n3) {
        this.a(new com.aspose.imaging.internal.ga.a(pngOptions));
        this.h.b(com.aspose.imaging.internal.qg.d.f((Object)n2, 9));
        this.h.a(com.aspose.imaging.internal.qg.d.f((Object)n3, 9));
        this.b(this.h);
    }

    private PngImage(com.aspose.imaging.internal.ga.a a2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        this.b(a2);
    }

    @Override
    public int getBitsPerPixel() {
        int n2 = this.h.c() & 0xFF;
        switch (this.h.d()) {
            case 2: {
                return n2 * 3;
            }
            case 4: {
                return n2 * 2;
            }
            case 6: {
                return n2 * 4;
            }
        }
        return n2;
    }

    @Override
    public int getHeight() {
        return (int)this.h.g();
    }

    @Override
    public double getHorizontalResolution() {
        if (this.h.o()) {
            return this.h.h();
        }
        return super.getHorizontalResolution();
    }

    @Override
    public void setHorizontalResolution(double d2) {
        this.h.a(d2);
        this.h.b(true);
    }

    @Override
    public long getFileFormat() {
        return 16L;
    }

    @Override
    public PixelDataFormat getRawDataFormat() {
        switch (this.h.d()) {
            case 0: {
                return PixelDataFormat.getGrayscale();
            }
            case 2: {
                return PixelDataFormat.getRgb24BppPng();
            }
            case 3: {
                return PixelDataFormat.getRgbIndexed8Bpp();
            }
            case 4: {
                return PixelDataFormat.getGrayscaleAlpha();
            }
            case 6: {
                return PixelDataFormat.getRgba32Bpp();
            }
        }
        throw new ArgumentOutOfRangeException();
    }

    @Override
    public double getVerticalResolution() {
        return this.h.o() ? this.h.m() : super.getVerticalResolution();
    }

    @Override
    public void setVerticalResolution(double d2) {
        this.h.b(d2);
        this.h.b(true);
    }

    @Override
    public int getWidth() {
        return (int)this.h.n();
    }

    @Override
    public boolean hasTransparentColor() {
        return this.h.p();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.h.c(bl2);
    }

    @Override
    public boolean hasAlpha() {
        int n2 = this.h.d();
        IColorPalette iColorPalette = this.h.j();
        return n2 == 6 || n2 == 4 || n2 == 3 && iColorPalette != null && ColorPaletteHelper.hasTransparentColors(iColorPalette);
    }

    @Override
    public Color getTransparentColor() {
        return this.h.l();
    }

    @Override
    public void setTransparentColor(Color color) {
        this.h.b(color.Clone());
    }

    @Override
    public boolean hasBackgroundColor() {
        return this.h.f();
    }

    @Override
    public void setBackgroundColor(boolean bl2) {
        this.h.a(bl2);
    }

    @Override
    public Color getBackgroundColor() {
        return this.h.b();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.h.a(color.Clone());
    }

    public boolean getInterlaced() {
        return this.h.i() == 1;
    }

    @Override
    public final boolean isInterlaced() {
        return this.getInterlaced();
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.h.a();
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.h.a(xmpPacketWrapper);
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        return n2 == 2 || n2 == 1 || super.doUseRecursion(n2);
    }

    public com.aspose.imaging.internal.ga.a q() {
        return this.h;
    }

    public void a(com.aspose.imaging.internal.ga.a a2) {
        this.h = a2;
        this.setPalette(this.h.j());
    }

    @Override
    public IColorPalette o() {
        IColorPalette iColorPalette = super.o();
        if (iColorPalette == null && this.h != null) {
            return this.h.j();
        }
        return iColorPalette;
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2 = super.a(iColorPalette);
        if (!bl2) {
            boolean bl3 = bl2 = this.h.j() != null;
            if (bl2) {
                this.h.a(iColorPalette);
            }
        }
        return bl2;
    }

    @Override
    public Q e(boolean bl2) {
        String string = this.h.s();
        if (!bl2 && !aV.b(string)) {
            return Q.c(string);
        }
        return super.e(bl2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.h.a(iColorPalette2);
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    @Override
    public ImageOptionsBase getDefaultOptions(Object[] objectArray) {
        return new PngOptions();
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        com.aspose.imaging.internal.ga.a a2 = this.h;
        PngOptions pngOptions = new PngOptions();
        pngOptions.setBitDepth(a2.c());
        pngOptions.setColorType(a2.d());
        pngOptions.setXmpData(a2.a());
        pngOptions.setProgressive((a2.i() & 0xFF) == 1);
        pngOptions.setCompressionLevel(a2.k());
        if (a2.o()) {
            pngOptions.setResolutionSettings(new ResolutionSetting(a2.h(), a2.m()));
        }
        if (pngOptions.getColorType() == 3) {
            pngOptions.setPalette(a2.j());
        }
        return pngOptions;
    }

    @Override
    protected void updateMetadata() {
        if (this.getUpdateXmpData()) {
            try {
                String string = "G";
                String string2 = !aV.b(this.h.s()) ? this.h.s() : Q.m().b(string);
                this.h.a(string2);
            }
            catch (RuntimeException runtimeException) {
                com.aspose.imaging.internal.lj.a.d(aV.a(new String[]{"Exception on PngImage.UpdateMetadata: ", runtimeException.toString()}));
            }
        }
        super.updateMetadata();
    }

    public static PngImage a(com.aspose.imaging.internal.ga.a a2, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        return new PngImage(a2, iRasterImageArgb32PixelLoader);
    }

    @Override
    protected void saveData(Stream stream) {
        this.updateMetadata();
        PngOptions pngOptions = new PngOptions();
        pngOptions.setColorType(this.h.d());
        pngOptions.setXmpData(this.h.a());
        pngOptions.setCompressionLevel(this.h.k());
        if (this.h.o()) {
            pngOptions.setResolutionSettings(new ResolutionSetting(this.h.h(), this.h.m()));
        }
        pngOptions.setProgressive(this.h.i() == 1);
        if (pngOptions.getColorType() == 3) {
            pngOptions.setPalette(this.h.j());
        }
        com.aspose.imaging.internal.gk.h.a(stream, this, pngOptions, this.getBounds(), false, this.h.s());
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        com.aspose.imaging.internal.ga.a a2 = this.h;
        a2.a((long)n3 & 0xFFFFFFFFL);
        a2.b((long)n2 & 0xFFFFFFFFL);
    }

    private void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, int n2, int n3, int n4) {
        this.setDataLoader(iRasterImageArgb32PixelLoader);
        if (com.aspose.imaging.internal.qg.d.b((Object)iRasterImageArgb32PixelLoader, com.aspose.imaging.internal.gd.a.class)) {
            this.a(((com.aspose.imaging.internal.gd.a)iRasterImageArgb32PixelLoader).a());
        } else {
            if (n4 == 3) {
                this.a(((PngImage)((bP)iRasterImageArgb32PixelLoader).a()).h);
            }
            this.b(n2, n3, n4);
        }
    }

    private void b(int n2, int n3, int n4) {
        if (n3 <= 0) {
            throw new PngImageException("The height should be positive.");
        }
        if (n2 <= 0) {
            throw new PngImageException("The width should be positive.");
        }
        if (n4 != 3) {
            this.a(new com.aspose.imaging.internal.ga.a());
            this.h.a(n4);
            this.h.a(com.aspose.imaging.internal.qg.d.f((Object)n3, 9));
            this.h.b(com.aspose.imaging.internal.qg.d.f((Object)n2, 9));
            this.h.a((byte)8);
        }
        this.b(this.h);
    }

    private void b(com.aspose.imaging.internal.ga.a a2) {
        this.a(a2);
    }
}

