/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.IPartialArgb32PixelLoader;
import com.aspose.imaging.IPartialRawDataLoader;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifApplicationExtensionBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifPlainTextRenderingBlock;
import com.aspose.imaging.fileformats.gif.c;
import com.aspose.imaging.fileformats.gif.d;
import com.aspose.imaging.fileformats.gif.e;
import com.aspose.imaging.fileformats.gif.f;
import com.aspose.imaging.fileformats.gif.g;
import com.aspose.imaging.fileformats.gif.h;
import com.aspose.imaging.fileformats.gif.i;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.GifOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.aF.bo;
import com.aspose.imaging.internal.aF.cs;
import com.aspose.imaging.internal.fm.o;
import com.aspose.imaging.internal.jw.j;
import com.aspose.imaging.internal.lR.l;
import com.aspose.imaging.internal.lc.aV;
import com.aspose.imaging.internal.lc.au;
import com.aspose.imaging.internal.lc.bC;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.lang.ref.WeakReference;

public final class GifImage
extends RasterCachedMultipageImage
implements IMultipageImageExt,
com.aspose.imaging.internal.K.a {
    private final com.aspose.imaging.internal.eV.b h;
    private final List<IGifBlock> i = new List();
    private GifFrameBlock j;
    private boolean k;
    private static final String l = "XMP Data";
    private static final String m = "XMP";
    private static final int n = 258;
    private Image[] o;
    private GifOptions p;

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette) {
        this(gifFrameBlock, iColorPalette, false, 0, 0, 0, true);
    }

    public GifImage(GifFrameBlock gifFrameBlock) {
        this(gifFrameBlock, null);
    }

    public GifImage(GifFrameBlock gifFrameBlock, IColorPalette iColorPalette, boolean bl2, byte by2, byte by3, byte by4, boolean bl3) {
        byte by5;
        int n2;
        if (gifFrameBlock == null) {
            throw new ArgumentNullException("firstFrame");
        }
        if (gifFrameBlock.getContainer() != null) {
            throw new ArgumentException("The first frame already belongs to some other image. Check the Container property.", "firstFrame");
        }
        IColorPalette iColorPalette2 = gifFrameBlock.getPalette();
        int n3 = 0;
        if (iColorPalette != null) {
            n3 = n2 = iColorPalette.getEntriesCount();
            by5 = com.aspose.imaging.internal.eV.b.a(n2, true, bl2, by2);
        } else if (iColorPalette2 == null) {
            iColorPalette2 = ColorPaletteHelper.create8Bit();
            n2 = iColorPalette2.getEntriesCount();
            by5 = com.aspose.imaging.internal.eV.b.a(n2, true, false, (byte)0);
            n3 = n2;
            iColorPalette = iColorPalette2;
        } else {
            by5 = com.aspose.imaging.internal.eV.b.a(0, false, false, (byte)0);
        }
        com.aspose.imaging.internal.eV.b b2 = new com.aspose.imaging.internal.eV.b(gifFrameBlock.getWidth(), gifFrameBlock.getHeight(), by5, by3, by4);
        if (b2.k() != n3 && n3 > 0) {
            throw new GifImageException("The palette specified must contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        this.h = b2;
        this.i.addItem(gifFrameBlock);
        gifFrameBlock.a(this);
        this.j = gifFrameBlock;
        this.k = bl3;
        this.setPalette(iColorPalette);
        this.setDataLoader(new a(this));
    }

    private GifImage(com.aspose.imaging.internal.eV.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock, int n2, GifOptions gifOptions) {
        this(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock);
        this.setLoopsCount(n2);
        this.p = gifOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GifImage(com.aspose.imaging.internal.eV.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        super(iColorPalette);
        this.h = b2;
        for (IGifBlock iGifBlock : iGifBlockArray) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock;
            Image image = (Image)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, Image.class));
            if (image != null) {
                image.a(this);
            }
            if ((gifApplicationExtensionBlock = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifApplicationExtensionBlock.class))) == null) continue;
            try {
                byte[] byArray;
                int n2;
                byte[] byArray2 = gifApplicationExtensionBlock.getApplicationAuthenticationCode();
                byte[] byArray3 = com.aspose.imaging.internal.lR.l.t().c(m);
                if (!l.equals(gifApplicationExtensionBlock.getApplicationIdentifier()) || byArray2 == null || byArray2.length != m.length() || (byArray2[0] & 0xFFFF) != (byArray3[0] & 0xFFFF) || (byArray2[1] & 0xFFFF) != (byArray3[1] & 0xFFFF) || (byArray2[2] & 0xFFFF) != (byArray3[2] & 0xFFFF) || (n2 = (byArray = gifApplicationExtensionBlock.getApplicationData()).length - 257) <= 0) continue;
                com.aspose.imaging.internal.jv.a a2 = new com.aspose.imaging.internal.jv.a(com.aspose.imaging.internal.lR.l.x());
                MemoryStream memoryStream = new MemoryStream(byArray);
                try {
                    String string = a2.b(memoryStream, n2);
                    j j2 = new j(string);
                    this.xmpData = j2.a();
                }
                finally {
                    memoryStream.dispose();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.i.addRange((IGifBlock[])iGifBlockArray);
        this.k = bl2;
        this.j = gifFrameBlock;
        this.setDataLoader(new a(this));
    }

    @Override
    public long getFileFormat() {
        return 4L;
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    public boolean hasTrailer() {
        return this.k;
    }

    public void setTrailer(boolean bl2) {
        this.k = bl2;
    }

    public boolean isPaletteSorted() {
        return this.h.i();
    }

    public void setPaletteSorted(boolean bl2) {
        this.h.b(bl2);
    }

    public int getLoopsCount() {
        for (IGifBlock iGifBlock : this.r()) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock;
            if (!(iGifBlock instanceof GifApplicationExtensionBlock) || !GifApplicationExtensionBlock.a(gifApplicationExtensionBlock = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifApplicationExtensionBlock.class)))) continue;
            return gifApplicationExtensionBlock.a();
        }
        return 1;
    }

    public void setLoopsCount(int n2) {
        GifApplicationExtensionBlock gifApplicationExtensionBlock = null;
        for (IGifBlock iGifBlock : this.r()) {
            GifApplicationExtensionBlock gifApplicationExtensionBlock2 = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifApplicationExtensionBlock.class));
            if (gifApplicationExtensionBlock2 == null || !GifApplicationExtensionBlock.a(gifApplicationExtensionBlock2)) continue;
            gifApplicationExtensionBlock = gifApplicationExtensionBlock2;
            break;
        }
        if (n2 == 1 && gifApplicationExtensionBlock != null) {
            this.b(gifApplicationExtensionBlock);
        }
        if (n2 < 0) {
            throw new GifImageException("Loops count must be positive");
        }
        if (n2 != 1) {
            if (gifApplicationExtensionBlock == null) {
                GifApplicationExtensionBlock gifApplicationExtensionBlock3 = new GifApplicationExtensionBlock();
                gifApplicationExtensionBlock3.setApplicationIdentifier("NETSCAPE");
                gifApplicationExtensionBlock3.setApplicationAuthenticationCode(com.aspose.imaging.internal.lR.l.t().c("2.0"));
                gifApplicationExtensionBlock3.a(n2);
                this.a(gifApplicationExtensionBlock3);
            } else {
                gifApplicationExtensionBlock.a(n2);
            }
        }
    }

    public byte getPaletteColorResolutionBits() {
        return this.h.j();
    }

    public void setPaletteColorResolutionBits(byte by2) {
        this.h.c(by2);
    }

    @Override
    public int getPageCount() {
        return this.getPages() != null ? this.getPages().length : 0;
    }

    @Override
    public Image[] getPages() {
        if (this.o != null) {
            return this.o;
        }
        List<Image> list = new List<Image>();
        for (IGifBlock iGifBlock : this.getBlocks()) {
            if (!com.aspose.imaging.internal.qg.d.b((Object)iGifBlock, Image.class)) continue;
            list.addItem((Image)((Object)iGifBlock));
        }
        this.o = list.toArray(new Image[0]);
        return this.o;
    }

    @Override
    @Deprecated
    public Image getDefaultPage() {
        return this.j;
    }

    public IGifBlock[] getBlocks() {
        return this.r();
    }

    @Override
    public boolean isInterlaced() {
        if (this.j != null) {
            return this.j.isInterlaced();
        }
        return false;
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        return this.p;
    }

    @Override
    public void addPage(RasterImage rasterImage) {
        if (rasterImage == null) {
            throw new ArgumentNullException("page");
        }
        this.addBlock(new GifGraphicsControlBlock());
        this.addBlock(new GifFrameBlock(rasterImage));
    }

    public GifFrameBlock getActiveFrame() {
        return this.j;
    }

    public void setActiveFrame(GifFrameBlock gifFrameBlock) {
        if (gifFrameBlock != null && (gifFrameBlock.getContainer() == null || gifFrameBlock.getContainer() != this)) {
            throw new GifImageException("The frame does not belong to the current GIF image.");
        }
        this.j = gifFrameBlock;
    }

    @Override
    public Color getBackgroundColor() {
        Color color = Color.getEmpty();
        if (this.getPalette() != null && (this.h.b() & 0xFF) < this.getPalette().getEntriesCount()) {
            this.getPalette().getColor(this.h.b() & 0xFF).CloneTo(color);
        }
        return color;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (this.getPalette() != null) {
            this.h.a((byte)this.getPalette().getNearestColorIndex(color));
        }
    }

    public byte getBackgroundColorIndex() {
        return this.h.b();
    }

    public void setBackgroundColorIndex(byte by2) {
        this.h.a(by2);
    }

    public byte getPixelAspectRatio() {
        return this.h.g();
    }

    public void setPixelAspectRatio(byte by2) {
        this.h.b(by2);
    }

    @Override
    public boolean hasTransparentColor() {
        return this.j.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        this.j.setTransparentColor(bl2);
    }

    @Override
    public Color getTransparentColor() {
        return this.j.getTransparentColor();
    }

    @Override
    public boolean hasBackgroundColor() {
        return Color.op_Inequality(this.getBackgroundColor(), Color.getEmpty());
    }

    @Override
    public float getImageOpacity() {
        if (this.j != null) {
            return this.j.getImageOpacity();
        }
        return super.getImageOpacity();
    }

    @Override
    public PageExportingAction getPageExportingAction() {
        return null;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        throw new NotSupportedException("GifImage does not support batch export mode.");
    }

    public GifOptions q() {
        return this.p;
    }

    public void a(GifOptions gifOptions) {
        this.p = gifOptions;
    }

    @Override
    public boolean f() {
        int n2 = this.getBlocks().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(this.getBlocks()[i2], GifFrameBlock.class));
            if (gifFrameBlock == null || !gifFrameBlock.f()) continue;
            return true;
        }
        return super.f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGifBlock[] r() {
        Object object = this.c;
        synchronized (object) {
            return this.i.toArray((IGifBlock[])new IGifBlock[0]);
        }
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        this.c(n2, n3, n4);
        this.updateDimensions(n2, n3);
    }

    public void resizeFullFrame(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        this.b(n2, n3, n4);
        this.updateDimensions(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateFlip(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(15);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                Size size = this.getSize();
                for (Image image : this.getPages()) {
                    GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(image, GifFrameBlock.class));
                    if (gifFrameBlock == null) continue;
                    gifFrameBlock.a(n2, size.Clone());
                    gifFrameBlock.rotateFlip(n2);
                }
                Image image = this.getDefaultPage();
                this.updateDimensions(image.getWidth(), image.getHeight());
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        super.dither(n2, n3, iColorPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(6);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
                    throw new ArgumentException("Rectangle is invalid.", "rectangle");
                }
                if (!this.getBounds().contains(rectangle)) {
                    throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
                }
                Image[] imageArray = this.getPages();
                boolean bl3 = false;
                if (imageArray.length > 0) {
                    int n2 = rectangle.getLeft() & 0xFFFF;
                    int n3 = rectangle.getTop() & 0xFFFF;
                    for (int i2 = imageArray.length - 1; i2 >= 0; --i2) {
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(imageArray[i2], GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            GifGraphicsControlBlock gifGraphicsControlBlock;
                            Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(gifFrameBlock.getLeft() & 0xFFFF, gifFrameBlock.getTop() & 0xFFFF, gifFrameBlock.getWidth(), gifFrameBlock.getHeight()));
                            if (!rectangle2.isEmpty()) {
                                rectangle2.offset(-(gifFrameBlock.getLeft() & 0xFFFF), -(gifFrameBlock.getTop() & 0xFFFF));
                                gifFrameBlock.crop(rectangle2);
                                if ((gifFrameBlock.getLeft() & 0xFFFF) > (n2 & 0xFFFF)) {
                                    gifFrameBlock.setLeft((gifFrameBlock.getLeft() & 0xFFFF) - (n2 & 0xFFFF) & 0xFFFF);
                                } else {
                                    gifFrameBlock.setLeft(0);
                                }
                                if ((gifFrameBlock.getTop() & 0xFFFF) > (n3 & 0xFFFF)) {
                                    gifFrameBlock.setTop((gifFrameBlock.getTop() & 0xFFFF) - (n3 & 0xFFFF) & 0xFFFF);
                                    continue;
                                }
                                gifFrameBlock.setTop(0);
                                continue;
                            }
                            GifGraphicsControlBlock gifGraphicsControlBlock2 = gifFrameBlock.getControlBlock();
                            int n4 = gifGraphicsControlBlock2 != null ? gifGraphicsControlBlock2.getDelayTime() : 0;
                            this.b(gifFrameBlock);
                            this.b(gifGraphicsControlBlock2);
                            bl3 = true;
                            GifFrameBlock gifFrameBlock2 = null;
                            for (int i3 = i2 - 1; i3 >= 0 && (gifFrameBlock2 = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(imageArray[i3], GifFrameBlock.class))) == null; --i3) {
                            }
                            if (gifFrameBlock2 == null || (gifGraphicsControlBlock = gifFrameBlock2.getControlBlock()) == null) continue;
                            gifGraphicsControlBlock.setDelayTime((gifGraphicsControlBlock.getDelayTime() & 0xFFFF) + (n4 & 0xFFFF) & 0xFFFF);
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aV.a(new String[]{"Can't crop image. Frame index: ", au.b(i2)}), runtimeException);
                        }
                    }
                    if (bl3) {
                        this.o = null;
                    }
                    this.updateDimensions(rectangle.getWidth(), rectangle.getHeight());
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't crop image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void adjustGamma(float f2) {
        super.adjustGamma(f2);
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        super.filter(rectangle, filterOptionsBase);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        super.resize(n2, n3, imageResizeSettings);
    }

    public void setFrameTime(int n2) {
        for (Image image : this.getPages()) {
            ((GifFrameBlock)image).setFrameTime(n2 & 0xFFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int n2) {
        Object object = this.c;
        synchronized (object) {
            super.adjustBrightness(n2);
            try {
                this.b(true);
                this.verifyNotDisposed();
                if (this.getPalette() != null) {
                    int[] nArray = this.getPalette().getArgb32Entries();
                    com.aspose.imaging.internal.fm.o.a(nArray, n2);
                    this.setPalette(new ColorPalette(nArray));
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float f2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.verifyNotDisposed();
                int n2 = 0;
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this.i.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            com.aspose.imaging.internal.jd.a a2 = new com.aspose.imaging.internal.jd.a(gifFrameBlock);
                            try {
                                int[] nArray;
                                boolean bl3 = gifFrameBlock.getPalette() != null;
                                IColorPalette[] iColorPaletteArray = new IColorPalette[]{bl3 ? gifFrameBlock.getPalette() : this.getPalette()};
                                if (bl3) {
                                    nArray = iColorPaletteArray[0].getArgb32Entries();
                                    com.aspose.imaging.internal.fm.o.a(nArray, f2);
                                    gifFrameBlock.setPalette(new ColorPalette(nArray));
                                    a2.a(new com.aspose.imaging.fileformats.gif.b(this, iColorPaletteArray, gifFrameBlock));
                                } else if (!bl2) {
                                    nArray = iColorPaletteArray[0].getArgb32Entries();
                                    com.aspose.imaging.internal.fm.o.a(nArray, f2);
                                    ColorPalette colorPalette = new ColorPalette(nArray);
                                    this.setPalette(colorPalette);
                                    bl2 = true;
                                    a2.a(new c(this, iColorPaletteArray, colorPalette));
                                }
                            }
                            finally {
                                a2.close();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aV.a(new String[]{"Can't change contrast. Frame index: ", au.b(n2)}), runtimeException);
                        }
                        ++n2;
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.verifyNotDisposed();
                int n2 = 0;
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this.i.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        try {
                            com.aspose.imaging.internal.jd.a a2 = new com.aspose.imaging.internal.jd.a(gifFrameBlock);
                            try {
                                ColorPalette colorPalette;
                                int[] nArray;
                                IColorPalette iColorPalette;
                                boolean bl3 = gifFrameBlock.getPalette() != null;
                                IColorPalette iColorPalette2 = iColorPalette = bl3 ? gifFrameBlock.getPalette() : this.getPalette();
                                if (bl3) {
                                    nArray = iColorPalette.getArgb32Entries();
                                    com.aspose.imaging.internal.fm.o.a(nArray, f2, f3, f4);
                                    colorPalette = new ColorPalette(nArray);
                                    gifFrameBlock.setPalette(colorPalette);
                                    a2.a(new d(this, iColorPalette, colorPalette));
                                } else if (!bl2) {
                                    nArray = iColorPalette.getArgb32Entries();
                                    com.aspose.imaging.internal.fm.o.a(nArray, f2, f3, f4);
                                    colorPalette = new ColorPalette(nArray);
                                    this.setPalette(colorPalette);
                                    bl2 = true;
                                    a2.a(new e(this, iColorPalette, colorPalette));
                                }
                            }
                            finally {
                                a2.close();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageException(aV.a(new String[]{"Can't change gamma. Frame index: ", au.b(n2)}), runtimeException);
                        }
                        ++n2;
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grayscale() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.a(new f(this), "Can't make image grayscale.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeFixed(byte by2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.a(new g(this, by2), "Can't make image binarization with predefined threshold.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeOtsu() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.a(new h(this), "Can't make image binarization with Otsu threshold.");
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeBradley(double d2) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                com.aspose.imaging.internal.iB.g g2 = new com.aspose.imaging.internal.iB.g(this, this.getBounds(), d2);
                try {
                    g2.a(new i(this));
                    bo bo2 = bo.a();
                    bo2.a(this, bo2.hashCode() ^ this.hashCode());
                    bo2.a(this, this.getBounds(), g2);
                }
                finally {
                    g2.close();
                }
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderBlocks() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.s();
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlocks() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.t();
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBlock(int n2, IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.a(n2, iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlock(IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.a(iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlock(IGifBlock iGifBlock) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.b(iGifBlock);
            }
            finally {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeProportional(int n2, int n3, int n4) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.C_();
                this.verifyNotDisposed();
                double d2 = (double)n2 / (double)this.getWidth();
                double d3 = (double)n3 / (double)this.getHeight();
                IGenericEnumerator iGenericEnumerator = this.i.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifFrameBlock.class));
                        if (gifFrameBlock == null) continue;
                        int n5 = com.aspose.imaging.internal.qg.d.e(d2 * (double)gifFrameBlock.getWidth() + 0.5);
                        int n6 = com.aspose.imaging.internal.qg.d.e(d3 * (double)gifFrameBlock.getHeight() + 0.5);
                        gifFrameBlock.resize(n5, n6, n4);
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
                this.h.a(n2 & 0xFFFF);
                this.h.b(n3 & 0xFFFF);
            }
            finally {
                this.e();
            }
        }
    }

    public void s() {
        Object object;
        int n2;
        this.verifyNotDisposed();
        com.aspose.imaging.internal.kW.f f2 = new com.aspose.imaging.internal.kW.f();
        for (n2 = 0; n2 < this.i.size(); ++n2) {
            int n3;
            IGifBlock iGifBlock = this.i.get_Item(n2);
            if (!com.aspose.imaging.internal.qg.d.b((Object)iGifBlock, GifGraphicsControlBlock.class)) continue;
            object = new com.aspose.imaging.internal.kW.f();
            for (n3 = n2 + 1; n3 < this.i.size(); ++n3) {
                IGifBlock iGifBlock2 = this.i.get_Item(n3);
                if (com.aspose.imaging.internal.qg.d.b((Object)iGifBlock2, GifGraphicsControlBlock.class)) {
                    ((com.aspose.imaging.internal.kW.f)object).e(n3);
                    continue;
                }
                if (!com.aspose.imaging.internal.qg.d.b((Object)iGifBlock2, GifFrameBlock.class) && !com.aspose.imaging.internal.qg.d.b((Object)iGifBlock2, GifPlainTextRenderingBlock.class)) continue;
                f2.b(((com.aspose.imaging.internal.kW.f)object).f());
                n2 = n3;
                break;
            }
            if (n3 == this.i.size()) break;
        }
        for (n2 = f2.b() - 1; n2 >= 0; --n2) {
            int n4 = f2.k(n2);
            object = (Image)((Object)com.aspose.imaging.internal.qg.d.a(this.i.get_Item(n4), Image.class));
            if (object != null) {
                ((Image)object).a((Image)null);
            }
            this.i.removeAt(n4);
        }
    }

    public void t() {
        this.verifyNotDisposed();
        this.i.clear();
        this.j = null;
    }

    public void a(int n2, IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.i.insertItem(n2, iGifBlock);
        if (image != null) {
            image.a(this);
        }
    }

    private void a(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be added to this GIF image.");
        }
        this.i.addItem(iGifBlock);
        if (image != null) {
            image.a(this);
        }
    }

    private void b(IGifBlock iGifBlock) {
        this.verifyNotDisposed();
        if (iGifBlock == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, Image.class));
        if (image != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.i.removeItem(iGifBlock);
        if (image != null) {
            image.a((Image)null);
        }
        if (this.j == iGifBlock) {
            this.j = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void u() {
        byte[] byArray;
        Object object;
        Object object2;
        List<Object> list = new List<Object>();
        byte[] byArray2 = com.aspose.imaging.internal.lR.l.t().c(m);
        IGenericEnumerator iGenericEnumerator = this.i.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object2 = (IGifBlock)iGenericEnumerator.next();
                object = (GifApplicationExtensionBlock)((Object)com.aspose.imaging.internal.qg.d.a(object2, GifApplicationExtensionBlock.class));
                if (object == null) continue;
                byArray = ((GifApplicationExtensionBlock)object).getApplicationAuthenticationCode();
                if (!l.equals(((GifApplicationExtensionBlock)object).getApplicationIdentifier()) || byArray.length != m.length() || byArray[0] != byArray2[0] || byArray[1] != byArray2[1] || byArray[2] != byArray2[2]) continue;
                list.addItem(object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        object2 = list.iterator();
        try {
            while (object2.hasNext()) {
                object = (IGifBlock)object2.next();
                this.b((IGifBlock)object);
            }
        }
        finally {
            if (com.aspose.imaging.internal.qg.d.a(object2, IDisposable.class) != false) {
                ((IDisposable)object2).dispose();
            }
        }
        if (this.xmpData != null) {
            object = this.xmpData.b();
            byArray = com.aspose.imaging.internal.lR.l.x().c((String)object);
            GifApplicationExtensionBlock gifApplicationExtensionBlock = new GifApplicationExtensionBlock();
            gifApplicationExtensionBlock.setApplicationIdentifier(l);
            gifApplicationExtensionBlock.setApplicationAuthenticationCode(byArray2);
            gifApplicationExtensionBlock.setApplicationData(byArray);
            this.a(gifApplicationExtensionBlock);
        }
    }

    private static void a(int[] nArray, byte by2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = com.aspose.imaging.internal.qg.d.b(0.2126 * (double)(n2 >> 16 & 0xFF) + 0.7152 * (double)(n2 >> 8 & 0xFF) + 0.0722 * (double)(n2 & 0xFF));
            n3 = (n3 & 0xFF) > (by2 & 0xFF) ? -1 : 0;
            nArray[i2] = n2 & 0xFF000000 | (n3 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n3 & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(b b2, String string) {
        if (b2 == null) {
            return;
        }
        this.verifyNotDisposed();
        int n2 = 0;
        boolean bl2 = false;
        IGenericEnumerator iGenericEnumerator = this.i.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(iGifBlock, GifFrameBlock.class));
                if (gifFrameBlock == null || gifFrameBlock.getPalette() == null && bl2) continue;
                try {
                    IColorPalette iColorPalette;
                    int[] nArray;
                    if (gifFrameBlock.getPalette() != null) {
                        nArray = gifFrameBlock.getPalette().getArgb32Entries();
                        iColorPalette = gifFrameBlock.getPalette();
                    } else {
                        nArray = this.getPalette().getArgb32Entries();
                        iColorPalette = this.getPalette();
                    }
                    int[][] nArrayArray = new int[][]{nArray};
                    b2.a(nArrayArray, iColorPalette);
                    nArray = nArrayArray[0];
                    if (gifFrameBlock.getPalette() != null) {
                        gifFrameBlock.setPalette(new ColorPalette(nArray));
                    } else {
                        this.setPalette(new ColorPalette(nArray));
                        bl2 = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException(aV.a(new String[]{string, " Frame index: ", au.b(n2)}), runtimeException);
                }
                ++n2;
            }
        }
        finally {
            if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private void b(int n2, int n3, int n4) {
        int n5;
        Object object;
        Image[] imageArray;
        List<GifFrameBlock> list = new List<GifFrameBlock>();
        for (Image object2 : imageArray = this.getPages()) {
            object = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(object2, GifFrameBlock.class));
            if (object == null) continue;
            list.addItem((GifFrameBlock)object);
        }
        for (n5 = list.size() - 1; n5 >= 0; --n5) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)list.get_Item(n5);
            gifFrameBlock.b(n2, n3, n4);
            gifFrameBlock.setLeft(0);
            gifFrameBlock.setTop(0);
        }
        for (n5 = list.size() - 1; n5 > 0; --n5) {
            GifFrameBlock gifFrameBlock = (GifFrameBlock)list.get_Item(n5);
            RasterImage rasterImage = ((GifFrameBlock)list.get_Item(n5 - 1)).getFullFrame();
            int[] nArray = gifFrameBlock.loadArgb32Pixels(gifFrameBlock.getBounds());
            object = rasterImage.loadArgb32Pixels(rasterImage.getBounds());
            int n6 = gifFrameBlock.getHeight();
            int n7 = gifFrameBlock.getWidth();
            Rectangle rectangle = GifImage.a(n6, n7, nArray, (int[])object);
            gifFrameBlock.setLeft(rectangle.getLeft() & 0xFFFF);
            gifFrameBlock.setTop(rectangle.getTop() & 0xFFFF);
            gifFrameBlock.crop(rectangle);
        }
    }

    private void c(int n2, int n3, int n4) {
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        for (int i2 = 0; i2 < this.getPages().length; ++i2) {
            Image image = this.getPages()[i2];
            GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.qg.d.a(image, GifFrameBlock.class));
            if (gifFrameBlock == null) continue;
            gifFrameBlock.resize(com.aspose.imaging.internal.qg.d.e(bC.d((double)gifFrameBlock.getWidth() * d2)), com.aspose.imaging.internal.qg.d.e(bC.d((double)gifFrameBlock.getHeight() * d3)), n4);
            gifFrameBlock.setLeft(com.aspose.imaging.internal.qg.d.d(bC.d((double)(gifFrameBlock.getLeft() & 0xFFFF) * d2)));
            gifFrameBlock.setTop(com.aspose.imaging.internal.qg.d.d(bC.d((double)(gifFrameBlock.getTop() & 0xFFFF) * d3)));
        }
    }

    private static Rectangle a(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4;
        int n5;
        int n6;
        int n7 = n2;
        int n8 = n3;
        int n9 = 0;
        int n10 = 0;
        block0: for (n6 = 0; n6 < n2; ++n6) {
            for (n5 = 0; n5 < n8; ++n5) {
                n4 = n6 * n3 + n5;
                if (nArray[n4] == nArray2[n4]) continue;
                n8 = bC.d(n8, n5);
                break;
            }
            for (n5 = n3 - 1; n5 >= n10; --n5) {
                n4 = n6 * n3 + n5;
                if (nArray[n4] == nArray2[n4]) continue;
                n10 = bC.b(n10, n5);
                continue block0;
            }
        }
        block3: for (n6 = 0; n6 < n3; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = n5 * n3 + n6;
                if (nArray[n4] == nArray2[n4]) continue;
                n7 = bC.d(n7, n5);
                break;
            }
            for (n5 = n2 - 1; n5 >= n9; --n5) {
                n4 = n5 * n3 + n6;
                if (nArray[n4] == nArray2[n4]) continue;
                n9 = bC.b(n9, n5);
                continue block3;
            }
        }
        n6 = n10 < n3 ? n10 - n8 + 1 : n10 - n8;
        n5 = n9 < n2 ? n9 - n7 + 1 : n9 - n7;
        return new Rectangle(n8, n7, n6, n5);
    }

    @Override
    protected boolean doUseRecursion(int n2) {
        if (n2 == 2 || n2 == 1 || n2 == 13) {
            return true;
        }
        return super.doUseRecursion(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        this.updateMetadata();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            try {
                this.h.a(streamContainer);
                if (this.getPalette() != null) {
                    com.aspose.imaging.internal.eV.c.a(streamContainer, this.getPalette());
                }
                this.u();
                IGenericEnumerator iGenericEnumerator = this.i.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        IGifBlock iGifBlock = (IGifBlock)iGenericEnumerator.next();
                        iGifBlock.a(streamContainer.a());
                    }
                }
                finally {
                    if (com.aspose.imaging.internal.qg.d.a(iGenericEnumerator, IDisposable.class) != false) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
                if (this.k) {
                    streamContainer.writeByte((byte)59);
                }
                streamContainer.setLength(streamContainer.getPosition());
            }
            finally {
                cs.a(streamContainer);
            }
        }
        finally {
            streamContainer.close();
        }
    }

    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        super.rotate(f2, bl2, color);
        this.updateDimensions(this.j.getWidth(), this.j.getHeight());
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.h.a(n2 & 0xFFFF);
        this.h.b(n3 & 0xFFFF);
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (iColorPalette2 != null && iColorPalette2.getEntriesCount() != 2 && iColorPalette2.getEntriesCount() != 4 && iColorPalette2.getEntriesCount() != 8 && iColorPalette2.getEntriesCount() != 16 && iColorPalette2.getEntriesCount() != 32 && iColorPalette2.getEntriesCount() != 64 && iColorPalette2.getEntriesCount() != 128 && iColorPalette2.getEntriesCount() != 256) {
            throw new GifImageException("The color palette cannot be changed as palette specified should contain entries count equal to power of 2. Minimal palette size is 2, maximal is 256.");
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.h.a(iColorPalette2);
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    @Override
    protected void releaseManagedResources() {
        super.releaseManagedResources();
        this.i.clear();
        this.o = null;
        this.p = null;
        this.j = null;
        this.xmpData = null;
    }

    public static GifImage a(com.aspose.imaging.internal.eV.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock) {
        return new GifImage(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock);
    }

    public static GifImage a(com.aspose.imaging.internal.eV.b b2, IGifBlock[] iGifBlockArray, IColorPalette iColorPalette, boolean bl2, GifFrameBlock gifFrameBlock, int n2, GifOptions gifOptions) {
        return new GifImage(b2, iGifBlockArray, iColorPalette, bl2, gifFrameBlock, n2, gifOptions);
    }

    private static void a(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        int[] nArray2 = iColorPalette2.getArgb32Entries();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = nArray2[iColorPalette.getNearestColorIndex(nArray[i2])];
        }
    }

    static /* synthetic */ void access$000(IColorPalette iColorPalette, IColorPalette iColorPalette2, int[] nArray) {
        GifImage.a(iColorPalette, iColorPalette2, nArray);
    }

    static /* synthetic */ void access$100(int[] nArray, byte by2) {
        GifImage.a(nArray, by2);
    }

    static /* synthetic */ void access$200(GifImage gifImage, b b2, String string) {
        gifImage.a(b2, string);
    }

    private static class a
    implements IRasterImageArgb32PixelLoader {
        private final WeakReference<GifImage> a;

        public a(GifImage gifImage) {
            this.a = new WeakReference<GifImage>(gifImage);
        }

        @Override
        public final boolean isRawDataAvailable() {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                return gifImage.j.isRawDataAvailable();
            }
            return false;
        }

        @Override
        public final RawDataSettings getRawDataSettings() {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                return gifImage.j.getRawDataSettings();
            }
            return null;
        }

        @Override
        public final void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage == null || gifImage.j == null) {
                throw new GifImageException("Cannot load pixels as no active GIF frame exists. Select an active frame first.");
            }
            gifImage.j.loadPartialArgb32Pixels(rectangle, iPartialArgb32PixelLoader);
        }

        @Override
        public final void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            GifImage gifImage = (GifImage)this.a.get();
            if (gifImage != null) {
                gifImage.j.loadRawData(rectangle, rawDataSettings, iPartialRawDataLoader);
            }
        }
    }

    static interface b {
        public void a(int[][] var1, IColorPalette var2);
    }
}

