/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.A;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.aF.cr;
import com.aspose.imaging.internal.aF.cs;
import com.aspose.imaging.internal.iG.f;
import com.aspose.imaging.internal.lc.aV;
import com.aspose.imaging.internal.lc.au;
import com.aspose.imaging.internal.lc.bC;
import com.aspose.imaging.internal.lr.k;
import com.aspose.imaging.internal.pu.d;
import com.aspose.imaging.internal.qf.c;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.x;
import com.aspose.imaging.y;
import com.aspose.imaging.z;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamContainer
extends DisposableObject
implements f {
    public static final int READ_WRITE_BYTES_COUNT = 8192;
    protected final long startPosition;
    private final Stream a;
    private boolean b;
    private final Object c;
    private final boolean d;

    public StreamContainer(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    public StreamContainer(Stream stream) {
        this(stream, false);
    }

    public StreamContainer(InputStream inputStream, boolean bl2) {
        this(Stream.fromJava(inputStream), bl2, false);
    }

    public StreamContainer(Stream stream, boolean bl2) {
        this(stream, bl2, false);
    }

    StreamContainer(Stream stream, boolean bl2, boolean bl3) {
        Stream stream2;
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.b = bl2;
        this.startPosition = stream.getPosition();
        this.a = stream2 = stream instanceof f ? stream : cs.a().a(stream, bl3, bl2);
        this.d = stream2 != stream;
        this.c = cr.a(stream2, stream);
    }

    StreamContainer(Stream stream, long l2, boolean bl2) {
        this(stream, l2, bl2, false);
    }

    public static StreamContainer a(Stream stream, long l2, boolean bl2) {
        return new StreamContainer(stream, l2, bl2);
    }

    StreamContainer(Stream stream, long l2, boolean bl2, boolean bl3) {
        Stream stream2;
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        if (l2 < 0L || l2 != 0L && l2 >= stream.getLength()) {
            throw new ArgumentOutOfRangeException("startPosition");
        }
        this.b = bl2;
        this.startPosition = l2;
        this.a = stream2 = stream instanceof f ? stream : cs.a().a(stream, bl3, bl2);
        this.d = stream2 != stream;
        this.c = cr.a(stream2, stream);
    }

    public static Stream to_Stream(StreamContainer streamContainer) {
        Stream stream = null;
        if (streamContainer != null) {
            stream = streamContainer.a;
        }
        return stream;
    }

    @Override
    public Object getSyncRoot() {
        this.verifyNotDisposed();
        return cr.a(this.a(), this.c);
    }

    public long getPosition() {
        this.verifyNotDisposed();
        return this.a.getPosition() - this.startPosition;
    }

    public void setPosition(long l2) {
        this.verifyNotDisposed();
        this.a.setPosition(l2 + this.startPosition);
    }

    public InputStream getStream() {
        return Stream.toJava(this.a());
    }

    public Stream a() {
        this.verifyNotDisposed();
        return this.a;
    }

    public static StreamContainer a(StreamContainer streamContainer) {
        if (streamContainer == null) {
            return null;
        }
        boolean bl2 = streamContainer.b;
        streamContainer.b = false;
        return new StreamContainer(streamContainer.a, bl2);
    }

    public boolean isStreamDisposedOnClose() {
        this.verifyNotDisposed();
        return this.b;
    }

    public long getLength() {
        this.verifyNotDisposed();
        return this.a.getLength() - this.startPosition;
    }

    public void setLength(long l2) {
        this.verifyNotDisposed();
        this.a.setLength(l2 + this.startPosition);
    }

    public boolean canRead() {
        this.verifyNotDisposed();
        return this.a.canRead();
    }

    public boolean canSeek() {
        this.verifyNotDisposed();
        return this.a.canSeek();
    }

    public boolean canWrite() {
        this.verifyNotDisposed();
        return this.a.canWrite();
    }

    public void flush() {
        this.verifyNotDisposed();
        this.a.flush();
    }

    public void write(byte[] byArray) {
        this.verifyNotDisposed();
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        this.a.write(byArray, 0, byArray.length);
    }

    public void writeByte(byte by2) {
        this.verifyNotDisposed();
        this.a.writeByte(by2);
    }

    public int read(byte[] byArray) {
        this.verifyNotDisposed();
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        return this.a.read(byArray, 0, byArray.length);
    }

    public byte[] toBytes() {
        this.verifyNotDisposed();
        return this.toBytes(0L, this.getLength());
    }

    public byte[] toBytes(long l2, long l3) {
        this.verifyNotDisposed();
        if (l2 >= this.getLength() || l2 < 0L) {
            throw new ArgumentOutOfRangeException("position", "The starting position is out of stream bounds.");
        }
        if (l3 > this.getLength()) {
            throw new ArgumentOutOfRangeException("bytesCount", "The stream does not contain so many bytes.");
        }
        if (l3 + l2 > this.getLength() && l3 > 0L) {
            throw new ArgumentException("Reading so many bytes will cause passing the stream end.");
        }
        if (this.a.canSeek()) {
            this.setPosition(l2);
        } else if (this.getPosition() != l2) {
            throw new FrameworkException("Cannot seek to the desired position. The stream does not support seeking.");
        }
        byte[] byArray = new byte[(int)l3];
        int n2 = 0;
        byte[] byArray2 = new byte[8192];
        while (l3 > 0L) {
            int n3 = (int)bC.d((long)byArray2.length, l3);
            if (this.a.read(byArray2, 0, n3) != n3) {
                throw new FrameworkException(aV.a(new String[]{"Copy operation cannot complete. Cannot read ", au.b(n3), " bytes."}));
            }
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            l3 -= (long)n3;
        }
        return byArray;
    }

    public int read(byte[] byArray, int n2, int n3) {
        this.verifyNotDisposed();
        return this.a.read(byArray, n2, n3);
    }

    public int readByte() {
        this.verifyNotDisposed();
        return this.a.readByte();
    }

    public long seek(long l2, int n2) {
        this.verifyNotDisposed();
        switch (n2) {
            case 0: {
                this.a.seek(l2 + this.startPosition, 0);
                break;
            }
            case 1: {
                this.a.seek(l2, 1);
                break;
            }
            case 2: {
                this.a.seek(l2, 2);
            }
        }
        return this.getPosition();
    }

    public void seekBegin() {
        this.verifyNotDisposed();
        this.a.seek(this.startPosition, 0);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.verifyNotDisposed();
        this.a.write(byArray, n2, n3);
    }

    public void save(OutputStream outputStream) {
        if (outputStream instanceof d) {
            this.saveInternal(((d)outputStream).a());
        } else {
            com.aspose.imaging.internal.qf.c.a(new x(this, outputStream));
        }
    }

    void saveInternal(Stream stream) {
        this.saveInternal(stream, 8192, this.getLength());
    }

    public void save(OutputStream outputStream, int n2) {
        if (outputStream instanceof d) {
            this.saveInternal(((d)outputStream).a(), n2);
        } else {
            com.aspose.imaging.internal.qf.c.a(new y(this, outputStream, n2));
        }
    }

    void saveInternal(Stream stream, int n2) {
        this.saveInternal(stream, n2, this.getLength());
    }

    public void save(OutputStream outputStream, int n2, long l2) {
        if (outputStream instanceof d) {
            this.saveInternal(((d)outputStream).a(), n2, l2);
        } else {
            com.aspose.imaging.internal.qf.c.a(new z(this, outputStream, n2, l2));
        }
    }

    void saveInternal(Stream stream, int n2, long l2) {
        int n3;
        this.verifyNotDisposed();
        if (stream == null) {
            throw new ArgumentNullException("destinationStream");
        }
        if (stream == this.a) {
            throw new FrameworkException("Saving to the same stream is not allowed.");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "The buffer must be positive.");
        }
        this.beforeSave(stream.toOutputStream());
        byte[] byArray = new byte[(int)bC.d((long)n2, l2)];
        while (l2 > 0L && (n3 = this.a.read(byArray, 0, (int)bC.d((long)byArray.length, l2))) > 0) {
            stream.write(byArray, 0, n3);
            l2 -= (long)n3;
        }
    }

    public void save(String string) {
        this.save(string, 8192, this.getLength());
    }

    public void save(String string, int n2) {
        this.save(string, n2, this.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, int n2, long l2) {
        this.verifyNotDisposed();
        if (string == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a.setPosition(0L);
        FileStream fileStream = k.b(string);
        try {
            this.saveInternal(fileStream, n2, l2);
        }
        finally {
            fileStream.dispose();
        }
    }

    public void writeTo(StreamContainer streamContainer) {
        long l2 = this.getLength() - this.getPosition();
        this.writeTo(streamContainer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(StreamContainer streamContainer, long l2) {
        MemoryStream memoryStream = new MemoryStream(this.toBytes());
        try {
            byte[] byArray = new byte[8192];
            while (l2 > 0L) {
                int n2 = (int)bC.d((long)byArray.length, l2);
                if (((Stream)memoryStream).read(byArray, 0, n2) != n2) {
                    throw new FrameworkException(aV.a(new String[]{"Copy operation cannot complete. Cannot read ", au.b(n2), " bytes."}));
                }
                l2 -= (long)n2;
                streamContainer.write(byArray, 0, n2);
            }
        }
        finally {
            memoryStream.dispose();
        }
    }

    protected void afterStreamDisposed() {
    }

    protected void beforeStreamDisposed() {
    }

    void beforeSaveInternal(Stream stream) {
    }

    protected void beforeSave(OutputStream outputStream) {
        if (outputStream instanceof d) {
            this.beforeSaveInternal(((d)outputStream).a());
        } else {
            com.aspose.imaging.internal.qf.c.a(new A(this, outputStream));
        }
    }

    @Override
    protected void releaseManagedResources() {
        try {
            this.disposeStream();
        }
        finally {
            super.releaseManagedResources();
        }
    }

    protected void disposeStream() {
        if (this.b) {
            this.beforeStreamDisposed();
            try {
                cr cr2 = (cr)((Object)com.aspose.imaging.internal.qg.d.a(this.a, cr.class));
                if (cr2 != null && cr2.c()) {
                    return;
                }
                this.a.dispose();
            }
            finally {
                this.afterStreamDisposed();
            }
        } else if (this.d) {
            cr[] crArray = new cr[]{null};
            boolean bl2 = cr.a(this, crArray);
            cr cr3 = crArray[0];
            if (bl2) {
                cs.a().a(cr3);
            }
        }
    }
}

