/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.shapes;

import com.aspose.imaging.Matrix;
import com.aspose.imaging.Pen;
import com.aspose.imaging.PointF;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Shape;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.at.aV;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public abstract class RectangleProjectedShape
extends Shape {
    private final PointF a = new PointF();
    private PointF b = new PointF();
    private PointF c = new PointF();
    private PointF d = new PointF();

    public RectangleProjectedShape() {
    }

    public RectangleProjectedShape(RectangleF rectangleF) {
        rectangleF.getLocation().CloneTo(this.a);
        this.b = new PointF(rectangleF.getRight(), rectangleF.getTop());
        this.d = new PointF(rectangleF.getRight(), rectangleF.getBottom());
        this.c = new PointF(rectangleF.getLeft(), rectangleF.getBottom());
    }

    public PointF getLeftTop() {
        return this.a;
    }

    public PointF getRightTop() {
        return this.b;
    }

    public PointF getLeftBottom() {
        return this.c;
    }

    public PointF getRightBottom() {
        return this.d;
    }

    @Override
    public PointF getCenter() {
        return aV.a(new PointF[]{this.a, this.b, this.c, this.d});
    }

    @Override
    public RectangleF getBounds() {
        return aV.b(new PointF[]{this.a, this.b, this.c, this.d});
    }

    public double getRectangleWidth() {
        return aV.a(this.a.Clone(), this.b.Clone());
    }

    public double getRectangleHeight() {
        return aV.a(this.a.Clone(), this.c.Clone());
    }

    @Override
    public boolean hasSegments() {
        return aV.a(this.a.Clone(), this.b.Clone()) > 0.0 && aV.a(this.a.Clone(), this.c.Clone()) > 0.0;
    }

    @Override
    public RectangleF getBounds(Matrix matrix) {
        return aV.a(new PointF[]{this.a, this.b, this.c, this.d}, matrix);
    }

    @Override
    public RectangleF getBounds(Matrix matrix, Pen pen) {
        throw new NotImplementedException();
    }

    @Override
    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("transform");
        }
        PointF[] pointFArray = new PointF[]{this.a, this.b, this.c, this.d};
        matrix.transformPoints(pointFArray);
        pointFArray[0].CloneTo(this.a);
        pointFArray[1].CloneTo(this.b);
        pointFArray[2].CloneTo(this.c);
        pointFArray[3].CloneTo(this.d);
    }
}

