/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.shapes;

import com.aspose.imaging.Matrix;
import com.aspose.imaging.Pen;
import com.aspose.imaging.PointF;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.ShapeSegment;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.shapes.PolygonShape;
import com.aspose.imaging.shapesegments.BezierSegment;
import com.aspose.imaging.shapesegments.LineSegment;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public final class BezierShape
extends PolygonShape {
    public BezierShape() {
    }

    public BezierShape(PointF[] pointFArray) {
        super(pointFArray);
    }

    public BezierShape(PointF[] pointFArray, boolean bl2) {
        super(pointFArray, bl2);
    }

    @Override
    public RectangleF getBounds() {
        throw new NotImplementedException();
    }

    @Override
    public PointF getCenter() {
        throw new NotImplementedException();
    }

    @Override
    public ShapeSegment[] getSegments() {
        ShapeSegment[] shapeSegmentArray;
        PointF[] pointFArray = this.getPoints();
        if (pointFArray.length > 3) {
            int n2 = (pointFArray.length - 1) / 3;
            int n3 = n2 * 3;
            if (this.isClosed() && PointF.op_Inequality(pointFArray[n3], pointFArray[0])) {
                shapeSegmentArray = new ShapeSegment[n2 + 1];
                shapeSegmentArray[n2] = new LineSegment(pointFArray[n3].Clone(), pointFArray[0].Clone());
            } else {
                shapeSegmentArray = new ShapeSegment[n2];
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                shapeSegmentArray[i2] = new BezierSegment(pointFArray[i2 * 3].Clone(), pointFArray[i2 * 3 + 1].Clone(), pointFArray[i2 * 3 + 2].Clone(), pointFArray[i2 * 3 + 3].Clone());
            }
        } else {
            shapeSegmentArray = new ShapeSegment[]{};
        }
        return shapeSegmentArray;
    }

    @Override
    public boolean hasSegments() {
        return this.getPoints().length > 3;
    }

    @Override
    public PointF getEndPoint() {
        PointF[] pointFArray = this.getPoints();
        if (pointFArray.length > 0) {
            int n2 = (pointFArray.length - 1) / 3 * 3;
            return pointFArray[n2];
        }
        return PointF.getEmpty();
    }

    @Override
    public RectangleF getBounds(Matrix matrix) {
        throw new NotImplementedException();
    }

    @Override
    public RectangleF getBounds(Matrix matrix, Pen pen) {
        throw new NotImplementedException();
    }
}

