/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Extensions;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Selector;
import com.aspose.imaging.internal.bouncycastle.x509.X509AttributeCertificate;
import com.aspose.imaging.internal.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;

public class X509CRLStoreSelector
extends X509CRLSelector
implements Selector {
    private boolean a = false;
    private boolean b = false;
    private BigInteger c = null;
    private byte[] d = null;
    private boolean e = false;
    private X509AttributeCertificate f;

    public boolean isIssuingDistributionPointEnabled() {
        return this.e;
    }

    public void setIssuingDistributionPointEnabled(boolean bl2) {
        this.e = bl2;
    }

    public void setAttrCertificateChecking(X509AttributeCertificate x509AttributeCertificate) {
        this.f = x509AttributeCertificate;
    }

    public X509AttributeCertificate getAttrCertificateChecking() {
        return this.f;
    }

    public boolean match(Object object) {
        byte[] byArray;
        if (!(object instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)object;
        ASN1Integer aSN1Integer = null;
        try {
            byArray = x509CRL.getExtensionValue(X509Extensions.DeltaCRLIndicator.getId());
            if (byArray != null) {
                aSN1Integer = ASN1Integer.getInstance(X509ExtensionUtil.fromExtensionValue(byArray));
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (this.isDeltaCRLIndicatorEnabled() && aSN1Integer == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && aSN1Integer != null) {
            return false;
        }
        if (aSN1Integer != null && this.c != null && aSN1Integer.getPositiveValue().compareTo(this.c) == 1) {
            return false;
        }
        if (this.e) {
            byArray = x509CRL.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
            if (this.d == null ? byArray != null : !Arrays.areEqual(byArray, this.d)) {
                return false;
            }
        }
        return super.match((X509CRL)object);
    }

    @Override
    public boolean match(CRL cRL) {
        return this.match((Object)cRL);
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.a;
    }

    public void setDeltaCRLIndicatorEnabled(boolean bl2) {
        this.a = bl2;
    }

    public static X509CRLStoreSelector getInstance(X509CRLSelector x509CRLSelector) {
        if (x509CRLSelector == null) {
            throw new IllegalArgumentException("cannot create from null selector");
        }
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        x509CRLStoreSelector.setCertificateChecking(x509CRLSelector.getCertificateChecking());
        x509CRLStoreSelector.setDateAndTime(x509CRLSelector.getDateAndTime());
        try {
            x509CRLStoreSelector.setIssuerNames(x509CRLSelector.getIssuerNames());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        x509CRLStoreSelector.setIssuers(x509CRLSelector.getIssuers());
        x509CRLStoreSelector.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
        x509CRLStoreSelector.setMinCRLNumber(x509CRLSelector.getMinCRL());
        return x509CRLStoreSelector;
    }

    @Override
    public Object clone() {
        X509CRLStoreSelector x509CRLStoreSelector = X509CRLStoreSelector.getInstance(this);
        x509CRLStoreSelector.a = this.a;
        x509CRLStoreSelector.b = this.b;
        x509CRLStoreSelector.c = this.c;
        x509CRLStoreSelector.f = this.f;
        x509CRLStoreSelector.e = this.e;
        x509CRLStoreSelector.d = Arrays.clone(this.d);
        return x509CRLStoreSelector;
    }

    public boolean isCompleteCRLEnabled() {
        return this.b;
    }

    public void setCompleteCRLEnabled(boolean bl2) {
        this.b = bl2;
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.c;
    }

    public void setMaxBaseCRLNumber(BigInteger bigInteger) {
        this.c = bigInteger;
    }

    public byte[] getIssuingDistributionPoint() {
        return Arrays.clone(this.d);
    }

    public void setIssuingDistributionPoint(byte[] byArray) {
        this.d = Arrays.clone(byArray);
    }
}

