/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.tsp.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.Evidence;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.TimeStampedData;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.imaging.internal.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.aspose.imaging.internal.bouncycastle.tsp.cms.b;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class CMSTimeStampedData {
    private TimeStampedData a;
    private ContentInfo b;
    private b c;

    public CMSTimeStampedData(ContentInfo contentInfo) {
        this.a(contentInfo);
    }

    public CMSTimeStampedData(InputStream inputStream) throws IOException {
        try {
            this.a(ContentInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Malformed content: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Malformed content: " + illegalArgumentException);
        }
    }

    public CMSTimeStampedData(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    private void a(ContentInfo contentInfo) {
        this.b = contentInfo;
        if (!CMSObjectIdentifiers.timestampedData.equals(contentInfo.getContentType())) {
            throw new IllegalArgumentException("Malformed content - type must be " + CMSObjectIdentifiers.timestampedData.getId());
        }
        this.a = TimeStampedData.getInstance(contentInfo.getContent());
        this.c = new b(this.a);
    }

    public byte[] calculateNextHash(DigestCalculator digestCalculator) throws CMSException {
        return this.c.b(digestCalculator);
    }

    public CMSTimeStampedData addTimeStamp(TimeStampToken timeStampToken) throws CMSException {
        TimeStampAndCRL[] timeStampAndCRLArray = this.c.b();
        TimeStampAndCRL[] timeStampAndCRLArray2 = new TimeStampAndCRL[timeStampAndCRLArray.length + 1];
        System.arraycopy(timeStampAndCRLArray, 0, timeStampAndCRLArray2, 0, timeStampAndCRLArray.length);
        timeStampAndCRLArray2[timeStampAndCRLArray.length] = new TimeStampAndCRL(timeStampToken.toCMSSignedData().toASN1Structure());
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(this.a.getDataUri(), this.a.getMetaData(), this.a.getContent(), new Evidence(new TimeStampTokenEvidence(timeStampAndCRLArray2)))));
    }

    public byte[] getContent() {
        if (this.a.getContent() != null) {
            return this.a.getContent().getOctets();
        }
        return null;
    }

    public URI getDataUri() throws URISyntaxException {
        DERIA5String dERIA5String = this.a.getDataUri();
        if (dERIA5String != null) {
            return new URI(dERIA5String.getString());
        }
        return null;
    }

    public String getFileName() {
        return this.c.c();
    }

    public String getMediaType() {
        return this.c.d();
    }

    public AttributeTable getOtherMetaData() {
        return this.c.e();
    }

    public TimeStampToken[] getTimeStampTokens() throws CMSException {
        return this.c.a();
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator digestCalculator) throws CMSException {
        this.c.a(digestCalculator);
    }

    public DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider digestCalculatorProvider) throws OperatorCreationException {
        return this.c.a(digestCalculatorProvider);
    }

    public void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws ImprintDigestInvalidException, CMSException {
        this.c.a(digestCalculatorProvider, byArray);
    }

    public void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        this.c.a(digestCalculatorProvider, byArray, timeStampToken);
    }

    public byte[] getEncoded() throws IOException {
        return this.b.getEncoded();
    }
}

