/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra;

import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import com.aspose.imaging.internal.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class GF2mField {
    private int a = 0;
    private int b;

    public GF2mField(int n2) {
        if (n2 >= 32) {
            throw new IllegalArgumentException(" Error: the degree of field is too large ");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        this.a = n2;
        this.b = PolynomialRingGF2.getIrreduciblePolynomial(n2);
    }

    public GF2mField(int n2, int n3) {
        if (n2 != PolynomialRingGF2.degree(n3)) {
            throw new IllegalArgumentException(" Error: the degree is not correct");
        }
        if (!PolynomialRingGF2.isIrreducible(n3)) {
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        this.a = n2;
        this.b = n3;
    }

    public GF2mField(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.b = LittleEndianConversions.OS2IP(byArray);
        if (!PolynomialRingGF2.isIrreducible(this.b)) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.a = PolynomialRingGF2.degree(this.b);
    }

    public GF2mField(GF2mField gF2mField) {
        this.a = gF2mField.a;
        this.b = gF2mField.b;
    }

    public int getDegree() {
        return this.a;
    }

    public int getPolynomial() {
        return this.b;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.b);
    }

    public int add(int n2, int n3) {
        return n2 ^ n3;
    }

    public int mult(int n2, int n3) {
        return PolynomialRingGF2.modMultiply(n2, n3, this.b);
    }

    public int exp(int n2, int n3) {
        if (n3 == 0) {
            return 1;
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        int n4 = 1;
        if (n3 < 0) {
            n2 = this.inverse(n2);
            n3 = -n3;
        }
        while (n3 != 0) {
            if ((n3 & 1) == 1) {
                n4 = this.mult(n4, n2);
            }
            n2 = this.mult(n2, n2);
            n3 >>>= 1;
        }
        return n4;
    }

    public int inverse(int n2) {
        int n3 = (1 << this.a) - 2;
        return this.exp(n2, n3);
    }

    public int sqRoot(int n2) {
        for (int i2 = 1; i2 < this.a; ++i2) {
            n2 = this.mult(n2, n2);
        }
        return n2;
    }

    public int getRandomElement(SecureRandom secureRandom) {
        int n2 = RandUtils.nextInt(secureRandom, 1 << this.a);
        return n2;
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(new SecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom secureRandom) {
        int n2;
        int n3 = 0x100000;
        int n4 = RandUtils.nextInt(secureRandom, 1 << this.a);
        for (n2 = 0; n4 == 0 && n2 < n3; ++n2) {
            n4 = RandUtils.nextInt(secureRandom, 1 << this.a);
        }
        if (n2 == n3) {
            n4 = 1;
        }
        return n4;
    }

    public boolean isElementOfThisField(int n2) {
        if (this.a == 31) {
            return n2 >= 0;
        }
        return n2 >= 0 && n2 < 1 << this.a;
    }

    public String elementToStr(int n2) {
        String string = "";
        for (int i2 = 0; i2 < this.a; ++i2) {
            string = ((byte)n2 & 1) == 0 ? "0" + string : "1" + string;
            n2 >>>= 1;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mField)) {
            return false;
        }
        GF2mField gF2mField = (GF2mField)object;
        return this.a == gF2mField.a && this.b == gF2mField.b;
    }

    public int hashCode() {
        return this.b;
    }

    public String toString() {
        String string = "Finite Field GF(2^" + this.a + ") = GF(2)[X]/<" + GF2mField.a(this.b) + "> ";
        return string;
    }

    private static String a(int n2) {
        String string = "";
        if (n2 == 0) {
            string = "0";
        } else {
            byte by2 = (byte)(n2 & 1);
            if (by2 == 1) {
                string = "1";
            }
            n2 >>>= 1;
            int n3 = 1;
            while (n2 != 0) {
                by2 = (byte)(n2 & 1);
                if (by2 == 1) {
                    string = string + "+x^" + n3;
                }
                n2 >>>= 1;
                ++n3;
            }
        }
        return string;
    }
}

