/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHAKEDigest;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.spec.XMSSMTParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSMTKeyGenerationParameters a;
    private XMSSMTKeyPairGenerator b = new XMSSMTKeyPairGenerator();
    private ASN1ObjectIdentifier c;
    private SecureRandom d = new SecureRandom();
    private boolean e = false;

    public XMSSMTKeyPairGeneratorSpi() {
        super("XMSSMT");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof XMSSMTParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a XMSSMTParameterSpec");
        }
        XMSSMTParameterSpec xMSSMTParameterSpec = (XMSSMTParameterSpec)algorithmParameterSpec;
        if (xMSSMTParameterSpec.getTreeDigest().equals("SHA256")) {
            this.c = NISTObjectIdentifiers.id_sha256;
            this.a = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), new SHA256Digest()), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHA512")) {
            this.c = NISTObjectIdentifiers.id_sha512;
            this.a = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), new SHA512Digest()), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHAKE128")) {
            this.c = NISTObjectIdentifiers.id_shake128;
            this.a = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), new SHAKEDigest(128)), secureRandom);
        } else if (xMSSMTParameterSpec.getTreeDigest().equals("SHAKE256")) {
            this.c = NISTObjectIdentifiers.id_shake256;
            this.a = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(xMSSMTParameterSpec.getHeight(), xMSSMTParameterSpec.getLayers(), new SHAKEDigest(256)), secureRandom);
        }
        this.b.init(this.a);
        this.e = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.e) {
            this.a = new XMSSMTKeyGenerationParameters(new XMSSMTParameters(10, 20, new SHA512Digest()), this.d);
            this.b.init(this.a);
            this.e = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.b.generateKeyPair();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = (XMSSMTPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCXMSSMTPublicKey(this.c, xMSSMTPublicKeyParameters), new BCXMSSMTPrivateKey(this.c, xMSSMTPrivateKeyParameters));
    }
}

